/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.bookshelf2;

import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.tonouchi.bookshelf2.Book;
import org.tonouchi.bookshelf2.BookDataHolder;
import org.tonouchi.bookshelf2.BookDataHolderHolder;
import org.tonouchi.bookshelf2.BookDropTarget;
import org.tonouchi.bookshelf2.BookInfoPanel;
import org.tonouchi.bookshelf2.BookShelfComponentHolder;
import org.tonouchi.bookshelf2.BookShelfConfig;
import org.tonouchi.bookshelf2.BookShelfLibrary;
import org.tonouchi.bookshelf2.BookTableModel;
import org.tonouchi.bookshelf2.BookTableModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class App
implements MouseListener {
    private BookTableModel model = null;
    private JTable table = null;
    private BookInfoPanel importPanel = null;

    public static void main(String[] args) {
        if (args.length == 1) {
            BookShelfConfig.setBaseDirectory(args[0]);
        }
        App app = new App();
    }

    private App() {
        this.start();
    }

    private void check() {
        String bookShelfFile;
        File bsfile;
        String baseDirectory = BookShelfConfig.getBaseDirectory();
        File file = new File(baseDirectory);
        if (!file.exists()) {
            System.out.println("\u30e9\u30a4\u30d6\u30e9\u30ea\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210" + file.getAbsolutePath());
            file.mkdirs();
        }
        if (!(bsfile = new File(bookShelfFile = baseDirectory + "/bookshelf.xml")).exists()) {
            System.out.println("\u30e9\u30a4\u30d6\u30e9\u30ea\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210");
            BookShelfLibrary.write();
        }
    }

    private void start() {
        JFrame frame = new JFrame();
        BookDataHolder holder = new BookDataHolder();
        BookDataHolderHolder.setHolder(holder);
        this.check();
        BookShelfLibrary.read();
        BookDataHolderHolder.setHolder(holder);
        this.model = new BookTableModel();
        this.table = new JTable(this.model);
        this.model.addTableModelListener(new BookTableModelListener(this.table));
        this.table.addMouseListener(this);
        BorderLayout layout = new BorderLayout();
        this.table.setDropTarget(new BookDropTarget());
        frame.setDropTarget(new BookDropTarget());
        this.table.setCellSelectionEnabled(true);
        JScrollPane jscTable = new JScrollPane(this.table);
        this.importPanel = new BookInfoPanel();
        JPanel jpMain = new JPanel();
        jpMain.setLayout(layout);
        layout.addLayoutComponent(this.importPanel, "East");
        jpMain.add(this.importPanel);
        layout.addLayoutComponent(jscTable, "Center");
        jpMain.add(jscTable);
        frame.add(new JScrollPane(jpMain));
        frame.setDefaultCloseOperation(3);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                System.out.println("\u30b7\u30b9\u30c6\u30e0\u7d42\u4e86\u3001\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4fdd\u5b58");
                BookShelfLibrary.write();
            }
        }));
        BookShelfComponentHolder.setTable(this.table);
        frame.setSize(700, 560);
        frame.setVisible(true);
    }

    private static Book createBook(String author, String category, String comment, int pageNum, List<String> tags, String title, int rate) {
        Book book = new Book();
        book.setAuthor(author);
        book.setCategory(category);
        book.setComment(comment);
        book.setId(UUID.randomUUID().toString());
        book.setPageNum(pageNum);
        book.setTags(tags);
        book.setTitle(title);
        book.setRate(rate);
        return book;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        System.out.println("Clicked");
        this.updateInformation();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void updateInformation() {
        this.importPanel.updateInfo(BookDataHolderHolder.getBookDataHolder().getBook(this.table.getSelectedRow()));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

