package bodybuilder.inspector.servlet;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpSession;

import bodybuilder.inspector.Inspector;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.ServletObjectUtils;

/**
 * セッションインスペクター
 */
public class SessionInspector extends Inspector {

    /**
     * 二つのセッションが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // セッションを取得。
        HttpSession expectedSession = (HttpSession) expected;
        HttpSession actualSession = (HttpSession) actual;

        // 属性を取得。
        Map expectedAttrs = ServletObjectUtils
                .getSessionAttributes(expectedSession);
        Map actualAttrs = ServletObjectUtils
                .getSessionAttributes(actualSession);

        // 属性名を検査。
        Set expectedNameSet = expectedAttrs.keySet();
        assertKeySetEquals(expectedNameSet, actualAttrs.keySet(), trace);
        Iterator names = expectedNameSet.iterator();

        // 属性値を検査。
        while (names.hasNext()) {
            Object name = names.next();
            trace.appendKey(name);
            Object expectedElement = expectedAttrs.get(name);
            Object actualElement = actualAttrs.get(name);
            assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

}