package bodybuilder.builder.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.jdom.Element;

import com.mockrunner.mock.web.MockHttpServletRequest;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;

/**
 * リクエストビルダー
 */
public class RequestBuilder extends Builder {

    {
        // コンストラクタは受け取らない。
        hasConstructor = false;
    }

    /**
     * 属性メソッド名
     */
    private static final String METHOD_ATTR = "attr";

    /**
     * パラメータメソッド名
     */
    private static final String METHOD_PARAM = "param";

    /**
     * リクエストを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return リクエスト
     */
    public Object getMuscle(Element element, Argument constructor) {
        // モックリクエストを生成。
        HttpServletRequest request = new MockHttpServletRequest();
        // リクエストをセットアップ。
        setup(element, request);
        // リクエストを返す。
        return request;
    }

    /**
     * リクエストをセットアップする。
     * 
     * @param element XML要素
     * @param request リクエスト
     */
    public static void setup(Element element, HttpServletRequest request) {
        // モックリクエストの場合はパラメータをセット。
        if (request instanceof MockHttpServletRequest) {
            setParams(element, (MockHttpServletRequest) request);
        }

        // <attr>を取得。
        List attrs = element.getChildren(METHOD_ATTR);

        // 属性をリクエストにセット。
        for (int i = 0; i < attrs.size(); i++) {
            Element child = (Element) attrs.get(i);
            String name = getRequiredName(child);
            Object value = getValue(child);
            request.setAttribute(name, value);
        }
    }

    /**
     * モックリクエストにパラメータをセットする。
     * 
     * @param element 要素
     * @param request モックリクエスト
     */
    private static void setParams(Element element,
            MockHttpServletRequest request) {
        // パラメータを取得。
        Map paramMap = getParams(element);

        // リクエストにセット。
        Iterator names = paramMap.keySet().iterator();

        while (names.hasNext()) {
            String name = (String) names.next();
            String[] values = (String[]) paramMap.get(name);
            request.setupAddParameter(name, values);
        }
    }

    /**
     * パラメータのマップを取得する。
     * 
     * @param element 要素
     */
    public static Map getParams(Element element) {
        // <param>を取得。
        List params = element.getChildren(METHOD_PARAM);
        Map paramMap = new HashMap();

        // パラメータをマップにセット。
        for (int i = 0; i < params.size(); i++) {
            Element param = (Element) params.get(i);
            String name = getRequiredName(param);
            String value = getRequiredValueAttr(param);
            List values = (List) paramMap.get(name);

            if (values == null) {
                values = new ArrayList();
                paramMap.put(name, values);
            }

            values.add(value);
        }

        // マップにセットしたリストを配列に変換。
        if (paramMap.size() > 0) {
            Iterator names = paramMap.keySet().iterator();

            while (names.hasNext()) {
                String name = (String) names.next();
                List values = (List) paramMap.get(name);
                paramMap.put(name, (String[]) values.toArray(new String[values
                        .size()]));
            }
        }

        // マップを返す。
        return paramMap;
    }

}