package sample.testtarget.dicon.object.impl;

import bodybuilder.test.dicon.Component;
import sample.testtarget.dicon.object.Sysdate;
import sample.testtarget.dicon.util.ExDate;

/**
 * システム日時(実装)
 */
public class SysdateImpl implements Sysdate, Component {

    private static final String DATE_REGEX = "^[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}$";

    private ExDate now = null;

    public SysdateImpl(String date) {
        if (date != null && date.matches(DATE_REGEX)) {
            now = new ExDate(date);
        }
    }

    public ExDate getNow() {
        return now;
    }

    public void create() {
        System.out.println("★★★★★ SysdateImpl生成時処理");
    }

    public void success() {
        System.out.println("★★★★★ SysdateImpl成功時処理");
    }

    public void failure() {
        System.out.println("★★★★★ SysdateImpl失敗時処理");
    }

    public void windup() {
        System.out.println("★★★★★ SysdateImpl終了時処理");
    }

}