package sample.builder;

import java.io.InputStream;

import bodybuilder.builder.Bullworker;
import bodybuilder.viewer.Viewer;

import sample.util.SampleUtils;

public class Sample03 {

    public static void main(String[] args) {
        InputStream in = SampleUtils
                .getResourceAsStream("sample/builder/data/sample03.xml");
        // ブルワーカを生成。
        Bullworker bullworker = new Bullworker(in);
        SampleUtils.closeInputStream(in);

        // 動的に実装されたビーンを取得。
        Object obj = bullworker.getMuscle();

        // オブジェクトをダンプ。
        Viewer.dump(obj);
    }

}