/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import java.io.File;

public class FileUtils {
    public static String getExt(String filename) {
        int pos = filename.lastIndexOf(".");
        if (pos >= 0) {
            return filename.substring(pos + 1);
        }
        return null;
    }

    public static String removeExt(String filename) {
        int pos = filename.lastIndexOf(".");
        if (pos >= 0) {
            filename = filename.substring(0, pos);
        }
        return filename;
    }

    public static boolean isFullPath(String filename) {
        return filename.matches("^[/\\\\].*$") || filename.matches("^[A-Za-z]:.*$");
    }

    public static String removeEndSeparator(String path) {
        if (path.endsWith(File.separator)) {
            int end = path.length() - File.separator.length();
            path = path.substring(0, end);
        }
        return path;
    }

    public static String removeDriveLetter(String path) {
        return path.replaceAll("^[A-Za-z]:", "");
    }

    public static String toDotSeparatedValue(String path) {
        path = FileUtils.removeDriveLetter(path);
        path = FileUtils.removeExt(path);
        path = path.replaceAll("^[/\\\\]", "");
        path = path.replaceAll("[/\\\\]", ".");
        return path;
    }

    public static String trim(String path, int depth) {
        path = FileUtils.removeDriveLetter(path);
        String[] pathElem = path.split("[/\\\\]");
        StringBuffer buf = new StringBuffer();
        int len = pathElem.length;
        int start = len - depth;
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < len; ++i) {
            buf.append(File.separatorChar);
            buf.append(pathElem[i]);
        }
        buf.deleteCharAt(0);
        return buf.toString();
    }
}

