package bodybuilder.test.common;

import org.jdom.Element;

import bodybuilder.builder.argument.Argument;
import bodybuilder.builder.argument.ArgumentBuilder;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * ターゲット
 */
public class Target {

    /**
     * ターゲット名
     */
    private String name = null;

    /**
     * コンストラクタ
     */
    private Argument constructor = new Argument();

    /**
     * コンストラクタ
     * 
     * @param target ターゲット要素
     */
    public Target(Element target) {
        // ターゲット名を取得。
        name = JDOMUtils.getRequiredAttrValue(target, "name");

        // <arg>がある場合はコンストラクタを取得。
        if (JDOMUtils.hasChild(target, ArgumentBuilder.METHOD_NAME)) {
            constructor = ArgumentBuilder.getArgument(target);
        }
    }

    /**
     * ターゲット名を取得する。
     * 
     * @return ターゲット名
     */
    public String getName() {
        return name;
    }

    /**
     * コンストラクタを取得する。
     * 
     * @return コンストラクタ
     */
    public Argument getConstructor() {
        return constructor;
    }

}