package bodybuilder.builder.bean;

import java.lang.reflect.Proxy;

/**
 * ダイナミックビーン
 */
public class DynaBean {

    /**
     * ビーンの型
     */
    private Class clazz = null;

    /**
     * コンストラクタ。
     * 
     * @param clazz ビーンの型
     */
    public DynaBean(Class clazz) {
        this.clazz = clazz;
    }

    /**
     * ビーンのインスタンスを生成する。
     * 
     * @return ビーンのインスタンス
     */
    public Object newInstance() {
        // プロキシでビーンを動的に実装。
        return Proxy.newProxyInstance(clazz.getClassLoader(),
                new Class[] { clazz }, new DynaBeanInvocationHandler());
    }

}