package bodybuilder.builder;

import org.jdom.Element;

import bodybuilder.builder.argument.Argument;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * 拡張文字列ビルダー
 */
public class ExtendedStringBuilder extends Builder {

    {
        // 子要素は定義できない。
        hasChild = false;
    }

    /**
     * trim属性
     */
    private static final String ATTR_TRIM = "trim";

    /**
     * 改行を含む文字列を取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return 改行を含む文字列
     */
    public Object getMuscle(Element element, Argument constructor) {
        // トリムフラグを取得。
        boolean isTrim = JDOMUtils.getAttrBoolValue(element, ATTR_TRIM);
        // XML要素に含まれるテキストを取得。
        String str = element.getText();

        // トリムフラグがtrueの場合は文字列をトリム。
        if (isTrim) {
            str = str.trim();
        }

        // 文字列を返す。
        return str;
    }

}