package sample.testtarget.dicon.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * 拡張日付クラス
 */
public class ExDate extends java.util.Date {

    private static final SimpleDateFormat format = new SimpleDateFormat(
            "yyyy-MM-dd HH:mm:ss");

    public ExDate(java.util.Date date) {
        super(date.getTime());
    }

    public ExDate(String date) {
        try {
            setTime(format.parse(date).getTime());
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Timestamp getTimestamp() {
        return new Timestamp(getTime());
    }

    public static ExDate valueOf(java.util.Date date) {
        return new ExDate(date);
    }

}