/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util.dbunit;

import bodybuilder.util.dbunit.JxlTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;

public class JxlDataSet
extends AbstractDataSet {
    private ITable[] tables = null;

    public JxlDataSet(File file) throws IOException, DataSetException {
        FileInputStream fin = new FileInputStream(file);
        this.loadTables(fin);
        fin.close();
    }

    public JxlDataSet(InputStream in) throws IOException, DataSetException {
        this.loadTables(in);
    }

    private void loadTables(InputStream in) throws IOException, DataSetException {
        try {
            Workbook workbook = Workbook.getWorkbook((InputStream)in);
            this.tables = new ITable[workbook.getNumberOfSheets()];
            for (int i = 0; i < this.tables.length; ++i) {
                this.tables[i] = new JxlTable(workbook.getSheet(i));
            }
        }
        catch (BiffException e) {
            throw new DataSetException((Throwable)e);
        }
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        return new DefaultTableIterator(this.tables, reversed);
    }
}

