/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.util;

import java.util.Arrays;
import java.util.List;

public class Utils {
    public static final String NL = System.getProperty("line.separator");

    public static String join(List list, String sep) {
        if (list == null) {
            return null;
        }
        if (list.size() < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(list.get(0) != null ? list.get(0).toString() : "");
        for (int i = 1; i < list.size(); ++i) {
            buf.append(sep);
            buf.append(list.get(i) != null ? list.get(i).toString() : "");
        }
        return buf.toString();
    }

    public static String[] toStringArray(String str) {
        return str.split(NL);
    }

    public static String[] decorate(String[] body) {
        String stretcher;
        int len;
        int i;
        String[] buf = new String[body.length + 2];
        int max = 0;
        for (i = 0; i < body.length; ++i) {
            body[i] = body[i].replaceAll("\t", "    ");
            len = Utils.len(body[i]);
            if (len <= max) continue;
            max = len;
        }
        for (i = 0; i < body.length; ++i) {
            len = Utils.len(body[i]);
            StringBuffer line = new StringBuffer(body[i]);
            if (len < max) {
                for (int j = 0; j < max - len; ++j) {
                    line.append(' ');
                }
            }
            line.insert(0, '|');
            line.append('|');
            buf[i + 1] = line.toString();
        }
        char[] cs = new char[max + 2];
        Arrays.fill(cs, '-');
        cs[0] = 43;
        cs[cs.length - 1] = 43;
        buf[0] = stretcher = new String(cs);
        buf[buf.length - 1] = stretcher;
        return buf;
    }

    public static int len(String str) {
        char[] cs = str.toCharArray();
        int len = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] > '\u007f') {
                len += 2;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static String formatSlash(String str) {
        return Utils.formatSlash(str, true, false);
    }

    public static String formatSlash(String str, boolean start, boolean end) {
        if (str == null) {
            return str;
        }
        if (start && !str.startsWith("/")) {
            str = "/" + str;
        } else if (!start && str.startsWith("/")) {
            str = str.substring(1);
        }
        if (end && !str.endsWith("/")) {
            str = str + "/";
        } else if (!end && str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String escapeReplaceString(String src) {
        if (src == null || src.indexOf(36) < 0 && src.indexOf(92) < 0) {
            return src;
        }
        char[] cs = src.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == '$' || cs[i] == '\\') {
                buf.append('\\');
            }
            buf.append(cs[i]);
        }
        return buf.toString();
    }
}

