/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector;

import bodybuilder.inspector.Inspector;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.Config;
import bodybuilder.util.ExtendedPropertyUtils;
import bodybuilder.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanInspector
extends Inspector {
    private static Map ignorePropertiesCache = null;

    public void assertEquals(Object expected, Object actual, ObjectBackTrace trace) {
        Map expectedProps = ExtendedPropertyUtils.getProperties(expected);
        Map actualProps = ExtendedPropertyUtils.getProperties(actual);
        Set expectedNameSet = expectedProps.keySet();
        BeanInspector.assertKeySetEquals(expectedNameSet, actualProps.keySet(), trace);
        Iterator names = expectedNameSet.iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            if (this.isIgnoreProperty(expected, name)) continue;
            trace.appendKey(name);
            Object expectedElement = expectedProps.get(name);
            Object actualElement = actualProps.get(name);
            BeanInspector.assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

    private boolean isIgnoreProperty(Object obj, String name) {
        if (ignorePropertiesCache == null) {
            ignorePropertiesCache = Config.getIgnoreProperties();
        }
        List classNames = ObjectUtils.getClassNames(obj.getClass());
        for (int i = 0; i < classNames.size(); ++i) {
            String className = (String)classNames.get(i);
            String pkg = ObjectUtils.getPackage(className, true);
            List ignoreProps = (List)ignorePropertiesCache.get(className);
            if (ignoreProps == null) {
                ignoreProps = (List)ignorePropertiesCache.get(pkg);
            }
            if (ignoreProps == null || !ignoreProps.contains(name)) continue;
            return true;
        }
        return false;
    }
}

