/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.builder.servlet;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;
import com.mockrunner.mock.web.MockHttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Element;

public class RequestBuilder
extends Builder {
    private static final String METHOD_ATTR = "attr";
    private static final String METHOD_PARAM = "param";

    public RequestBuilder() {
        this.hasConstructor = false;
    }

    public Object getMuscle(Element element, Argument constructor) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        RequestBuilder.setup(element, (HttpServletRequest)request);
        return request;
    }

    public static void setup(Element element, HttpServletRequest request) {
        if (request instanceof MockHttpServletRequest) {
            RequestBuilder.setParams(element, (MockHttpServletRequest)request);
        }
        List attrs = element.getChildren(METHOD_ATTR);
        for (int i = 0; i < attrs.size(); ++i) {
            Element child = (Element)attrs.get(i);
            String name = RequestBuilder.getRequiredName(child);
            Object value = RequestBuilder.getValue(child);
            request.setAttribute(name, value);
        }
    }

    private static void setParams(Element element, MockHttpServletRequest request) {
        Map paramMap = RequestBuilder.getParams(element);
        Iterator names = paramMap.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            String[] values = (String[])paramMap.get(name);
            request.setupAddParameter(name, values);
        }
    }

    public static Map getParams(Element element) {
        List params = element.getChildren(METHOD_PARAM);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (int i = 0; i < params.size(); ++i) {
            Element param = (Element)params.get(i);
            String name = RequestBuilder.getRequiredName(param);
            String value = RequestBuilder.getRequiredValueAttr(param);
            ArrayList<String> values = (ArrayList<String>)paramMap.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                paramMap.put(name, values);
            }
            values.add(value);
        }
        if (paramMap.size() > 0) {
            Iterator names = paramMap.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                List values = (List)paramMap.get(name);
                paramMap.put(name, values.toArray(new String[values.size()]));
            }
        }
        return paramMap;
    }
}

