/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.viewer;

import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;
import bodybuilder.util.Utils;
import bodybuilder.viewer.Viewer;
import bodybuilder.viewer.handler.OutputHandler;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionViewer
extends Viewer {
    public void output(Object object, OutputHandler handler) {
        Exception e = (Exception)object;
        handler.print(ObjectUtils.getInfo(object) + " {");
        handler.indent();
        if (e.getMessage() != null) {
            handler.print("[message]=>");
            ExceptionViewer.dump(e.getMessage(), handler);
        }
        if (Config.isViewPrintStackTrace()) {
            String[] trace = Utils.decorate(this.getStackTrace(e));
            handler.print("[stacktrace]=>");
            for (int i = 0; i < trace.length; ++i) {
                handler.print(trace[i]);
            }
        }
        if (e.getCause() != null) {
            handler.print("[cause]=>");
            ExceptionViewer.dump(e.getCause(), handler);
        }
        handler.unindent();
        handler.print("}");
    }

    private String[] getStackTrace(Exception e) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        e.printStackTrace(printer);
        String trace = writer.toString();
        return Utils.toStringArray(trace);
    }
}

