/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.value;

/**
 * The interface for ASN.1 string items.
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
public interface StringItem {

	/**
	 * Returns the string value of this item.
	 * 
	 * @return The string value.
	 */
	public String string();

	/**
	 * Converts the value of this item to an array of {@code boolean}.
	 * 
	 * @return An array of {@code boolean}.
	 */
	public boolean[] toBinArray();

	/**
	 * Converts the value of this item to an array of {@code byte}.
	 * 
	 * @return An array of {@code byte}.
	 */
	public byte[] toByteArray();
	
}
