/*
 * Copyright 2011 BitMeister Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.bitmeister.asn1.codec.xer;

/**
 * XER constants.
 * 
 * <p>
 * This class contains some constants used by XER codec.
 * </p>
 * 
 * @author WATANABE, Jun. <jwat at bitmeister.jp>
 */
class XerConstants {
	static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
	static final String TAG_START = "<";
	static final String END_TAG_START = "</";
	static final String TAG_END = ">";
	static final String SINGLE_TAG_END = "/>";
	static final String BOOLEAN_TRUE = "true";
	static final String BOOLEAN_FALSE = "false";
	static final String REAL_PLUS_INFINITY = "PLUS-INFINITY";
	static final String REAL_MINUS_INFINITY = "MINUS-INFINITY";
	static final String REAL_ZERO = "0";
}
