/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.value;

import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.value.StringItem;

public class HexString
implements StringItem {
    private String string;

    public HexString(String string) {
        if (!string.matches("[0-9A-Fa-f]*")) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("Invalid string '" + string + "'. hString must consist of hexadecimal string.", null, null, null, null);
            throw ex;
        }
        this.string = string.trim().toUpperCase();
    }

    public HexString(byte ... array) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Byte b = byArray[n2];
            builder.append(String.format("%02X", b));
            ++n2;
        }
        this.string = builder.toString();
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public boolean[] toBinArray() {
        boolean[] array = new boolean[this.string.length() * 4];
        int index = 0;
        int mask = 0;
        byte octet = 0;
        int i = 0;
        while (i < array.length) {
            if (mask == 0) {
                octet = Byte.parseByte(this.string.substring(index++, index), 16);
                mask = 8;
            }
            array[i] = (octet & mask) > 0;
            mask >>>= 1;
            ++i;
        }
        return array;
    }

    @Override
    public byte[] toByteArray() {
        byte[] array = new byte[this.string.length() / 2 + this.string.length() % 2];
        byte octet = 0;
        int i = 0;
        while (i < this.string.length()) {
            octet = Integer.valueOf(this.string.substring(i, i + 1), 16).byteValue();
            array[i / 2] = i % 2 == 0 ? (byte)(octet << 4) : (byte)(array[i / 2] + octet);
            ++i;
        }
        return array;
    }

    public String toString() {
        return String.valueOf('\'') + this.string + "'H";
    }
}

