/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.value;

import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.value.StringItem;

public class BinString
implements StringItem {
    private String string;

    public BinString(String string) {
        if (!string.matches("[01 ]*")) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("Invalid string '" + string + "'. bString shall consist of '0's and '1's.", null, null, null, null);
            throw ex;
        }
        this.string = string.trim();
    }

    public BinString(boolean ... array) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            builder.append(array[i] ? (char)'1' : '0');
            ++i;
        }
        this.string = builder.toString();
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public boolean[] toBinArray() {
        boolean[] array = new boolean[this.string.length()];
        int i = 0;
        while (i < array.length) {
            array[i] = this.string.charAt(i) == '1';
            ++i;
        }
        return array;
    }

    @Override
    public byte[] toByteArray() {
        byte[] array = new byte[this.string.length() / 8 + 1];
        int index = 0;
        int shift = 7;
        int i = 0;
        while (i < this.string.length()) {
            if (this.string.charAt(i) == '1') {
                int n = index;
                array[n] = (byte)(array[n] | 1 << shift);
            }
            if (--shift < 0) {
                shift = 7;
                ++index;
            }
            ++i;
        }
        return array;
    }

    public String toString() {
        return String.valueOf('\'') + this.string + "'B";
    }
}

