/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type.useful;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.TimeType;

@ASN1BuiltIn
@ASN1Tag(tagClass=ASN1TagClass.UNIVERSAL, value=23, tagMode=ASN1TagMode.IMPLICIT)
public class UTCTime
extends TimeType {
    private static final Pattern pattern = Pattern.compile("\\d{10}(\\d{2})?(Z|(\\+|\\-)\\d{4})?");
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyMMddHHmmssZ");
        }
    };

    public UTCTime() {
    }

    public UTCTime(String value) {
        this.set(value);
    }

    public UTCTime(Date value) {
        this.set(value);
    }

    @Override
    protected Pattern pattern() {
        return pattern;
    }

    @Override
    protected Date parseDate(String time, String differential) {
        StringBuilder builder = new StringBuilder(time);
        if (time.length() <= 10) {
            builder.append("00");
        }
        try {
            return DATE_FORMAT.get().parse(time.concat(differential));
        }
        catch (ParseException e) {
            ASN1RuntimeException ex = new ASN1RuntimeException();
            ex.setMessage("Failed to parse the argument string '" + time.concat(differential) + "'.", e, this.getClass(), null, null);
            throw ex;
        }
    }

    @Override
    public DateFormat form() {
        return DATE_FORMAT.get();
    }
}

