/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type.useful;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.TimeType;

@ASN1BuiltIn
@ASN1Tag(tagClass=ASN1TagClass.UNIVERSAL, value=24, tagMode=ASN1TagMode.IMPLICIT)
public class GeneralizedTime
extends TimeType {
    private static final Pattern pattern = Pattern.compile("\\d{10}(\\d{2}(\\d{2}((\\.|\\,)\\d*)?)?)?(Z|(\\+|\\-)\\d{4})?");
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
        }
    };

    public GeneralizedTime() {
    }

    public GeneralizedTime(String value) {
        this.set(value);
    }

    public GeneralizedTime(Date value) {
        this.set(value);
    }

    @Override
    public DateFormat form() {
        return DATE_FORMAT.get();
    }

    @Override
    protected Pattern pattern() {
        return pattern;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Date parseDate(String time, String differential) {
        block7: {
            block6: {
                builder = new StringBuilder(time);
                if (builder.length() == 10) {
                    builder.append("00");
                }
                if (builder.length() == 12) {
                    builder.append("00");
                }
                if (builder.length() <= 14) break block6;
                if (builder.charAt(14) == ',') {
                    builder.setCharAt(14, '.');
                }
                if (builder.length() <= 18) ** GOTO lbl16
                builder.setLength(18);
                break block7;
lbl-1000:
                // 1 sources

                {
                    builder.append('0');
lbl16:
                    // 2 sources

                    ** while (builder.length() < 18)
                }
lbl17:
                // 1 sources

                break block7;
            }
            builder.append(".000");
        }
        builder.append(differential);
        try {
            return GeneralizedTime.DATE_FORMAT.get().parse(builder.toString());
        }
        catch (ParseException e) {
            ex = new ASN1RuntimeException();
            ex.setMessage("Failed to parse the argument string '" + builder + "'.", e, this.getClass(), null, null);
            throw ex;
        }
    }
}

