/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type.builtin;

import java.util.Arrays;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.annotation.ASN1XmlTypeName;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.Concatenatable;
import jp.bitmeister.asn1.type.PrimitiveType;
import jp.bitmeister.asn1.type.SizeCountable;
import jp.bitmeister.asn1.value.StringItem;

@ASN1BuiltIn
@ASN1Identifier(value="OCTET STRING")
@ASN1XmlTypeName(value="OCTET_STRING")
@ASN1Tag(tagClass=ASN1TagClass.UNIVERSAL, value=4, tagMode=ASN1TagMode.IMPLICIT)
public class OCTET_STRING
extends PrimitiveType<byte[]>
implements Concatenatable<OCTET_STRING>,
SizeCountable {
    public OCTET_STRING() {
    }

    public OCTET_STRING(byte ... value) {
        this.set(value);
    }

    public OCTET_STRING(StringItem item) {
        this.set(item);
    }

    @Override
    public void set(StringItem item) {
        this.set(item.toByteArray());
    }

    @Override
    public void concatenate(OCTET_STRING data) {
        if (data == null) {
            return;
        }
        if (!this.getClass().equals(data.getClass())) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("The type '" + data.specification().fullIdentifier() + "' of the data to be concatenated is not the same type of this instance.", null, this.getClass(), null, null);
            throw ex;
        }
        if (data.hasValue()) {
            if (!this.hasValue()) {
                this.set((byte[])data.value());
            } else {
                byte[] newValue = new byte[((byte[])this.value()).length + ((byte[])data.value()).length];
                System.arraycopy(this.value(), 0, newValue, 0, ((byte[])this.value()).length);
                System.arraycopy(data.value(), 0, newValue, ((byte[])this.value()).length, ((byte[])data.value()).length);
                this.set(newValue);
            }
        }
    }

    @Override
    public int size() {
        return ((byte[])this.value()).length;
    }

    @Override
    protected byte[] cloneValue() {
        return (byte[])((byte[])this.value()).clone();
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof OCTET_STRING) {
            byte[] otherValue = (byte[])((OCTET_STRING)other).value();
            if (this.value() != null) {
                return Arrays.equals((byte[])this.value(), otherValue);
            }
            return otherValue == null;
        }
        return false;
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }
}

