/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type.builtin;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Enumeration;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.PrimitiveType;
import jp.bitmeister.asn1.type.ValueComparable;
import jp.bitmeister.asn1.type.builtin.ENUMERATED;

@ASN1BuiltIn
@ASN1Tag(tagClass=ASN1TagClass.UNIVERSAL, value=2, tagMode=ASN1TagMode.IMPLICIT)
public class INTEGER
extends PrimitiveType<BigInteger>
implements ValueComparable {
    private static final Map<Class<? extends INTEGER>, Map<BigInteger, String>> NAMED_NUMBER_MAPS = new HashMap<Class<? extends INTEGER>, Map<BigInteger, String>>();

    static {
        NAMED_NUMBER_MAPS.put(INTEGER.class, new HashMap());
    }

    private static Map<BigInteger, String> getNamedNumberMap(Class<? extends INTEGER> type) {
        if (NAMED_NUMBER_MAPS.containsKey(type)) {
            return NAMED_NUMBER_MAPS.get(type);
        }
        Map<BigInteger, String> map = new HashMap<BigInteger, String>();
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(ASN1Enumeration.class)) {
                BigInteger value;
                String fieldId;
                int modifier = 25;
                ASN1Identifier id = f.getAnnotation(ASN1Identifier.class);
                String string = fieldId = id != null ? id.value() : f.getName();
                if ((f.getModifiers() & 0x19) != 25) {
                    ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                    ex.setMessage("An enumeration must be a public static final field.", null, type, fieldId, null);
                    throw ex;
                }
                if (f.getType() == BigInteger.class) {
                    try {
                        value = (BigInteger)f.get(null);
                    }
                    catch (Exception e) {
                        ASN1RuntimeException ex = new ASN1RuntimeException();
                        ex.setMessage("Failed to retreave the BigInteger value.", e, type, fieldId, null);
                        throw ex;
                    }
                } else if (f.getType() == Integer.TYPE || f.getType() == Long.TYPE) {
                    try {
                        value = BigInteger.valueOf(f.getLong(null));
                    }
                    catch (Exception e) {
                        ASN1RuntimeException ex = new ASN1RuntimeException();
                        ex.setMessage("Failed to convert the value to BigInteger.", e, type, fieldId, null);
                        throw ex;
                    }
                } else {
                    ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                    ex.setMessage("An enumeration must be an 'int', 'long' or 'BigInteger' field.", null, type, fieldId, null);
                    throw ex;
                }
                if (map.containsKey(value)) {
                    ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                    ex.setMessage("Each number of enumerations shall be distinct from all other enumerations in the type.", null, type, fieldId, null);
                    throw ex;
                }
                map.put(value, fieldId);
            }
            ++n2;
        }
        Class<? extends INTEGER> parent = type.getSuperclass();
        if (parent == ENUMERATED.class) {
            if (map.isEmpty()) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("ENUMERATED type shall have at least one enumeration item.", null, type, null, null);
                throw ex;
            }
        } else if (parent != INTEGER.class) {
            if (!map.isEmpty()) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("A class that does not extend 'INTEGER' or 'ENUMERATED' directly, can not have own enumerations.", null, type, null, null);
                throw ex;
            }
            map = INTEGER.getNamedNumberMap(parent);
        }
        NAMED_NUMBER_MAPS.put(type, map);
        return map;
    }

    public INTEGER() {
    }

    public INTEGER(BigInteger value) {
        this.set(value);
    }

    public INTEGER(long value) {
        this.set(value);
    }

    @Override
    public void set(BigInteger value) {
        Map<BigInteger, String> map = INTEGER.getNamedNumberMap(this.getClass());
        if (!map.isEmpty() && !map.containsKey(value)) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("Invalid value '" + value + "'. If a class has enumerations, the value must be same as one of them.", null, this.getClass(), null, null);
            throw ex;
        }
        super.set(value);
    }

    @Override
    public void set(long value) {
        this.set(BigInteger.valueOf(value));
    }

    @Override
    public void set(String nameOfNumber) {
        Map.Entry<BigInteger, String> e2;
        for (Map.Entry<BigInteger, String> e2 : INTEGER.getNamedNumberMap(this.getClass()).entrySet()) {
            if (!((String)e2.getValue()).equals(nameOfNumber)) continue;
            this.set((BigInteger)e2.getKey());
            return;
        }
        e2 = new ASN1IllegalArgument();
        ((ASN1RuntimeException)((Object)e2)).setMessage("The name '" + nameOfNumber + "' is not defined in this type.", null, this.getClass(), null, null);
        throw e2;
    }

    public String identifier() {
        return INTEGER.getNamedNumberMap(this.getClass()).get(this.value());
    }

    public boolean isLongValue() {
        return ((BigInteger)this.value()).compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0 && ((BigInteger)this.value()).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0;
    }

    public boolean isIntValue() {
        return ((BigInteger)this.value()).compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0 && ((BigInteger)this.value()).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0;
    }

    public long longValue() {
        return ((BigInteger)this.value()).longValue();
    }

    public int intValue() {
        return ((BigInteger)this.value()).intValue();
    }

    @Override
    public int compareTo(ASN1Type other) {
        return ((BigInteger)this.value()).compareTo((BigInteger)((INTEGER)other).value());
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }
}

