/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.ArrayList;
import java.util.List;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.type.ElementsChecker;
import jp.bitmeister.asn1.type.NamedTypeSpecification;
import jp.bitmeister.asn1.type.StructuredType;

class UnorderedElementsChecker
extends ElementsChecker {
    private List<NamedTypeSpecification> untagged = new ArrayList<NamedTypeSpecification>();

    UnorderedElementsChecker(Class<? extends StructuredType> type) {
        super(type);
    }

    void check(NamedTypeSpecification[] elements) {
        NamedTypeSpecification[] namedTypeSpecificationArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            NamedTypeSpecification e = namedTypeSpecificationArray[n2];
            if (e.tag() == null) {
                this.checkUntagged(e);
            } else {
                this.checkTagDuplication(e);
            }
            ++n2;
        }
    }

    private void checkUntagged(NamedTypeSpecification element) {
        for (NamedTypeSpecification u : this.untagged) {
            if (element == u || !element.isSameType(u)) continue;
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("Ambiguous element declaration. Check '" + u.identifier() + "'.", null, this.type, element.identifier(), null);
            throw ex;
        }
        this.untagged.add(element);
    }
}

