/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.nio.charset.Charset;
import java.util.regex.Pattern;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;

public abstract class StringType
extends OCTET_STRING {
    @Override
    public void set(String value) {
        this.checkCharacters(value);
        this.set(value.getBytes(this.charset()));
    }

    public String stringValue() {
        return new String((byte[])this.value(), this.charset());
    }

    protected abstract Charset charset();

    protected abstract Pattern pattern();

    protected void checkCharacters(String value) {
        if (this.pattern() != null && !this.pattern().matcher(value).matches()) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("The value '" + value + "' contains characters which are not allowed to be contained in this type or is in invalid format for this type.", null, this.getClass(), null, null);
            throw ex;
        }
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }
}

