/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import jp.bitmeister.asn1.annotation.ASN1DefinedTypes;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1ImportedModules;
import jp.bitmeister.asn1.annotation.ASN1ModuleTags;
import jp.bitmeister.asn1.type.ASN1TagDefault;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.BuiltInModule;
import jp.bitmeister.asn1.type.ModuleSpecification;

public abstract class ASN1Module {
    static ASN1TagDefault tagDefault(Class<? extends ASN1Module> module) {
        if (module.isAnnotationPresent(ASN1ModuleTags.class)) {
            return module.getAnnotation(ASN1ModuleTags.class).value();
        }
        return ASN1TagDefault.EXPLICIT_TAGS;
    }

    static String identifier(Class<? extends ASN1Module> module) {
        if (module.isAnnotationPresent(ASN1Identifier.class)) {
            return module.getAnnotation(ASN1Identifier.class).value();
        }
        return module.getSimpleName();
    }

    static boolean isUniversal(Class<? extends ASN1Module> module) {
        return module == BuiltInModule.class;
    }

    static void registerTypes(Class<? extends ASN1Module> module, ModuleSpecification spec) {
        Class<Object> e;
        Class<Object>[] classArray = module.getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            e = classArray[n2];
            if (ASN1Type.class.isAssignableFrom(e)) {
                Class<?> type = e;
                spec.register(type);
            }
            ++n2;
        }
        if (module.isAnnotationPresent(ASN1DefinedTypes.class)) {
            classArray = module.getAnnotation(ASN1DefinedTypes.class).value();
            n = classArray.length;
            n2 = 0;
            while (n2 < n) {
                e = classArray[n2];
                spec.register(e);
                ++n2;
            }
        }
    }

    static void importModules(Class<? extends ASN1Module> module, ModuleSpecification spec) {
        if (module.isAnnotationPresent(ASN1ImportedModules.class)) {
            Class<? extends ASN1Module>[] classArray = module.getAnnotation(ASN1ImportedModules.class).value();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends ASN1Module> e = classArray[n2];
                spec.imports(e);
                ++n2;
            }
        }
    }
}

