/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.exception;

import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.type.ASN1Type;

class DetailedMessage {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private String description;
    private Throwable cause;
    private Class<? extends ASN1Type> type;
    private String element;
    private ASN1Type data;

    DetailedMessage(String description, Throwable cause, Class<? extends ASN1Type> type, String element, ASN1Type data) {
        this.description = description;
        this.cause = cause;
        this.type = type;
        this.element = element;
        this.data = data;
    }

    String getMessage() {
        StringBuilder builder = new StringBuilder();
        if (this.description != null) {
            builder.append(NEW_LINE).append(" *** ").append(this.description);
        }
        if (this.type != null) {
            builder.append(NEW_LINE).append("\tWhile processing ASN.1 type '");
            ASN1Identifier id = this.type.getAnnotation(ASN1Identifier.class);
            if (id != null) {
                builder.append(id.value());
            } else {
                builder.append(this.type.getSimpleName());
            }
            builder.append('\'');
            if (this.element != null) {
                builder.append(", element '").append(this.element).append('\'');
            }
        }
        if (this.data != null) {
            builder.append(NEW_LINE).append("\tData description :").append(NEW_LINE);
            try {
                String[] strings = this.data.toString().split(NEW_LINE);
                int i = 0;
                while (true) {
                    builder.append("\t\t").append(strings[i]);
                    if (++i != strings.length) {
                        builder.append(NEW_LINE);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                builder.append("\t\t").append("(Failed to convert the ASN.1 data to text.)").append(NEW_LINE);
            }
        }
        return builder.toString();
    }

    Throwable getCause() {
        return this.cause;
    }
}

