/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.codec.xer;

class XerStringEscapeUtil {
    private static final String AMP = "amp";
    private static final String LT = "lt";
    private static final String GT = "gt";
    private static final String[] CTRL = new String[]{"nul", "soh", "stx", "etx", "eot", "enq", "ack", "bel", "bs", "", "", "vt", "ff", "", "so", "si", "dle", "dc1", "dc2", "dc3", "dc4", "nak", "syn", "etb", "can", "em", "sub", "esc", "is4", "is3", "is2", "is1"};

    XerStringEscapeUtil() {
    }

    static String escape(String string) {
        StringBuilder builder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                builder.append("<").append(CTRL[c]).append("/>");
            } else if (c == '&') {
                builder.append('&').append(AMP).append(';');
            } else if (c == '<') {
                builder.append('&').append(LT).append(';');
            } else if (c == '>') {
                builder.append('&').append(GT).append(';');
            } else {
                builder.append(c);
            }
            ++n2;
        }
        return builder.toString();
    }

    static char unescapeCtrl(String string) {
        char i = '\u0000';
        while (i < CTRL.length) {
            if (string.equals(CTRL[i])) {
                return i;
            }
            i = (char)(i + '\u0001');
        }
        return '\u0000';
    }
}

