/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.codec.ber;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import jp.bitmeister.asn1.codec.ber.BerEncoder;
import jp.bitmeister.asn1.codec.ber.ConstructedOctets;
import jp.bitmeister.asn1.codec.ber.EncodedOctets;
import jp.bitmeister.asn1.exception.ASN1EncodingException;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.ConstructiveType;
import jp.bitmeister.asn1.type.ElementSpecification;
import jp.bitmeister.asn1.type.TimeType;
import jp.bitmeister.asn1.type.builtin.BIT_STRING;
import jp.bitmeister.asn1.type.builtin.REAL;
import jp.bitmeister.asn1.type.builtin.SET;
import jp.bitmeister.asn1.type.builtin.SET_OF;
import jp.bitmeister.asn1.type.useful.UTCTime;

public class DerEncoder
extends BerEncoder {
    public DerEncoder(OutputStream out) {
        super(out);
    }

    @Override
    public EncodedOctets visit(REAL data) {
        byte[] encoded;
        if ((Double)data.value() == 0.0) {
            encoded = new byte[]{};
        } else if (((Double)data.value()).isInfinite()) {
            encoded = new byte[]{(Double)data.value() == Double.POSITIVE_INFINITY ? (byte)64 : 65};
        } else if (data.isBinary()) {
            long bits = Double.doubleToLongBits((Double)data.value());
            int exponent = (int)(bits >> 52 & 0x7FFL) - 1075;
            long mantissa = bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            while ((mantissa & 1L) == 0L) {
                mantissa >>= 1;
                ++exponent;
            }
            int expLen = exponent > 127 || exponent < -128 ? 2 : 1;
            byte[] mOctets = BigInteger.valueOf(mantissa).toByteArray();
            encoded = new byte[1 + expLen + mOctets.length];
            encoded[0] = -128;
            if ((bits & Long.MIN_VALUE) != 0L) {
                encoded[0] = (byte)(encoded[0] | 0x40);
            }
            if (expLen == 2) {
                encoded[0] = (byte)(encoded[0] | 1);
                encoded[1] = (byte)(exponent >> 8);
                encoded[2] = (byte)exponent;
            } else {
                encoded[1] = (byte)exponent;
            }
            System.arraycopy(mOctets, 0, encoded, 1 + expLen, mOctets.length);
        } else {
            BigDecimal value = BigDecimal.valueOf((Double)data.value()).stripTrailingZeros();
            int exponent = -value.scale();
            long mantissa = value.unscaledValue().longValue();
            StringBuilder builder = new StringBuilder().append(mantissa).append(".E");
            if (exponent == 0) {
                builder.append('+');
            }
            builder.append(exponent);
            encoded = new byte[builder.length() + 1];
            encoded[0] = 3;
            System.arraycopy(builder.toString().getBytes(), 0, encoded, 1, encoded.length - 1);
        }
        return this.newPrimitiveOctets(encoded);
    }

    @Override
    public EncodedOctets visit(BIT_STRING data) {
        if (data.hasNamedBits()) {
            data.contract();
        }
        return super.visit(data);
    }

    @Override
    public EncodedOctets visit(TimeType data) throws ASN1EncodingException {
        if (data instanceof UTCTime) {
            return super.visit(data);
        }
        DateFormat form = data.form();
        form.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuffer buf = new StringBuffer(form.format(data.date()).split("[.,]")[0]);
        String[] timestr = data.stringValue().split("[.,]");
        if (timestr.length == 2) {
            buf.append('.').append(timestr[1]);
            while (buf.lastIndexOf("0") == buf.length() - 1) {
                buf.setLength(buf.length() - 1);
            }
            if (buf.lastIndexOf(".") == buf.length() - 1) {
                buf.setLength(buf.length() - 1);
            }
        }
        buf.append('Z');
        return this.newPrimitiveOctets(buf.toString().getBytes());
    }

    @Override
    public ConstructedOctets visit(SET data) throws ASN1EncodingException {
        return ((DerConstructedOctets)super.visit(data)).sortByTag();
    }

    @Override
    public ConstructedOctets visit(SET_OF<? extends ASN1Type> data) throws ASN1EncodingException {
        return ((DerConstructedOctets)super.visit((SET_OF)data)).sortByContents();
    }

    @Override
    ConstructedOctets processConstructive(ConstructiveType data) throws ASN1EncodingException {
        ConstructedOctets octets = this.newConstructedOctets();
        ConstructiveType defaultData = null;
        ElementSpecification[] elementSpecificationArray = data.getElementTypeList();
        int n = elementSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                ASN1Type element;
                ElementSpecification e;
                block6: {
                    e = elementSpecificationArray[n2];
                    element = data.getComponent(e);
                    if (element == null || !element.hasValue()) break block5;
                    if (!e.hasDefault()) break block6;
                    if (defaultData == null) {
                        defaultData = (ConstructiveType)ASN1Type.instantiate(data.getClass());
                    }
                    if (element.equals(defaultData.getComponent(e))) break block5;
                }
                octets.addElement(this.encode(element, e.tag(), null));
            }
            ++n2;
        }
        return octets;
    }

    @Override
    EncodedOctets newPrimitiveOctets(byte ... contents) {
        return new DerPrimitiveOctets(contents);
    }

    @Override
    ConstructedOctets newConstructedOctets() {
        return new DerConstructedOctets();
    }

    class DerConstructedOctets
    extends DerOctets
    implements ConstructedOctets {
        private List<DerOctets> elements;
        private int length;

        DerConstructedOctets() {
            this.elements = new ArrayList<DerOctets>();
        }

        @Override
        public void addElement(EncodedOctets element) {
            this.elements.add((DerOctets)element);
            this.length += element.totalLength();
        }

        @Override
        public boolean isConstructed() {
            return true;
        }

        @Override
        public int contentsLength() {
            return this.length;
        }

        @Override
        byte[][] getContents() {
            byte[][] contents = new byte[this.elements.size()][];
            int i = 0;
            while (i < this.elements.size()) {
                contents[i] = this.elements.get(i).encodedOctets;
                ++i;
            }
            return contents;
        }

        @Override
        void clearContents() {
        }

        DerConstructedOctets sortByTag() {
            Collections.sort(this.elements, new DerOctets.TagComparator());
            return this;
        }

        DerConstructedOctets sortByContents() {
            Collections.sort(this.elements, new DerOctets.OctetsComparator());
            return this;
        }
    }

    abstract class DerOctets
    implements EncodedOctets {
        private ASN1TagClass tagClass;
        private int tagNumber;
        private byte[] encodedOctets;

        DerOctets() {
        }

        @Override
        public int totalLength() {
            return this.encodedOctets.length;
        }

        @Override
        public void fix(ASN1TagClass tagClass, int tagNumber) {
            this.tagClass = tagClass;
            this.tagNumber = tagNumber;
            byte[] identifier = DerEncoder.this.encodeTag(tagClass, tagNumber, this.isConstructed());
            byte[] length = DerEncoder.this.encodeLength(this.contentsLength());
            this.encodedOctets = new byte[identifier.length + length.length + this.contentsLength()];
            System.arraycopy(identifier, 0, this.encodedOctets, 0, identifier.length);
            System.arraycopy(length, 0, this.encodedOctets, identifier.length, length.length);
            int index = identifier.length + length.length;
            byte[][] byArray = this.getContents();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] e = byArray[n2];
                System.arraycopy(e, 0, this.encodedOctets, index, e.length);
                index += e.length;
                ++n2;
            }
            this.clearContents();
        }

        @Override
        public int write(OutputStream out) throws IOException {
            out.write(this.encodedOctets);
            return this.encodedOctets.length;
        }

        abstract byte[][] getContents();

        abstract void clearContents();

        class OctetsComparator
        implements Comparator<DerOctets> {
            OctetsComparator() {
            }

            @Override
            public int compare(DerOctets o1, DerOctets o2) {
                if (o1.encodedOctets.length != o2.encodedOctets.length) {
                    return o1.encodedOctets.length - o2.encodedOctets.length;
                }
                int i = 0;
                while (i < o1.encodedOctets.length) {
                    if (o1.encodedOctets[i] != o2.encodedOctets[i]) {
                        return (0xFF & o1.encodedOctets[i]) - (0xFF & o2.encodedOctets[i]);
                    }
                    ++i;
                }
                return 0;
            }
        }

        class TagComparator
        implements Comparator<DerOctets> {
            TagComparator() {
            }

            @Override
            public int compare(DerOctets o1, DerOctets o2) {
                if (o1.tagClass != o2.tagClass) {
                    return o1.tagClass.ordinal() - o2.tagClass.ordinal();
                }
                return o1.tagNumber - o2.tagNumber;
            }
        }
    }

    class DerPrimitiveOctets
    extends DerOctets {
        private byte[] contents;

        DerPrimitiveOctets(byte ... contents) {
            this.contents = contents;
        }

        @Override
        public boolean isConstructed() {
            return false;
        }

        @Override
        public int contentsLength() {
            return this.contents.length;
        }

        @Override
        byte[][] getContents() {
            return new byte[][]{this.contents};
        }

        @Override
        void clearContents() {
            this.contents = null;
        }
    }
}

