package blanco.plugin.pdf.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.pdf.BlancoPdfConstants;
import blanco.pdf.page.BlancoPdfTestPageDefProcessImpl;
import blanco.pdf.page.valueobject.BlancoPdfTestPageDefProcessInput;
import blanco.pdf.report.BlancoPdfReportProcessImpl;
import blanco.pdf.report.valueobject.BlancoPdfReportProcessInput;
import blanco.pdf.resourcebundle.BlancoPdfResourceBundle;
import blanco.plugin.pdf.BlancoPdfPlugin;
import blanco.plugin.pdf.BlancoPdfPluginConstants;
import blanco.plugin.pdf.editors.BlancoPdfPluginUtil;

public class BlancoPdfGenerateAction {
    private static final BlancoPdfResourceBundle fBundle = new BlancoPdfResourceBundle();

    /**
     * \[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param targetLang
     *            o͑ΏۃvO~OB
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     * @throws CoreException
     */
    public static final void processBlancoPdfSource(final IFile ifile,
            final Shell shell, IProgressMonitor workbenchMonitor,
            final String runtimePackage, final String confDir)
            throws InvocationTargetException, InterruptedException,
            CoreException {
        final IFolder fConfDir = ifile.getProject().getFolder(confDir);

        if (fConfDir.exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "\fBNg (" + confDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        // MessageDialog.openInformation(shell, "\[XR[h", "Ώ["
        // + fConfDir.getLocation().toFile().getAbsolutePath() + "]");

        final BlancoPdfReportProcessInput input = new BlancoPdfReportProcessInput();
        input.setConfdir(fConfDir.getLocation().toFile().getAbsolutePath());
        // input.setRuntimepackage(runtimePackage);

        {
            final IFolder tempRootFolder = ifile.getProject().getFolder("tmp");
            input.setTmpdir(tempRootFolder.getLocation().toFile()
                    .getAbsolutePath());
        }

        {
            final IFolder folderTargetDirectory = ifile.getProject().getFolder(
                    "blanco");
            final File blancoTargetDirectory = folderTargetDirectory
                    .getLocation().toFile();
            input.setTargetdir(blancoTargetDirectory.getAbsolutePath());
        }

        // Eclipse 3.3 ΍: begin
        // workbenchMonitor𗘗p邱Ƃ~܂B
        // org.eclipse.swt.SWTException: Invalid thread access Ă܂܂B
        // Eclipse 3.3 ΍: end

        // Eclipse vOC̏̃[ɏ]Ď\[XR[h̕GR[fBOB
        final String encoding = ifile.getProject().getDefaultCharset(true);
        input.setEncoding(encoding);

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoPdfConstants.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoPdfPluginUtil
                                        .deleteFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoPdfConstants.TARGET_SUBDIRECTORY);
                                BlancoPdfPluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoPdfConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempFolder = BlancoPdfPluginUtil
                                        .findFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoPdfConstants.TARGET_SUBDIRECTORY);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoPdfPluginUtil
                                        .findFolder(ifile, monitor, confDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                monitor.subTask("tH_쐬: " + "tH_");

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder("blanco");
                                if (ifile.getProject().getFolder(confDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            monitor);
                                }

                                monitor.subTask("tH_쐬: " + "blanco"
                                        + "/maintH_");
                                final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                                        .getFolder("main");
                                if (ifile.getProject().getFolder(confDir)
                                        .exists() == false) {
                                    folderTargetDirectoryWithMain.create(true,
                                            true, monitor);
                                }

                                monitor.subTask("\[XR[h쐬");
                                monitor.worked(1);

                                final BlancoPdfReportProcessImpl process = new BlancoPdfReportProcessImpl();
                                process.execute(input);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: " + "tH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (BlancoPdfPluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoPdfPlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoPdfPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoPdfPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoPdfPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }

    public static final void processBlancoGenerateTestPdf(final IFile ifile,
            final Shell shell, IProgressMonitor workbenchMonitor,
            final String confDir) throws InvocationTargetException,
            InterruptedException, CoreException {
        final IFolder fConfDir = ifile.getProject().getFolder(confDir);

        if (fConfDir.exists() == false) {
            MessageDialog.openWarning(shell, "PDF eXg", "\fBNg ("
                    + confDir + ") ݂܂B𒆒f܂B");
            return;
        }

        final BlancoPdfTestPageDefProcessInput input = new BlancoPdfTestPageDefProcessInput();
        input.setConfdir(fConfDir.getLocation().toFile().getAbsolutePath());

        {
            final IFolder tempRootFolder = ifile.getProject().getFolder("tmp");
            input.setTmpdir(tempRootFolder.getLocation().toFile()
                    .getAbsolutePath());
        }

        // Eclipse 3.3 ΍: begin
        // workbenchMonitor𗘗p邱Ƃ~܂B
        // org.eclipse.swt.SWTException: Invalid thread access Ă܂܂B
        // Eclipse 3.3 ΍: end

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoPdfConstants.PRODUCT_NAME
                                                + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoPdfPluginUtil
                                        .deleteFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoPdfConstants.TARGET_SUBDIRECTORY);
                                BlancoPdfPluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoPdfConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempFolder = BlancoPdfPluginUtil
                                        .findFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoPdfConstants.TARGET_SUBDIRECTORY);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoPdfPluginUtil
                                        .findFolder(ifile, monitor, confDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                monitor.subTask("tH_쐬: " + "tH_");

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder("blanco");
                                if (ifile.getProject().getFolder(confDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            monitor);
                                }

                                monitor.subTask("PDF 쐬");
                                monitor.worked(1);

                                final BlancoPdfTestPageDefProcessImpl process = new BlancoPdfTestPageDefProcessImpl();
                                process.execute(input);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: " + "tH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (BlancoPdfPluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoPdfPlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoPdfPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoPdfPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoPdfPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }
}