/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.exception;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * f[^x[X̏1sł͂ȂƂONX
 * 
 * ̃NXNXblancoDb\[XR[hŗp܂
 * 
 * @since 2005.05.12
 * @author IGA Tosiki
 */
public class NotSingleRowExceptionClass {
    /**
     * ONX̃NX
     */
    public static final String CLASS_NAME = "NotSingleRowException";

    /**
     * RXgN^ɎJavaDocB
     */
    private static final String CONSTRUCTOR_JAVADOC = "҂1sł͖ƂOIuWFNg ̃CX^X쐬܂B";

    /**
     * blancoCg IuWFNgt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * ̃NX܂܂\[XR[hB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    public NotSingleRowExceptionClass(final BlancoCgObjectFactory cgFactory,
            final String argPackage) {
        fCgFactory = cgFactory;
        fCgSourceFile = fCgFactory.createSourceFile(argPackage,
                "This code is generated by blanco Framework.");
    }

    public BlancoCgSourceFile expand() {
        final BlancoCgClass cgClass = fCgFactory.createClass(CLASS_NAME, null);
        fCgSourceFile.getClassList().add(cgClass);

        cgClass.getExtendClassList().add(
                fCgFactory.createType("java.sql.SQLException"));

        {
            final List<String> listDesc = cgClass.getLangDoc()
                    .getDescriptionList();

            listDesc.add("f[^x[X̏1sł͂ȂƂONX <br>");
            listDesc.add("̃NXblancoDb\[XR[hŗp܂ <br>");
            listDesc.add("̃NX́A\[XR[h̃t@CƂėp܂B");
            listDesc.add("");
            listDesc.add("@since 2005.05.12");
            listDesc.add("@author blanco Framework");
        }

        {
            final BlancoCgField cgField = fCgFactory.createField(
                    "SQLSTATE_NOTSINGLEROW", "java.lang.String", null);
            cgClass.getFieldList().add(cgField);
            cgField.setAccess("protected");
            cgField.setStatic(true);
            cgField.setFinal(true);
            cgField.setDefault("\"00101\"");
            cgField.getLangDoc().getDescriptionList().add(
                    "̃NX\SQLStateR[hB<br>");
            cgField
                    .getLangDoc()
                    .getDescriptionList()
                    .add(
                            "̃NX𗘗pۂɂ́ASQLStateɂ͗炸ɗONX̌^ɂďԂ𔻒f悤ɂĂB");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod.getLangDoc().getDescriptionList().add(
                    "@deprecated Ri[邱Ƃłʂ̃RXgN^𗘗p邱ƂE߂܂B");

            cgMethod
                    .getLineList()
                    .add(
                            "super(\"Not single row exception has occured.\", SQLSTATE_NOTSINGLEROW);");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("reason", "java.lang.String",
                            "O̐"));

            cgMethod.getLineList().add("super(reason, SQLSTATE_NOTSINGLEROW);");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("reason", "java.lang.String",
                            "O̐"));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("SQLState", "java.lang.String",
                            "Oʂ XOPENR[h܂ SQL 99̃R[h"));

            cgMethod.getLineList().add("super(reason, SQLState);");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("reason", "java.lang.String",
                            "O̐"));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("SQLState", "java.lang.String",
                            "Oʂ XOPENR[h܂ SQL 99̃R[h"));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("vendorCode", "int",
                            "f[^x[Xx_[߂ŗL̗OR[h"));

            cgMethod.getLineList().add("super(reason, SQLState, vendorCode);");
        }

        return fCgSourceFile;
    }
}