/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.calc.parser;

import jxl.Sheet;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import blanco.commons.calc.BlancoCalcUtil;

/**
 * CalcǂݎĂ݂邽߂̒ȒPSAX2p[TłB <br>
 * ɂ߂ĒPSAXp[XƂẴTvłB
 * 
 * @author IGA Tosiki
 */
public class BlancoSimpleCalcParser extends AbstractBlancoCalcParser {

    protected void startSheet(final String sheetName) throws SAXException {
        System.out.println("V[g[" + sheetName + "]...");
        AttributesImpl attrImpl = new AttributesImpl();
        attrImpl.addAttribute("", "name", "name", "CDATA", sheetName);
        getContentHandler().startElement("", "sheet", "sheet", attrImpl);
    }

    protected void endSheet(final Sheet sheet) throws SAXException {
        getContentHandler().endElement("", "sheet", "sheet");
    }

    protected void startRow(final int row) throws SAXException {
    }

    protected void endRow(final int row) throws SAXException {
    }

    protected void startColumn(final int column) throws SAXException {
    }

    protected void endColumn(final int column) throws SAXException {
    }

    /**
     * Zp[XꂽۂɌĂяo܂B
     * 
     * @param column
     *            ł1IWŌĂяo܂B
     * @param row
     *            ł1IWŌĂяo܂B
     * @param cellValue
     *            Z̒lB
     * @throws SAXException
     */
    protected void fireCell(final int column, final int row,
            final String cellValue) throws SAXException {
        if (cellValue.length() == 0) {
            return;
        }

        final StringBuffer strResult = new StringBuffer(256);
        strResult.append("  (");
        strResult.append(BlancoCalcUtil.columnToLabel(column));
        strResult.append(row);
        strResult.append(")  ");
        strResult.append(cellValue);
        System.out.println(strResult.toString());

        final AttributesImpl attrImpl = new AttributesImpl();
        attrImpl.addAttribute("", "position", "position", "CDATA",
                BlancoCalcUtil.columnToLabel(column) + row);
        getContentHandler().startElement("", "cell", "cell", attrImpl);
        final char[] charArray = cellValue.toCharArray();
        getContentHandler().characters(charArray, 0, charArray.length);
        getContentHandler().endElement("", "cell", "cell");
    }
}
