/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.normalizer.task;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import blanco.commons.util.BlancoFileUtil;
import blanco.html.normalizer.message.BlancoHtmlNormalizerMessage;
import blanco.html.normalizer.task.valueobject.BlancoHtmlNormalizerQuoteProcessInput;
import blanco.html.parser.BlancoHtmlContentSerializer;
import blanco.html.parser.BlancoHtmlParser;
import blanco.html.parser.BlancoHtmlParserFactory;
import blanco.html.parser.helper.BlancoHtmlNullContentHandler;
import blanco.html.parser.valueobject.BlancoHtmlAttribute;

public class BlancoHtmlNormalizerQuoteProcessImpl implements
        BlancoHtmlNormalizerQuoteProcess {
    protected BlancoHtmlNormalizerQuoteProcessInput fInput;

    protected BlancoHtmlNormalizerMessage fMsg = new BlancoHtmlNormalizerMessage();

    class QuoteNormalizerHandler extends BlancoHtmlNullContentHandler {
        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();

        protected BufferedWriter fWriter;

        public void setWriter(final BufferedWriter writer) {
            serializer.setWriter(writer);
        }

        public BufferedWriter getWriter() {
            return serializer.getWriter();
        }

        public void startDocument() throws IOException {
            serializer.startDocument();
        }

        public void endDocument() throws IOException {
            serializer.endDocument();
        }

        public void startElement(final String name,
                final List<BlancoHtmlAttribute> attrs) throws IOException {
            for (BlancoHtmlAttribute attr : attrs) {
                if (attr.getQuote() == 0) {
                    attr.setQuote(2);
                }
            }
            serializer.startElement(name, attrs);
        }

        public void endElement(final String name) throws IOException {
            serializer.endElement(name);
        }

        public void characters(final String argCharacters) throws IOException {
            serializer.characters(argCharacters);
        }

        public void comments(final String argComments, final int argType)
                throws IOException {
            serializer.comments(argComments, argType);
        }
    }

    public int execute(final BlancoHtmlNormalizerQuoteProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File sourceDir = new File(fInput.getSourcedir());
        final File targetDir = new File(fInput.getTargetdir());

        if (sourceDir.exists() == false) {
            throw new IllegalArgumentException(fMsg.getMbhtni01(fInput
                    .getSourcedir()));
        }
        if (sourceDir.isDirectory() == false) {
            throw new IllegalArgumentException(fMsg.getMbhtni02(fInput
                    .getSourcedir()));
        }
        if (targetDir.exists() == false) {
            if (targetDir.mkdirs() == false) {
                throw new IllegalArgumentException(fMsg.getMbhtni03(fInput
                        .getTargetdir()));
            }
        } else if (targetDir.isDirectory() == false) {
            throw new IllegalArgumentException(fMsg.getMbhtni04(fInput
                    .getTargetdir()));
        }
        if (sourceDir.getCanonicalPath().equals(targetDir.getCanonicalPath())) {
            throw new IllegalArgumentException(fMsg.getMbhtni05(fInput
                    .getSourcedir(), fInput.getTargetdir()));
        }

        process();

        return 0;
    }

    protected void process() throws IOException {
        final File sourceDir = new File(fInput.getSourcedir());
        final File targetDir = new File(fInput.getTargetdir());

        final File[] files = sourceDir.listFiles();
        if (files == null) {
            return;
        }
        for (final File file : files) {
            if (file.isFile() == false) {
                continue;
            }

            final BlancoHtmlParser parser = BlancoHtmlParserFactory
                    .getInstance();
            final QuoteNormalizerHandler handler = new QuoteNormalizerHandler();
            parser.setHandler(handler);
            final File targetFile = new File(targetDir.getAbsolutePath() + "/"
                    + file.getName());
            handler.setWriter(new BufferedWriter(new FileWriter(targetFile)));

            final byte[] fileData = BlancoFileUtil.file2Bytes(file);

            parser.parse(fileData);

            handler.getWriter().close();
        }
    }
}
