/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.doclisting.task;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.tools.ant.BuildException;

import blanco.commons.io.File2StreamWrapper;
import blanco.doclisting.BlancoDocListingCombinedXml2Report;
import blanco.doclisting.BlancoDocListingDefMeta2Xml;
import blanco.doclisting.resourcebundle.BlancoDocListingResourceBundle;

/**
 * BlancoDocListingReportTask Ant Task
 */
public class BlancoDocListingReportTask extends
        AbstractBlancoDocListingReportTask {
    private final BlancoDocListingResourceBundle bundle = new BlancoDocListingResourceBundle();

    protected void process() throws IllegalArgumentException {
        final File fileInputDir = new File(getInputdir());
        if (fileInputDir.exists() == false) {
            throw new BuildException(bundle.getTaskErr005(getInputdir()));
        }

        final File fileMetadir = new File(getMetadir());
        if (fileMetadir.exists() == false) {
            throw new BuildException(bundle.getTaskErr004(getMetadir()));
        }

        final File fileOutputDir = new File(getOutputdir());
        if (fileOutputDir.exists() == false) {
            fileOutputDir.mkdirs();
        }

        new File(fileOutputDir.getAbsolutePath() + "/tmp").mkdirs();

        try {
            // ^t@C͌ŒłB
            new File2StreamWrapper(new File(fileMetadir.getAbsolutePath()
                    + "/blancoDocListingDef.xls"), new File(fileOutputDir
                    .getAbsolutePath()
                    + "/tmp/blancoDocListingDef.xls.xml")) {
                protected void process(InputStream inStream,
                        OutputStream outStream) throws Exception {
                    new BlancoDocListingDefMeta2Xml().process(inStream,
                            outStream);
                    outStream.flush();
                }
            }.run();
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }

        try {
            new BlancoDocListingCombinedXml2Report().process(fileInputDir,
                    fileOutputDir, new File(fileOutputDir.getAbsolutePath()
                            + "/tmp/blancoDocListingDef.xls.xml"), new File(
                            getMetadir()));
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}
