/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg;

import java.io.File;

import junit.framework.TestCase;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgLine;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * VB.NETp̐B
 * 
 * @author IGA Tosiki
 */
public class BlancoCgTransformerVbTest extends TestCase {
    /**
     * VB.NET̎B
     * 
     * @throws Exception
     */
    public void testTransformerJs() throws Exception {
        final BlancoCgObjectFactory cgFactory = BlancoCgObjectFactory
                .getInstance();

        // \[Xt@C𐶐܂B
        final BlancoCgSourceFile cgSourceFile = cgFactory.createSourceFile(
                "Myprog", "eXgp̃NX");
        cgSourceFile.getImportList().add("System.Text.DummyText");
        // pbP[W̃C|[gB
        cgSourceFile.getImportList().add("Myprog.MyClass2");
        cgSourceFile.getLangDoc().getDescriptionList().add(
                "̃NX blanco FrameworkɂĎIɐ܂B");

        // NX𐶐܂B
        final BlancoCgClass cgClass = cgFactory.createClass("MySampleClass",
                "̃NX́AeXĝ߂̃NXłB");
        cgSourceFile.getClassList().add(cgClass);
        cgClass.getLangDoc().getTagList().add(
                cgFactory.createLangDocTag("author", null, "blanco Framework"));
        cgClass.getExtendClassList().add(
                cgFactory.createType("System.WebException"));
        cgClass.getImplementInterfaceList().add(
                cgFactory.createType("System.WebException"));
        cgClass.getImplementInterfaceList().add(
                cgFactory.createType("System.WebException2"));

        // tB[h𐶐܂B
        final BlancoCgField cgField = cgFactory.createField("myField",
                "System.DateTime", "ttB[h̎łB");
        cgClass.getFieldList().add(cgField);
        cgField.setDefault("New DateTime()");

        // \bh𐶐܂B
        final BlancoCgMethod cgMethod = cgFactory.createMethod("MyMethod",
                "\bh̎łB");
        cgClass.getMethodList().add(cgMethod);

        cgMethod.setAccess("private");

        // p[^ǉ܂B
        cgMethod.getParameterList().add(
                cgFactory.createParameter("argString", "System.String",
                        "B"));
        cgMethod.getParameterList()
                .add(
                        cgFactory.createParameter("argDate", "System.DateTime",
                                "tB"));
        // ߂lݒ肵܂B
        cgMethod.setReturn(cgFactory.createReturn("Boolean", "ȂtrueB"));

        cgMethod.getThrowList().add(
                cgFactory.createException("System.IO.IOException",
                        "o͗OꍇB"));

        // \bh̓eǉ܂B
        final BlancoCgLine cgLine = cgFactory.createLine("Return True");
        cgLine.setDescription("̎łB");
        cgMethod.getLineList().add(cgLine);

        final BlancoCgTransformer cgTransformerVb = BlancoCgTransformerFactory
                .getVbSourceTransformer();
        cgTransformerVb.transform(cgSourceFile, new File("./tmp/blanco"));
    }
}
