/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;

public final class IOUtilities {
    public static int BUFFER_SIZE = 32768;
    public static int MAX_TEXT_STREAM_SIZE = 0x100000;

    public static File ensureDirectoryCreated(File directory) throws IOException {
        if (!directory.isDirectory() && !directory.mkdirs()) {
            throw new IOException("Could not create directory " + directory);
        }
        return directory;
    }

    public static File ensureFileCreated(File file) throws IOException {
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null) {
            IOUtilities.ensureDirectoryCreated(parentDirectory);
        }
        if (!file.isFile() && !file.createNewFile()) {
            throw new IOException("Could not create file " + file);
        }
        return file;
    }

    public static void ensureClose(Closeable ... streams) throws IOException {
        IOException firstException = null;
        Closeable[] closeableArray = streams;
        int n = streams.length;
        int n2 = 0;
        while (n2 < n) {
            Closeable stream = closeableArray[n2];
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    firstException = e;
                }
            }
            ++n2;
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static void transfer(InputStream inStream, OutputStream outStream) throws IOException {
        if (inStream instanceof FileInputStream && outStream instanceof FileOutputStream) {
            IOUtilities.transfer((FileInputStream)inStream, (FileOutputStream)outStream);
        } else {
            IOUtilities.transfer(inStream, outStream, true);
        }
    }

    public static void transfer(FileInputStream fileInStream, FileOutputStream fileOutStream) throws IOException {
        FileChannel fileInChannel = fileInStream.getChannel();
        FileChannel fileOutChannel = fileOutStream.getChannel();
        long fileInSize = fileInChannel.size();
        try {
            long transferred = fileInChannel.transferTo(0L, fileInSize, fileOutChannel);
            if (transferred != fileInSize) {
                throw new IOException("transfer() did not complete");
            }
        }
        catch (Throwable throwable) {
            IOUtilities.ensureClose(fileInChannel, fileOutChannel);
            throw throwable;
        }
        IOUtilities.ensureClose(fileInChannel, fileOutChannel);
    }

    public static void transfer(InputStream inStream, OutputStream outStream, boolean closeOutputStream) throws IOException {
        IOUtilities.transfer(inStream, outStream, true, closeOutputStream);
    }

    public static void transfer(InputStream inStream, OutputStream outStream, boolean closeInputStream, boolean closeOutputStream) throws IOException {
        byte[] buffer = new byte[BUFFER_SIZE];
        try {
            int count2;
            while ((count2 = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, count2);
            }
        }
        finally {
            if (closeInputStream) {
                inStream.close();
            }
            if (closeOutputStream) {
                outStream.close();
            } else {
                outStream.flush();
            }
        }
    }

    public static String readCharacterStream(Reader reader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        int size2 = 0;
        StringBuilder result2 = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            if ((size2 += line.length() + 1) > MAX_TEXT_STREAM_SIZE) {
                throw new IOException("String data exceeds current maximum safe size (" + MAX_TEXT_STREAM_SIZE + ")");
            }
            result2.append(line).append("\n");
        }
        bufferedReader.close();
        return result2.toString();
    }

    public static String readUnicodeStream(InputStream in) throws IOException {
        return IOUtilities.readCharacterStream(new InputStreamReader(in, "UTF-8"));
    }

    public static String readUnicodeFile(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        try {
            String string2 = IOUtilities.readUnicodeStream(inStream);
            return string2;
        }
        finally {
            ((InputStream)inStream).close();
        }
    }
}

