/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SerializationMethod;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.internal.DOMBuildingController;
import uk.ac.ed.ph.snuggletex.internal.SessionContext;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectUtilities;
import uk.ac.ed.ph.snuggletex.internal.util.XMLUtilities;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.utilities.CSSUtilities;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebPageBuilder {
    private final SessionContext sessionContext;
    private final WebPageOutputOptions options;

    public WebPageBuilder(SessionContext sessionContext, WebPageOutputOptions options) {
        this.sessionContext = sessionContext;
        this.options = options;
    }

    public final Document createWebPage(List<FlowToken> fixedTokens) throws SnuggleParseException {
        String lang;
        String[] cssStylesheetURLs;
        Document document2 = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
        String[] clientXSLTURLs = this.options.getClientSideXSLTStylesheetURLs();
        if (clientXSLTURLs != null) {
            String[] stringArray = clientXSLTURLs;
            int n = clientXSLTURLs.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                document2.appendChild(document2.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + url + "\""));
                ++n2;
            }
        }
        Element body = document2.createElementNS("http://www.w3.org/1999/xhtml", "body");
        String title = this.options.getTitle();
        if (title != null && this.options.isAddingTitleHeading()) {
            Element titleHeader = document2.createElementNS("http://www.w3.org/1999/xhtml", "h1");
            titleHeader.appendChild(document2.createTextNode(title));
            body.appendChild(titleHeader);
        }
        DOMBuildingController domBuildingController = new DOMBuildingController(this.sessionContext, this.options);
        domBuildingController.buildDOMSubtree(body, fixedTokens);
        Element head2 = document2.createElementNS("http://www.w3.org/1999/xhtml", "head");
        WebPageOutputOptions.WebPageType pageType = this.options.getWebPageType();
        if (pageType == WebPageOutputOptions.WebPageType.MATHPLAYER_HTML) {
            Element object = document2.createElementNS("http://www.w3.org/1999/xhtml", "object");
            object.setAttribute("id", "MathPlayer");
            object.setAttribute("classid", "clsid:32F66A20-7614-11D4-BD11-00104BD3F987");
            head2.appendChild(object);
            head2.appendChild(document2.createProcessingInstruction("import", "namespace=\"" + this.options.getMathMLPrefix() + "\" implementation=\"#MathPlayer\" ?"));
        }
        Element meta = document2.createElementNS("http://www.w3.org/1999/xhtml", "meta");
        meta.setAttribute("http-equiv", "Content-Type");
        meta.setAttribute("content", this.computeMetaContentType());
        head2.appendChild(meta);
        meta = document2.createElementNS("http://www.w3.org/1999/xhtml", "meta");
        meta.setAttribute("name", "Generator");
        meta.setAttribute("content", "SnuggleTeX");
        head2.appendChild(meta);
        if (title != null) {
            Element titleElement = document2.createElementNS("http://www.w3.org/1999/xhtml", "title");
            titleElement.appendChild(document2.createTextNode(this.options.getTitle()));
            head2.appendChild(titleElement);
        }
        if ((cssStylesheetURLs = this.options.getCSSStylesheetURLs()) != null) {
            String[] stringArray = cssStylesheetURLs;
            int n = cssStylesheetURLs.length;
            int n3 = 0;
            while (n3 < n) {
                String url = stringArray[n3];
                Element link = document2.createElementNS("http://www.w3.org/1999/xhtml", "link");
                link.setAttribute("rel", "stylesheet");
                link.setAttribute("href", url);
                head2.appendChild(link);
                ++n3;
            }
        }
        if (this.options.isIncludingStyleElement()) {
            Element style = document2.createElementNS("http://www.w3.org/1999/xhtml", "style");
            style.setAttribute("type", "text/css");
            Properties cssProperties = CSSUtilities.readInlineCSSProperties(this.options);
            style.appendChild(document2.createTextNode(CSSUtilities.writeStylesheet(cssProperties)));
            head2.appendChild(style);
        }
        Element html = document2.createElementNS("http://www.w3.org/1999/xhtml", "html");
        if (pageType == WebPageOutputOptions.WebPageType.UNIVERSAL_STYLESHEET) {
            html.setAttributeNS("http://www.w3.org/2002/Math/preference", "pref:renderer", "mathplayer-dl");
        }
        if ((lang = this.options.getLang()) != null) {
            if (pageType == WebPageOutputOptions.WebPageType.MATHPLAYER_HTML || pageType == WebPageOutputOptions.WebPageType.PROCESSED_HTML) {
                html.setAttribute("lang", lang);
                if (this.options.getSerializationMethod() != SerializationMethod.HTML) {
                    html.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
                }
            } else {
                html.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
            }
        }
        if (this.options.isPrefixingMathML()) {
            html.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + this.options.getMathMLPrefix(), "http://www.w3.org/1998/Math/MathML");
        }
        html.appendChild(head2);
        html.appendChild(body);
        document2.appendChild(html);
        Object[] stylesheets = this.options.getStylesheets();
        if (!ObjectUtilities.isNullOrEmpty(stylesheets)) {
            Object[] objectArray = stylesheets;
            int n = stylesheets.length;
            int n4 = 0;
            while (n4 < n) {
                Object stylesheet = objectArray[n4];
                DOMSource input2 = new DOMSource(document2);
                document2 = XMLUtilities.createNSAwareDocumentBuilder().newDocument();
                try {
                    ((Transformer)stylesheet).transform(input2, new DOMResult(document2));
                }
                catch (TransformerException e) {
                    throw new SnuggleRuntimeException("Could not apply stylesheet " + stylesheet);
                }
                ++n4;
            }
        }
        return document2;
    }

    public final void setWebPageContentType(Object contentTypeSettable) {
        try {
            Method setterMethod = contentTypeSettable.getClass().getMethod("setContentType", String.class);
            setterMethod.invoke(contentTypeSettable, this.computeContentTypeHeader());
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Could not find and call setContentType() on Object " + contentTypeSettable, e);
        }
    }

    public final void writeWebPage(List<FlowToken> fixedTokens, Object contentTypeSettable, OutputStream outputStream, SnuggleSession.EndOutputAction endOutputOptions) throws SnuggleParseException, IOException {
        if (contentTypeSettable != null) {
            this.setWebPageContentType(contentTypeSettable);
        }
        Document webPageDocument = this.createWebPage(fixedTokens);
        Transformer serializer = this.createSerializer();
        try {
            try {
                serializer.transform(new DOMSource(webPageDocument), new StreamResult(outputStream));
            }
            catch (TransformerException e) {
                throw new SnuggleRuntimeException("Could not serialize web page", e);
            }
        }
        finally {
            if (endOutputOptions == SnuggleSession.EndOutputAction.CLOSE) {
                outputStream.close();
            } else if (endOutputOptions == SnuggleSession.EndOutputAction.FLUSH) {
                outputStream.flush();
            }
        }
    }

    private final Transformer createSerializer() {
        StylesheetManager stylesheetManager = this.sessionContext.getStylesheetManager();
        boolean supportsXSLT20 = stylesheetManager.supportsXSLT20();
        Transformer serializer = this.options.getSerializationMethod() == SerializationMethod.HTML ? stylesheetManager.getSerializer("classpath:/uk/ac/ed/ph/snuggletex/xhtml-to-html.xsl", this.options) : stylesheetManager.getSerializer(null, this.options);
        serializer.setOutputProperty("media-type", this.options.getContentType());
        if (supportsXSLT20 && this.options.getSerializationMethod() != SerializationMethod.XML) {
            serializer.setOutputProperty("include-content-type", "no");
        }
        return serializer;
    }

    private String computeContentTypeHeader() {
        String result2 = this.options.getWebPageType() == WebPageOutputOptions.WebPageType.CROSS_BROWSER_XHTML ? this.options.getContentType() : String.valueOf(this.options.getContentType()) + "; charset=" + this.options.getEncoding();
        return result2;
    }

    private String computeMetaContentType() {
        return String.valueOf(this.options.getContentType()) + "; charset=" + this.options.getEncoding();
    }
}

