/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.definitions.CorePackageDefinitions;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public final class ListEnvironmentHandler
implements EnvironmentHandler,
CommandHandler {
    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token2) throws SnuggleParseException {
        String listElementName = null;
        BuiltinEnvironment environment = token2.getEnvironment();
        if (environment == CorePackageDefinitions.ENV_ITEMIZE) {
            listElementName = "ul";
        } else if (environment == CorePackageDefinitions.ENV_ENUMERATE) {
            listElementName = "ol";
        } else {
            throw new SnuggleLogicException("No logic to handle list environment " + environment.getTeXName());
        }
        Element listElement = builder.appendXHTMLElement(parentElement, listElementName);
        for (FlowToken contentToken : token2.getContent()) {
            if (contentToken.isCommand(CorePackageDefinitions.CMD_LIST_ITEM)) {
                builder.handleToken(listElement, contentToken);
                continue;
            }
            if (contentToken.getType() == TokenType.ERROR) {
                builder.handleToken(parentElement, contentToken);
                continue;
            }
            throw new SnuggleLogicException("List environments can only contain list items - this should have been handled earlier");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken itemToken) throws SnuggleParseException {
        if (itemToken.isCommand(CorePackageDefinitions.CMD_LIST_ITEM)) {
            if (!builder.isParentElement(parentElement, "http://www.w3.org/1999/xhtml", "ul", "ol")) throw new SnuggleLogicException("List item outside environment - this should not have occurred");
            Element listItem = builder.appendXHTMLElement(parentElement, "li");
            builder.handleTokens(listItem, itemToken.getArguments()[0], true);
            return;
        } else {
            if (!itemToken.isCommand(CorePackageDefinitions.CMD_ITEM)) return;
            builder.appendOrThrowError(parentElement, itemToken, CoreErrorCode.TDEL00, new Object[0]);
        }
    }
}

