<?php
/*
 * Ф ʼԾɽץ饰
 * 
 * Copyright (c) 2005 yakty
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

	plugin_conf_load('students');

	/*
	 * ץ饰ξ֤ޤ
	 */
	function students_info() {
		$info = new PluginInfo();
		$info->name = "ʼԾɽ";
		$info->author = "yakty";
		$info->license = "GNU GPL";
		$info->version = "0.9.4";
		$info->description = "ʼԤξ򥢥ɽޤ<br>ֺɽ뼫ʬΥ򥯥åȥѹǤޤ";
		return $info;
	}

    /*
     * þץ̾
     */
    function get_blackboard_students(){
    	return get_script_uri().'?plugin=students';
    }

    /**
     * å󥿡ХκǾͤ
     */
    function get_students_interval_min() {
    	global $conf;
    	$min = $conf['students_request_interval_min'];
    	if($min > 0){
    		return $min * 1000;
    	} else {
    		return 6000;
    	}
    }

    /**
     * å󥿡Хκͤ
     */
    function get_students_interval_max() {
    	global $conf;
    	$max = $conf['students_request_interval_max'];
    	if($max > 0){
    		return $max * 1000;
    	} else {
    		return 60000;
    	}
    }

    /*
     * þɽ᡼̾
     */
    function get_students_image(){
    	global $conf;
    	return $conf['students_image'];
    }

	////////////////////////////
	// 
	////////////////////////////
	function students_action(){
		global $conf, $last_modified, $cookie_expires, $my_icon, $student_name, $icon_mode;

		// ץURI
		$students_uri = get_blackboard_students();

		// ǽ
		$last_modified;

		// åͭ
		$cookie_expires = time()+60*60*24*180;

		// ⥸塼Ǥɤ
		$apache_module = false;
		if(function_exists('getallheaders')){
			$apache_module = true;
		}

		// My
		$my_icon = '';
		if(isset($_COOKIE['my_icon'])){
			$icon = $_COOKIE['my_icon'];
			if(!preg_match('/^\s*javascript:/i', $icon)){
				$my_icon = $icon;
			}
		}
		// 桼̾
		$student_name = '';
		if(isset($_COOKIE['student_name'])){
			$student_name = $_COOKIE['student_name'];
		}
		// ⡼
		$icon_mode = '';
		if(isset($_COOKIE['icon_mode'])){
			$icon_mode = $_COOKIE['icon_mode'];
		}

		////////////////////////////
		// ᥤ
		////////////////////////////
		if($_SERVER['REQUEST_METHOD'] == 'GET'){
			if(isset($_GET['tag'])){
				// ǡ
				$icon_data = update_students(false);

				// Expiresإå
				header("Expires: " . gmdate("D, d M Y H:i:s", time()) . " GMT");

				// Apache⥸塼ξˤIf-Modified-Sinceإåʬǽ
				if($apache_module){
					$request_headers = getallheaders();
					// Etagإå
					header('Etag: "' . md5($_SERVER['REQUEST_URI'].$last_modified) . '"');
					if(isset($request_headers['If-Modified-Since'])){
						$since = parse_http_date($request_headers['If-Modified-Since']);
						if($since >= $last_modified){
							header("HTTP/1.1 304 Not Modified");
							exit();
						}
					}
				}

				// Last-Modifiedإå
				header("Last-Modified: " . gmdate("D, d M Y H:i:s", $last_modified) . " GMT");

				header("Content-type: application/xml");

				// 
				print_students($icon_data);
			} else {
				// եɽ
				print_loginform();
			}
		} else if($_SERVER['REQUEST_METHOD'] == 'POST'){
			if(isset($_POST['login'])){
				// åå

				// URL
				$icon = $_POST['icon'];
				if(!preg_match('/^\s*javascript:/i', $icon)){
					$my_icon = $icon;
				}
				// ̾
				$student_name = $_POST['username'];
				setcookie('student_name', $student_name, $cookie_expires);
				// ⡼
				$icon_mode = (isset($_POST['mode'])) ? $_POST['mode'] : 'selicon';
				setcookie('icon_mode', $icon_mode, $cookie_expires);
				if($icon_mode == 'selicon'){
					$my_icon = (isset($_POST['selicon'])) ? $_POST['selicon'] : '';
				}

				// 
				update_students(true);
				setcookie('my_icon', $my_icon, $cookie_expires);
			}
			print_loginform();
		}
	}

	////////////////////////////
	// ؿ
	////////////////////////////

	/**
	 * ǡ
	 */
	function update_students($update)
	{
		global $conf, $students_uri, $students_data, $last_modified, $my_icon, $student_name;

		//$images = array();
		$logs = array();
		$icon_data = array();

		// ե륪ץ
		$fp = fopen($conf['students_data'], "a+");
		// ¾å
		if(flock($fp, LOCK_EX)){
			$now = time();
			$last_modified = $now;
			$modified = false;

			// եݥ󥿰ư
			fseek($fp, 0);

			// ǡɤ߹
			//$logs = array();
			$index = 0;
			while(!feof($fp)){
				$line = fgets($fp, 1024);
				$line = chop($line, "\r\n");
				$a = preg_split('/\t/', $line);
				$cnt = count($a);
				if($cnt >= 2){
					// ΥΤݻ
					if($now - $a[1] <= $conf['students_expires'] * 60){
					//if($now - $a[1] <= 5 * 60){
						$logs[$a[0]] = array(
								'timestamp' => $a[1],
								'icon' => $a[2],
								'title' => $a[3],
								'page' => $a[4],
							);
					} else {
						// ïǤ
						$modified = true;
					}
				} else if(preg_match("/^(\d+)$/", $line, $matches)){
					// ǽ
					$last_modified = $matches[1];
				}
			}
			// IPɥ쥹˥ǡݻ
			$ip_addr = getenv('REMOTE_ADDR');
			$ua = md5(getenv('HTTP_USER_AGENT'));
			$user_key = $ip_addr.'.'.$ua;
			if(!array_key_exists($user_key, $logs)){
				// ³
				$update = true;
			}

			if($update){
				// 󹹿
				$logs[$user_key] = get_icondata();
				$my_icon = $logs[$user_key]['icon'];
				$modified = true;
			}
			$logs[$user_key]['timestamp'] = $now;

			// եݥ󥿰ư
			fseek($fp, 0);
			// եڤͤ
			ftruncate($fp, 0);

			// ǡ񤭽Ф
			foreach ($logs as $k => $v){
				array_walk($v, create_function('&$a,$b', '$a = preg_replace("/[\r\n\t]/", "", $a);'));
				fputs($fp, "{$k}\t{$v['timestamp']}\t{$v['icon']}\t{$v['title']}\t{$v['page']}\n");

				if(strcmp($k, $user_key) == 0){
					$page = get_blackboard_students();
					// ʬΥΥ
					$v['page'] = '#';
					$v['option'] = " onClick=\"javascript:window.open('".$page."', 'students', 'width=440,height=240')\"";
					$v['title'] = 'MyIcon';
					array_unshift($icon_data, $v);
				} else {
					array_push($icon_data, $v);
				}
			}
			if($modified){
				// ǽ֤򹹿
				$last_modified = $now;
			}
			// ǽ֤¸
			fputs($fp, $last_modified . "\n");

			fflush($fp);


			// å
			flock($fp, LOCK_UN);
		}
		fclose($fp);

		return $icon_data;
	}

	/**
	 * ProfListΥǡ
	 */
	function get_proflist_data($name)
	{
		$icondata = array();
		// ProfListΥ
		$encoding = mb_detect_encoding($name, 'auto');
		if($encoding !== false){
			$name = mb_convert_encoding($name, 'EUC-JP', $encoding);
		}
		$name_code = urlencode($name);
		$data = @file("http://vwta.kir.jp/CommentTools/ProfList/get_data.php?name={$name_code}");
		$icondata['icon'] = $data[0];
		$icondata['page'] = $data[1];
		return $icondata;
	}

	/**
	 * ǡ
	 */
	function get_icondata()
	{
		global $conf, $my_icon, $icon_mode, $student_name;

		$icondata = array('icon' => '', 'page' => '', 'title' => '');
		if($student_name != '' and $conf['use_proflist'] == '1'){
			// ProfListΥ
			$icondata = get_proflist_data($student_name);
		}
		if($icon_mode != 'proflist'
				and	!preg_match('/^\s*javascript:/i', $my_icon)){
			// ꤵ줿URL
			$icondata['icon'] = $my_icon;
		}
		if($icondata['icon'] == ''){
			// ǥեȻ
			$icondata['icon'] = '';
		}
		// ̾
		$icondata['title'] = $student_name;
		return $icondata;
	}

	/**
	 * 󥿥
	 */
	function create_icontag($data)
	{
		$title = ($data['title'] == '') ? 'ؼ' : $data['title'];
		$title = mb_convert_encoding($title, 'UTF-8', 'EUC-JP');
		$href = ($data['page'] == '') ? '' : ' href="'.htmlspecialchars($data['page']).'"';
		$icon = ($data['icon'] == '') ? get_students_image() : htmlspecialchars($data['icon']);
		$option = (isset($data['option'])) ? $data['option'] : '';
		return '<a title="'.$title.'"'.$href.$option.'><img src="'.$icon.'" alt="[can&#039;t display icon]"/></a>';
	}

	/**
	 * ɽ
	 */
	function print_students($data)
	{
		print '<?xml version="1.0" encoding="UTF-8"?>'."\n";
?>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
<body>
<div id="students">
<?php
		$array = array_map('create_icontag', $data);
		print join("\n", $array)."\n";
?>
</div>
</body>
</html>
<?php
	}

	/**
	 * եɽ
	 */
	function print_loginform()
	{
		global $conf, $my_icon, $student_name, $icon_mode;
		if($icon_mode == 'iconurl'){
			$icon_url = $my_icon;
		} else {
			$icon_url = '';
		}
			
		echo '<?xml version="1.0" encoding="EUC-JP"?>'
	?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=EUC-JP" />
			<meta http-equiv="Content-Script-Type" content="text/javascript" />
			<meta http-equiv="Content-Style-Type" content="text/css" />
			<title>դ</title>
			<style type="text/css">
				<?php require('blackboard.css.inc') ?>
				.login {
					margin: 20px;
				}
				.icons {
					margin-left: 10px;
				}
			</style>
		</head>
		<body>
		<div class="base">
			<div class="login">
				<h1>դ</h1>
				<form action="<?php echo get_blackboard_students() ?>" method="post">
				<input type="hidden" name="login" value=""/>
				桼̾<input type="text" name="username" value="<?php echo htmlspecialchars($student_name) ?>" /><br />
				
				<?php echo create_icontag(array('icon' => $my_icon, 'title' => 'MyIcon', 'page' => '', 'option' => '')) ?>
				<br />
<?php
if($conf['use_proflist'] == '1'){
// ProfListѤ
?>
				<input type="radio" name="mode" value="proflist" <?php echo ($icon_mode=='proflist')?'checked="checked"':'' ?>/><a href="http://vwta.kir.jp/CommentTools/ProfList/">ProfList</a>Υ
				<br />
<?php
}
?>
				<input type="radio" name="mode" value="iconurl" <?php echo ($icon_mode=='iconurl')?'checked="checked"':'' ?>/>ǤդΥ
				<input name="icon" type="text" size="80" value="<?php echo htmlspecialchars($icon_url) ?>"/>
				<br />
				<input type="radio" name="mode" value="selicon" <?php echo ($icon_mode=='selicon')?'checked="checked"':'' ?>/>Υ󤫤
				<br />
				<div class="icons">
				<?php
				$icons = get_default_icons();
				foreach($icons as $icon){
					$iconurl = htmlspecialchars($icon);
					print '<input type="radio" name="selicon" value="'.$iconurl.'" '.((strcmp($my_icon,$icon)==0)?'checked="checked"':'').'/>';
					print '<img src="'.$iconurl.'" />'."\n";
				}
				?>
				</div>
				<br />
				<input type="submit" value="Ͽ" />
				</form>
				<!--<a href="blackboard.php" title="Фˤɤ">Фˤɤ</a>-->
			</div>
		</div>
		</body>
	</html>
	<?php
	}

	/**
	 * ǥեȤΥ
	 */
	function get_default_icons(){
		global $conf;
		$dir = $conf['students_icon_dir'];
		$dir = trim($dir, "/");
		$d = opendir($dir);
		$files = array();
		while(($ent = readdir($d)) !== false){
			if(preg_match('/\.(jpe?g)|(png)|(gif)$/u', $ent)){
				array_push($files, $dir.'/'.$ent);
			}
		}
		closedir($d);
		/*
		$files = glob($dir.'/*');
		*/
		return $files;
	}

	/**
	 * HTTPإåդϤ
	 */
	function parse_http_date($str_date)
	{
		if(strpos($str_date, ',') === false){
			$str_date .= ' GMT';
		}
		return strtotime($str_date);
	}

?>
