<?php
/*
 *
 * $RCSfile: report.inc,v $
 * $Date: 2005/07/29 05:19:56 $
 * $Author: die $
 *
 * ФݡȽϥץ
 *
 * Copyright (c) 2005 die kato
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

	plugin_depends_on('note');
	plugin_conf_load('report');

	/*
	 * ݡȥץ饰ξ֤ޤ
	 */
	function report_info() {
        $info = new PluginInfo();
        $info->name = "ݡ";
        $info->author = "die kato, rica";
        $info->license = "GNU GPL";
        $info->version = "0.2";
        $info->homepage = "http://blackboard.sourceforge.jp/doc/index.php?plugins%2Freport";
        $info->download = "http://blackboard.sourceforge.jp/doc/index.php?plugins%2Freport";
        $info->description = "RSSΥݡȤޤ";
		$info->dependency = array('note');
        return $info;
	}

	/*
	 * 
	 */
	function report_get_conf() {
		?>
			<table>
				<?php
					$order = array("Τ"=>0, "ŤΤ"=>1);
					conf_item_number("ǥեȤη", "report_default_num", 5, "");
					conf_item_number("ǥեȤγϰ", "report_default_start", 5, "");
					conf_select_text("ǥեȤθ", "report_default_order", $order);
					conf_item_text("ǥեȤθʸ", "report_default_query", 10);
				?>
			</table>
		<?php
	}

	/*
	 * 
	 */
	function report_post_conf() {
		global $conf;
		$e = array();
		$order = array(0, 1);
		$e['report_default_num'] = conf_validate_int('report_default_num', 100, 0);
		$e['report_default_start'] = conf_validate_int('report_default_start', 1000, 0);
		$e['report_default_order'] = conf_validate_select('report_default_order', $order);
		$e['report_default_query'] = conf_validate_text('report_default_query', 1000, 0);

		conf_save('report', $e);
		return $e;
	}

	/*
	 * ݡȤΥ
	 */
	function report_action() {
		global $conf;

		// 륷
		if (isset($_GET['style'])) {
			if ($_GET['style'] == 'default') {
				require('report.xsl.default.inc');
			}
			return;
		}

		$num = $conf['report_default_num'];
		$start = $conf['report_default_start'];
		$order = $conf['report_default_order'];
		$query = $conf['report_default_query'];
	
		// 
		if (isset($_GET['num'])) {
			$n = (int) $_GET['num'];
			if ($n > 0) {
				$num = $n;
			}
		}
	
		// ϰ
		if (isset($_GET['start'])) {
			$n = (int) $_GET['start'];
			if ($n >= 0) {
				$start = $n;
			}
		}
	
		// ɽ
		define('ORDER_DESC', 0);
		define('ORDER_ASC', 1);
		if (isset($_GET['order'])) {
			if ($_GET['order'] == ORDER_ASC) {
				$order = ORDER_ASC;
			} else {
				$order = ORDER_DESC;
			}
		}
	
		// ʸ
		if (isset($_GET['query'])) {
			$query = htmlspecialchars($_GET['query']);
		}

		$pages = report_get_pages($query, $order);
	
		// ̤ʬ礭ʤ
		if ($start > count($pages)) {
			$num = 0;
		} else if ($start + $num > count($pages)) {
			$num = count($pages) - $start;
		}

		global $conf;
		$script_uri = get_script_uri();
		// ȥ
		$title = $conf['title_str'] . ': ݡ';

		//description
		$description = ($query == "" ? "" : "'" . $query . "'ޤ");
		$description .= count($pages) . 'ڡ桢 ';
		$description .= ($order == ORDER_ASC ? 'Ť' : '') . 'ڡ';
		$description .= ($start) . 'ڡܤ' . $num . 'ڡɽƤޤ';

		header("Content-type:application/xml");
		echo '<?xml version="1.0" encoding="EUC-JP" ?>';
		echo '<?xml-stylesheet href="' . get_script_uri() . '?plugin=report&style=default" type="text/xsl" media="screen"?>';
		?>
		<rdf:RDF xmlns="http://purl.org/rss/1.0/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:content="http://purl.org/rss/1.0/modules/content/" xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja">
			<channel rdf:about="<?php echo $script_uri . '?' . htmlspecialchars($_SERVER['QUERY_STRING']) ?>">
				
				<title><?php echo $title ?></title>
				<link><?php echo $conf['home_url'] ?></link>
				<description><?php echo $description ?></description>
				<items>
					<rdf:Seq>
						<?php for ($i = 0; $i < $num; $i++) { ?>
							<rdf:li rdf:resource="<?php echo $pages[$start+$i]['uri']  ?>"/>
						<?php } ?>
					</rdf:Seq>
				</items>
			</channel>
			<?php for ($i = 0; $i < $num; $i++) { ?>
				<item rdf:about="<?php echo $pages[$start+$i]['uri'] ?>">
					<title><?php echo $pages[$start+$i]['title'] ?></title>
					<link><?php echo $pages[$start+$i]['uri'] ?></link> 
					<dc:date><?php echo  date('r', $pages[$start+$i]['date'])?></dc:date>
					<content:encoded><![CDATA[
						<img src="<?php echo get_page_image_uri($pages[$start+$i]['date']) ?>" />
		 			]]></content:encoded>
				</item>
			<?php } ?>
		</rdf:RDF>
		<?php
	}

	/*
	 * ˹פڡ
	 * $query: ʸ
	 * $order: 
	 */
	function report_get_pages($query, $order) {
		$pages = array();
		$fname = get_note_index_name();
		$query_lower = strtolower($query);
		if (file_exists($fname)) {
			$f = fopen($fname, 'r');
			while (!feof($f)) {
				$s = fgets($f, 4096);
				if (ereg('([^ ]*) (.*)', $s, $regs)) {
					// ʸ󤬻ꤵƤ鸡
					if ($query != "") {
						if (!is_numeric(mb_strpos(strtolower($regs[2]), $query_lower, 0, 'EUC-JP'))) {
							continue;
						}
					}
					$a = array('date'=>$regs[1], 'title'=>trim($regs[2]), 'uri'=>get_page_uri($regs[1]));
					if ($order == ORDER_ASC) {
						array_push($pages, $a);
					} else {
						array_unshift($pages, $a);
					}
				}
			}
			fclose($f);
		}
		return $pages;
	}
?>
