<?php
/*
 * $RCSfile: conf.inc,v $
 * $Date: 2005/07/29 05:14:05 $
 * $Author: die $
 *
 * ץ饰
 *
 * Copyright (c) 2005 die kato
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

	// 顼åǼޤ
	$conf_error_messages = null;

	// ƥȥܥåβ̾κĹǤ
	define('CONF_TEXTBOX_MAX_LENGTH', 30);

	/*
	 * ץ饰ξ֤ޤ
	 */
	function conf_info() {
		$info = new PluginInfo();
		$info->name = "";
		$info->author = "die kato, AsO";
		$info->license = "GNU GPL";
        $info->version = "0.4";
        $info->homepage = "http://blackboard.sourceforge.jp/doc/index.php?plugins%2Fconf";
        $info->download = "http://blackboard.sourceforge.jp/doc/index.php?plugins%2Fconf";
		$info->description = "ФԤץ饰Ǥ";

		return $info;
	}

	/*
	 * ˼¹Ԥޤ
	 */
	function conf_action() {
		global $conf;
		session_start();
		// ̤
		if (!isset($_SESSION['authorized'])) {
			if (!conf_authorize()) {
				require('conf.auth.inc');	
				return;
			}
		}
		if ($_SERVER['REQUEST_METHOD'] == 'POST') {
			conf_post();
		} else {
			conf_get();
		}
	}

	/*
	 * ѥǧڤԤޤ
	 */
	function conf_authorize() {
		global $conf;
		if (isset($_POST['password'])) {
			$a = file($conf['conf_dir'] . 'adminpass');
			if ($a) {
				if (trim($a[0]) == md5($_POST['password'])) {
					session_set_cookie_params(0, dirname($_SERVER['PHP_SELF']));
					$_SESSION['authorized'] = true;
					return true;
				}
			}
		}
		return false;
	}

	/*
	 * POSTν
	 */
	function conf_post() {
		global $conf_error_messages;

		if (isset($_POST['conf_target']) && $_POST['conf_target'] != "") {
			$name = $_POST['conf_target'];
			// ϡñ˥եä
			if (isset($_POST['conf_initialize']) && $_POST['conf_initialize'] == "true") {
				custom_conf_remove($name);
				// Фɤľ򤷤ʤȡФä
				// ̤ȿǤʤ
				global_conf_load();
			// ŬѤξϡƥץ饰postƤӽФ
			} else {
				plugin_load("plugins/" . $name . "/" . $name . ".inc");
				if (function_exists($name . "_post_conf")) {
					$conf_error_messages = call_user_func($name . "_post_conf");
				}
			}
		}
		conf_get();
	}

	/*
	 * GETνޤΤȤPOSTʳ顣
	 */
	function conf_get() {
		global $conf;
		// ץ饰ǥ쥯ȥɤ߹
		$dir = opendir('plugins');
		$plugins = array();
		while (($name = readdir($dir)) !== false) {
			if ($name != "." && $name != "..") {
				plugin_load("plugins/" . $name . "/" . $name . ".inc");
				$f = $name . "_get_conf";
				if (!function_exists($name . "_get_conf")) {
					continue;
				}
				$plugins[$name] = $name;
				$f = $name . "_info";
				if (function_exists($f)) {
					$a = call_user_func($f);
					if ($a->name != "") {
						$plugins[$name] = $a->name;
					}
				}
	
			}
		}
		ksort($plugins);

		require('conf.page.inc');
	}


	/*
	 * б륨顼ޤ
	 * 顼ȯƤʤжʸ֤ޤ
	 * $key: 
	 */
	function conf_get_error($key) {
		global $conf_error_messages;
		
		if ($conf_error_messages != null && isset($conf_error_messages[$key]) && $conf_error_messages[$key] != "") {
			return "<span class='warning'>$conf_error_messages[$key]</span>";
		} else {
			return "";
		}
	}

	/*
	 * ƥϥեɤޤ
	 * $label: ٥
	 * $key: 
	 * $size: Ϻʸ
	 * $unit: ñ̡ǥեȤ϶ʸ
	 * $aligin: 󡢥ǥեȤϺ
	 */
	function conf_item_text($label, $key, $size, $unit = "", $align = "left") {
		global $conf;
		$error = conf_get_error($key);
		$length = $size < CONF_TEXTBOX_MAX_LENGTH ? $size : CONF_TEXTBOX_MAX_LENGTH;
		$style = "width:{$length}em;text-align:$align";
		$value = htmlspecialchars($conf[$key]);
		?>
			<tr>
				<th><?php echo $label?></th>
				<td>
					<?php echo "<input type='text' name='$key' value='$value' style='$style' maxlength='$size' />$unit<br />$error" ?>
				</td>
			</tr>
		<?php
	}

	/*
	 * ϥեɤޤ
	 * $label: ٥
	 * $key: 
	 * $size: Ϻʸ
	 * $unit: ñ
	 */
	function conf_item_number($label, $key, $size, $unit) {
		return conf_item_text($label, $key, $size, $unit, "right");
	}

	/*
	 * ƥեɤޤ
	 * $label: ٥
	 * $key: 
	 * $items: ƥ󡢥ƥname=valueϢ
	 */
	function conf_select_text($label, $key, $items) {
		global $conf;
		$error = conf_get_error($key);
		?>
			<tr>
				<th><?php echo $label?></th>
				<td>
					<select name="<?php echo $key ?>">
						<?php
							$selected = $conf[$key];
							while (list($name, $value) = each($items)) {
								$n = htmlspecialchars($name);
								$v = htmlspecialchars($value);
								echo "<option value='$v'";
								if ($selected == $value) {
									echo " selected='selected'";
								}
								echo ">$n</option>";
							}
						?>
					</select><br />
					<?php echo $error ?>
				</td>
			</tr>
		<?php
	}

	/*
	 * URLϥեɤޤ
	 * ƥȥեɤȡꤵƤͤβɽޤ
	 * $label: ٥
	 * $key: 
	 * $size: Ϻʸ
	 */
	function conf_item_image($label, $key, $size) {
		global $conf;
		$error = conf_get_error($key);
		$length = $size < CONF_TEXTBOX_MAX_LENGTH ? $SIZE : CONF_TEXTBOX_MAX_LENGTH;
		$style = "width:{$length}em;";
		$value = htmlspecialchars($conf[$key]);
		?>
			<tr>
				<th><?php echo $label?></th>
				<td>
					<?php
						echo "<input type='text' name='$key' value='$value' style='$style' maxlength='$size' /><br />$error";
						echo "<img src='$value' alt='$key' />";
					?>
				</td>
			</tr>
		<?php
	}

	/*
	 * ѥϥեɤޤ
	 * $label: ٥
	 * $key: 
	 */
	function conf_item_password($label, $key) {
		global $conf;
		$error = conf_get_error($key);
		$value = htmlspecialchars($conf[$key]);
		?>
			<tr>
				<th><?php echo $label?></th>
				<td>
					<input name="<?php echo $key ?>" type="password" /><br />
					<?php echo $error ?>
				</td>
			</tr>
		<?php
	}

	/*
	 * POSTϤ줿ͤ
	 * - ꤵƤ뤫ɤ
	 * - ʸۤƤʤ
	 * - Ǿʸ꾯ʤʤ
	 * Ĵ٤ޤ
	 * $key: 
	 * $max: ʸ
	 * $min: Ǿʸ
	 * ֵ: 顼å
	 */
	function conf_validate_text($key, $max, $min) {
		global $conf;
		$error = "";
		if (!isset($_POST[$key])) {
			$error = "ͤꤵƤޤ";
		} else {
			$len = mb_strlen($_POST[$key]);
			if ($len < $min) {
				$error = "ʸʤޤ(Ǿʸ: $min)";
			} else if ($len > $max) {
				$error = "ʸ¿ޤ(ʸ$max)";
			}
			$conf[$key] = $_POST[$key];
		}
		return $error;
	}

	/*
	 * POSTϤ줿ͤ
	 * - ꤵƤ뤫ɤ
	 * - ۤƤʤ
	 * - Ǿ꾯ʤʤ
	 * Ĵ٤ޤ
	 * $key: 
	 * $max: 
	 * $min: Ǿ
	 * ֵ: 顼å
	 */
	function conf_validate_int($key, $max, $min) {
		global $conf;
		$error = conf_validate_text($key, 1024, 0);
		if ($error == "") {
			$i = 0 + $_POST[$key];
			if ($i < $min) {
				$error = "Ͽͤޤ(Ǿ: $min)";
			} else if ($i > $max) {
				$error = "Ͽͤ礭ޤ(: $max)";
			}
			$conf[$key] = $i;
		}
		return $error;
	}

	/*
	 * POSTϤ줿ͤ
	 * - ꤵƤ뤫ɤ
	 * - ꤵƤͤäƤ뤫
	 * Ĵ٤ޤ
	 * $key: 
	 * $values: ꤵƤͤ
	 * ֵ: 顼å
	 */
	function conf_validate_select($key, $values) {
		global $conf;
		$error = "";
		if (!isset($_POST[$key])) {
			$error = "ͤꤵƤޤ";
		} else {
			if (in_array($_POST[$key], $values)) {
				$conf[$key] = $_POST[$key];
			} else {
				$error = "̵ͤǤ";
			}
		}
		return $error;
	}

	/*
	 * ե¸ޤ
	 * Ϥ줿顼åˡ
	 * ʸǤʤΤ¸ߤϡ񤭹ߤ
	 * Ԥޤ
	 * $name: ץ饰̾
	 * $errors: 顼å
	 */
	function conf_save($name, $errors) {
		global $conf;
		$custom = array();
		while (list($key, $error) = each($errors)) {
			if ($error != "") {
				return;
			}
			$custom[$key] = $conf[$key];
		}
		custom_conf_save($name, $custom);
	}

	/*
	 * ФΤ
	 * 褳˽񤯤٤ǤϤʤ
	 */
	function blackboard_get_conf() {
		global $conf;
		?>
			<table>
				<?php
					conf_item_text("ȥʸ", "title_str", 30);
					conf_item_image("ȥURL", "title_img", 256);
					conf_item_text("ۡڡURL", "home_url", 256);
					conf_item_text("ǡѥǥ쥯ȥ̾", "data_dir", 128);
					conf_item_number("Ф", "blackboard_width", 5, "px");
					conf_item_number("Фι⤵", "blackboard_height", 5, "px");
					conf_item_text("Фե̾", "blackboard_image", 128);
					conf_item_number("pingκǾ󥿡Х", "requestmanager_interval_min", 8, "ߥ");
					conf_item_number("pingκ祤󥿡Х", "requestmanager_interval_max", 8, "ߥ");
				?>
				<tr>
					<th>ץ饰ON/OFF</th>
					<td>
						<?php 
							// ץ饰ǥ쥯ȥɤ߹
							$dir = opendir('plugins');
							$plugins = array();
							while (($name = readdir($dir)) !== false) {
								if ($name != "." && $name != "..") {
									if (!file_exists("plugins/" . $name . "/" . $name . ".inc")) {
										continue;
									}
									plugin_load("plugins/" . $name . "/" . $name . ".inc");
									$plugins[$name] = $name;
									$f = $name . "_info";
									if (function_exists($f)) {
										$a = call_user_func($f);
										if ($a->name != "") {
											$plugins[$name] = $a->name;
										}
									}
								}
							}
						?>
						<table>
							<tr>
								<th>ͭʥץ饰</th>
								<th></th>
								<th>̵ʥץ饰</th>
							</tr>
							<tr>
								<td>
									<input type="hidden" id="plugins" name="plugins" value="<?php echo join(',', $conf['plugins']) ?>" />
									<select id="enabledPlugins" size="10" style="width: 200px;">
									<?php
										foreach ($conf['plugins'] as $key) {
											$text = $plugins[$key];
											if ($text != $key) {
												$text .= " ($key)";
											}
											echo "<option value='$key' title='$text'>$text</option>";
										}
									?>
									</select>
								</td>
								<td>
									<input type="button" value="" onclick="order(-1);" style="margin-bottom: 20px" title="ץ饰̤ͥ夲ޤ" /><br />
									<input type="button" value="" onclick="move(alist, elist);" title="ץ饰ͭˤޤ"  /><br />
									<input type="button" value="" onclick="move(elist, alist);" title="ץ饰̵ˤޤ"  /><br />
									<input type="button" value="" onclick="order(1)" style="margin-top: 20px;" title="ץ饰̤ͥ򲼤ޤ"  />
								</td>
								<td>
									<select id="availablePlugins" size="10" style="width: 200px;">
									<?php
										while (list($key, $name) = each($plugins)) {
											// Ǥͭʥץ饰ɽʤ
											if (in_array($key, $conf['plugins'])) {
												continue;
											}
											$text = $name;
											if ($name != $key) {
												$text .= " ($key)";
											}
											echo "<option value='$key' title='$text'>$text</option>";
										}
									?>
									</select>
									<script type="text/javascript">
									//<![CDATA[
										var elist = document.getElementById('enabledPlugins');
										var alist = document.getElementById('availablePlugins');
										var plugins = document.getElementById('plugins');

										function updatePlugins() {
											var a = new Array();
											for (var i = 0; i < elist.options.length; i++) {
												var s = elist.options[i];
												a.push(elist.options[i].value);
											}
											plugins.value = a.join(',');
										}
										function move(from, to) {
											var i = from.selectedIndex;
											if (i == -1) {
												return;
											}
											var item = from.options[i];
											from.removeChild(item);
											to.appendChild(item);
											updatePlugins();
										}
										function order(n) {
											var i = elist.selectedIndex;
											if (i == -1) {
												return;
											}
											if ((n > 0) && !(i < elist.length - n)) {
												return;
											} else if ((n < 0) && !(i + n >= 0)) {
												return;
											}
											var item = elist.options[i];
											elist.removeChild(item);
											elist.insertBefore(item, elist.options[i+n]);
											updatePlugins();
										}
									//]]>
									</script>
								</td>
							</tr>
						</table>
						<?php echo conf_get_error('plugins') ?>
					</td>
				</tr>
			</table>
		<?php
	}

	/*
	 * ФΤ
	 * 褳˽񤯤٤ǤϤʤ
	 */
	function blackboard_post_conf() {
		global $conf;
		$e = array();
		$e['title_str'] = conf_validate_text('title_str', 100, 1);
		$e['title_img'] = conf_validate_text('title_img', 256, 0);
		$e['home_url'] = conf_validate_text('home_url', 256, 0);
		$e['data_dir'] = conf_validate_text('data_dir', 128, 1);
		$e['blackboard_width'] = conf_validate_int('blackboard_width', 2048, 1);
		$e['blackboard_height'] = conf_validate_int('blackboard_height', 2048, 1);
		$e['blackboard_image'] = conf_validate_text('blackboard_image', 128, 1);
		$e['requestmanager_interval_min'] = conf_validate_int('requestmanager_interval_min', 3600000, 1000);
		$e['requestmanager_interval_max'] = conf_validate_int('requestmanager_interval_max', 86400000, 5000);

		$e['plugins'] = "";
		if (!isset($_POST['plugins'])) {
			$e['plugins'] = "ͤꤵƤޤ";
		} else {
			$plugins = split(',', $_POST['plugins']);

			for ($i = 0; $i < count($plugins); $i++) {
				$name = $plugins[$i];
				plugin_load("plugins/" . $name . "/" . $name . ".inc");
				$f = $name . "_info";
				if (function_exists($f)) {
					$a = call_user_func($f);
					if (count($a->dependency) > 0) {
						// ٤Ƥΰ¸ץ饰å
						for ($j = 0; $j < count($a->dependency); $j++) {
							// ¸ץ饰󤬤ޤǤꤵƤʤХ顼
							$found = false;
							for ($k = 0; $k < $i; $k++) {
								if ($plugins[$k] == $a->dependency[$j]) {
									$found = true;
									break;
								}
							}
							if (!$found) {
								$e['plugins'] .= $name . "¸ץ饰" . $a->dependency[$j] ;
								$e['plugins'] .= "פ" . $name . "˻ꤵƤޤ";
								
							}
						}
					}
				}
			}
		}
		$conf['plugins'] = $_POST['plugins'];
		conf_save('blackboard', $e);
		$conf['plugins'] = split(',', $conf['plugins']);
		return $e;
	}

	/*
	 * ѥɤ
	 */
	function conf_password_get_conf() {
		global $conf;
		if (!isset($conf['conf_admin_password'])) {
			$conf['conf_admin_password'] = "";
		}
		if (!isset($conf['conf_admin_password2'])) {
			$conf['conf_admin_password2'] = "";
		}
		?>
			<h2>ԥѥɤѹ</h2>
			<table>
				<?php
					conf_item_password("ѥ", "conf_admin_password");
					conf_item_password("ѥɺ(ǧ)", "conf_admin_password2");
				?>
			</table>	
		<?php
	}

	/*
	 * ѥɤ
	 */
	function conf_password_post_conf() {
		global $conf;
		$e = array();
		$e['conf_admin_password'] = conf_validate_text('conf_admin_password', 128, 4);
		$e['conf_admin_password2'] = conf_validate_text('conf_admin_password2', 128, 4);

		if ($e['conf_admin_password'] == "" && $e['conf_admin_password2'] == "") {
			if ($conf['conf_admin_password'] == $conf['conf_admin_password2']) {
				$fp = fopen($conf["conf_dir"] . "adminpass", "w");
				fwrite($fp, md5($conf['conf_admin_password']));
				fclose($fp);
			} else {
				$e['conf_admin_password2'] = "ѥɤפޤ";
			}
		}
		return $e;
	}
?>
