<?php
/*
 *
 * $RCSfile: blackboard.php,v $
 * $Date: 2005/07/28 15:04:18 $
 * $Author: die $
 * 
 * Ф󥵡¦ץ
 * 
 * Copyright (c) 2005 die kato
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

	global_conf_load();

	if (isset($_REQUEST['plugin'])) {
		plugin_initialize($_REQUEST['plugin']);
		plugin_activate($_REQUEST['plugin']);

	} else if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		if (!file_exists($conf['conf_dir'] . 'adminpass')) {
			require_once('postinstall.inc');
		} else {
			plugins_initialize();
			require_once('blackboard.html.inc');
		}

	// 
	} else if (isset($_POST['erase']) && $_POST['erase'] == 'erase') {
		image_initialize();
		get_self();

	// Ф
	} else if (isset($_POST['s'])) {
		$t = image_update($_POST['s']);
		header('content-type: text/plain');
		echo $t;

	// ԥѥɤ
	} else if (isset($_POST['admin_password'])) {
		require_once('postinstall.inc');

	// ¾
	} else {
		header('content-type: text/plain');
		echo "ok";
	}

	/*
	 * 򹹿롣
	 * $script: ץ
	 */
	function image_update($script) {
		$lock = image_lock();
		$im = image_create();
		interpret($im, $script);
		$fname = get_blackboard_image_name();
		image_save($im, $fname);
		image_unlock($lock);

		// ե빹ȤȻפäλǤϤޤե뤬Ƥʤ
		// return gmstrftime("%a, %d %b %Y %H:%M:%S GMT", filemtime($fname));
		// 礦ʤΤǸ߻
		return gmstrftime("%a, %d %b %Y %H:%M:%S GMT");
	}

	/*
	 * 롣
	 */
	function image_initialize() {
		global $conf;
		//$im = imagecreate($conf['blackboard_width'], $conf['blackboard_height']);
		//imagecolortransparent($im, imagecolorallocate($im, 255, 255, 255));
		$im = image_create(true);
		$lock = image_lock();
		image_save($im, get_blackboard_image_name());
		image_unlock($lock);
	}

	/*
	 * ᡼֥Ȥ롣
	 */
	function image_create($init=false) {
		global $conf;
		$fname = get_blackboard_image_name();
		//if (!file_exists($fname) || exif_imagetype($fname) != IMAGETYPE_PNG) {
		if ($init or !file_exists($fname)) {
			$im = imagecreate($conf['blackboard_width'], $conf['blackboard_height']);
			imagecolortransparent($im, imagecolorallocate($im, 255, 255, 255));
			return $im;
		} else {
			return imagecreatefrompng($fname);
		}
	}

	/*
	 * ¸롣
	 * $im: ᡼
	 * $fnale: ե̾
	 */
	function image_save($im, $fname) {
		global $conf;
		$tmp = $conf['data_dir'] . "tmp.png";
		imagepng($im, $tmp);
		//rename($tmp, $fname);
		copy($tmp, $fname);
		// unlinkϤޤȤ褦ʤΤ̵
		//unlink($tmp);
	}

	/*
	 * ߡΥեå
	 */
	function image_lock() {
		global $conf;
		$dummy = $conf['data_dir'] . "lock";
		if (!file_exists($dummy)) {
			touch($dummy);
		}
		$f = fopen($dummy, "r");
		flock($f, LOCK_EX);
		return $f;
	}

	/*
	 * ߡΥեΥå
	 */
	function image_unlock($f) {
		flock($f, LOCK_UN);
		fclose($f);
	}

	/*
	 * 褹롣
	 * $im: ᡼
	 * $operands: 
	 * $pen_color: ڥο(r,g,b)
	 * $pen_size: ڥΥ(ľ)
	 */
	function draw_line($im, $operands, $pen_color, $pen_size) {
		$brush = create_brush($im, $pen_color, $pen_size);
		$px = $operands[0];
		$py = $operands[1];
		$size = count($operands);
		$i = ($size > 2) ?  2 : 0;
		while ($i < $size - 1) {
			imageline($im, $px, $py, $operands[$i], $operands[$i+1], IMG_COLOR_BRUSHED);
			$px = $operands[$i];
			$py = $operands[$i+1];
			$i += 2;
		}
		destroy_brush($brush);
	}

	/*
	 * ꤵ줿Υ֥饷
	 * $im: ᡼
	 * $color: ֥饷ο(r,g,b)
	 * $size: ֥饷Υ(ľ)
	 */
	function create_brush($im, $color, $size) {
		$brush = imagecreate($size, $size);
		imagecolortransparent($brush, imagecolorallocate($brush, 255, 255, 255));
		list($r, $g, $b) = $color;		
		$pen_color = imagecolorallocate($brush, $r, $g, $b);
		imagearc($brush, $size/2,$size/2 ,$size,$size, 0,360, $pen_color);
		imagefill($brush, $size/2, $size/2, $pen_color);
		imagesetbrush($im, $brush);
		return $brush;
	}

	/*
	 * ֥饷Ѵ
	 * $brush: Ѵ֥饷
	 */
	function destroy_brush($brush) {
		imagedestroy($brush);
	}

	/*
	 * ץȤ᤹롣
	 * $im: ᡼
	 * $script: ץ
	 */
	function interpret($im, $script) {
		$program = split(' ', $script);
		$operands = array();
		// ڥΥǥեȿ
		$pen_color = array(0xcc, 0xcc, 0xcc);
		// ڥΥǥեȥ
		$pen_size = 1;
		foreach ($program as $op) {
			// 饤l
			if ($op == "l") {
				draw_line($im, $operands, $pen_color, $pen_size);
				$operands = array();
			// Ѥc
			} elseif ($op == 'c') {
				$pen_color = array_splice($operands, -3);
			// Ѥs
			} elseif ($op == 's') {
				$pen_size = array_pop($operands);
			// ¾Ϥߤʿ
			} else {
				array_push($operands, $op);
			}
		}
	}

	/*
	 * 2ɻ
	 * ʬȤФgetꥯȤȯԤޤ
	 */
	function get_self() {
		header('HTTP/1.1 303 See Other');
		header("Location: " . get_script_uri());
	}

	/*
	 * ץȤURI
	 */
	function get_script_uri() {
		return get_server() . $_SERVER['PHP_SELF'];
	}

	/*
	 * Ф
	 */
	function get_server() {
		$to = ($_SERVER['SERVER_PORT'] == 443 ? 'https://' : 'http://');
		$to .= $_SERVER['SERVER_NAME'];
		$to .= ($_SERVER['SERVER_PORT'] == 80 ? '' : ':' . $_SERVER['SERVER_PORT']);
		return $to;
	}

	/*
	 * Ф̾μ
	 */
	function get_blackboard_image_name() {
		global $conf;
		return $conf['data_dir'] . $conf['blackboard_image'];
	}


	/*
	 * ץ饰ɤ
	 * $plugin: ץ饰
	 */
	function plugin_load($plugin) {
		if (file_exists($plugin)) {
			require_once($plugin);
		}
	}

	/*
	 * ץ饰
	 * $name: ץ饰̾
	 */
	function plugin_initialize($name) {
		global $conf;
		plugin_load("plugins/" . $name . "/" . $name . ".inc");
/*
		if (in_array($name, $conf['plugins'])) {
		} else {
			error("̵ʥץ饰󤬻ꤵޤ");
		}
*/
	}

	/*
	 * ץ饰ư
	 * $name: ץ饰̾
	 */
	function plugin_activate($name) {
		$action = $name . "_action";
		if (function_exists($action)) {
			call_user_func($action);
		}
	}

	/*
	 * ¸ץ饰򤹤٤ƥɤ
	 * : ¸ץ饰(Ĺ)
	 */
	function plugin_depends_on() {
		$plugins = func_get_args();
		foreach ($plugins as $name) {
			plugin_initialize($name);
		}
	}

	/*
	 * ꤵƤץ饰ɤ
	 * $point: ץ饰ݥ
	 */
	function plugins_load($point) {
		global $conf;
		foreach ($conf['plugins'] as $name) {
			plugin_load("plugins/$name/$name$point.inc");
		}
	}

	/*
	 * ꤵƤץ饰
	 */
	function plugins_initialize() {
		plugins_load("");
	}

	/*
	 * ꤵƤHTMLץ饰ɤ
	 */
	function plugins_render_html() {
		plugins_load(".html");
	}

	/*
	 * ꤵƤJavaScriptץ饰ɤ
	 */
	function plugins_render_js() {
		plugins_load(".js");
	}

	/*
	 * ꤵƤCSSץ饰ɤ
	 */
	function plugins_render_css() {
		plugins_load(".css");
	}

	/*
	 * Τեɤ
	 */
	function global_conf_load() {
		global $conf;
		$conf = parse_ini_file('blackboard.ini.default');
		custom_conf_load('blackboard');
		$conf['plugins'] = split(',', $conf['plugins']);
	}

	/*
	 * ץ饰եɤ
	 * $name: ץ饰̾
	 */
	function plugin_conf_load($name) {
		global $conf;
		$conf = array_merge($conf, parse_ini_file('plugins/' . $name . '/' . $name . '.ini.default'));
		custom_conf_load($name);
	}

	/*
	 * եɤ
	 * $name: ץ饰̾
	 */
	function custom_conf_load($name) {
		global $conf;
		if (file_exists($conf['conf_dir'] . $name . '.ini')) {
			$conf = array_merge($conf, parse_ini_file($conf['conf_dir'] . $name . '.ini'));
		}
	}

	/*
	 * ե¸
	 * $name: ץ饰̾
	 * $confs: (key:value)
	 * $has_sections: Ĥɤ
	 */
	function custom_conf_save($name, $confs, $has_sections = false) {
		global $conf;
		if (!write_ini_file($confs, $conf['conf_dir'] . $name . '.ini', $has_sections)) {
			error("ե񤭹߼");
		}
	}

	/*
	 * ե
	 * $name: ץ饰̾
	 */
	function custom_conf_remove($name) {
		global $conf;
		$f = $conf['conf_dir'] . $name . '.ini';
		if (file_exists($f)) {
			if (!unlink($f)) {
				error("ե");
			}
		}
	}

	/*
	 * 顼åɽƽλ
	 * $message: å
	 */
	function error($message) {
		header('content-type: text/plain');
		echo "ERROR: " . $message;
		exit;
	}

	/*
	 * ץ饰
	 */
	class PluginInfo {
		// ץ饰̾
		var $name = "";
		// 
		var $author = "";
		// 饤
		var $license = "";
		// С
		var $version = "";
		// ץ饰ۡڡ
		var $homepage = "";
		// ɲǽURL
		var $download = "";
		// ¸ץ饰
		var $dependency = array();
		// 
		var $description = "";
	}

	/*
	 * written by Jomel (k95vz5f02 AT sneakemail DOT com)
	 * see http://jp.php.net/parse_ini_file
	 */
	function write_ini_file($assoc_arr, $path, $has_sections=FALSE) {
		$content = "";

		if ($has_sections) {
			foreach ($assoc_arr as $key=>$elem) {
				$content .= "[".$key."]\n";
				foreach ($elem as $key2=>$elem2) {
					$content .= $key2." = \"".$elem2."\"\n";
				}
			}
		} else {
			foreach ($assoc_arr as $key=>$elem) {
				$content .= $key." = \"".$elem."\"\n";
			}
		}

		if (!$handle = fopen($path, 'w')) {
			return false;
		}
		if (!fwrite($handle, $content)) {
			return false;
		}
		fclose($handle);
		return true;
	}


?>
