<?php
/*
 *
 * $RCSfile: blackboard.php,v $
 * $Date: 2005/07/04 12:42:46 $
 * $Author: die $
 * 
 * Ф󥵡¦ץ
 * 
 * Copyright (c) 2005 die kato
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

	global_conf_load();

	if (isset($_REQUEST['plugin'])) {
		plugin_initialize($_REQUEST['plugin']);
		plugin_activate($_REQUEST['plugin']);

	} else if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		plugins_initialize();
		require_once('blackboard.html.inc');

	// 
	} else if (isset($_POST['erase']) && $_POST['erase'] == 'erase') {
		image_initialize();
		get_self();

	// Ф
	} else if (isset($_POST['s'])) {
		$t = image_update($_POST['s']);
		header('content-type: text/plain');
		echo $t;
	// ¾
	} else {
		header('content-type: text/plain');
		echo "ok";
	}

	/*
	 * 򹹿롣
	 * $script: ץ
	 */
	function image_update($script) {
		$im = image_create();
		$lock = image_lock();
		interpret($im, $script);
		$fname = get_blackboard_image_name();
		image_save($im, $fname);
		image_unlock($lock);

		// ե빹ȤȻפäλǤϤޤե뤬Ƥʤ
		// return gmstrftime("%a, %d %b %Y %H:%M:%S GMT", filemtime($fname));
		// 礦ʤΤǸ߻
		return gmstrftime("%a, %d %b %Y %H:%M:%S GMT");
	}

	/*
	 * 롣
	 */
	function image_initialize() {
		global $conf;
		$im = imagecreate($conf['blackboard_width'], $conf['blackboard_height']);
		imagecolortransparent($im, imagecolorallocate($im, 255, 255, 255));
		image_save($im, get_blackboard_image_name());
	}

	/*
	 * ᡼֥Ȥ롣
	 */
	function image_create() {
		$fname = get_blackboard_image_name();
		//if (!file_exists($fname) || exif_imagetype($fname) != IMAGETYPE_PNG) {
		if (!file_exists($fname)) {
			image_initialize();
		}
		return imagecreatefrompng($fname);
	}

	/*
	 * ¸롣
	 * $im: ᡼
	 * $fnale: ե̾
	 */
	function image_save($im, $fname) {
		global $conf;
		$tmp = $conf['data_dir'] . "tmp.png";
		imagepng($im, $tmp);
		rename($tmp, $fname);
		// unlinkϤޤȤ褦ʤΤ̵
		//unlink($tmp);
	}

	/*
	 * ߡΥեå
	 */
	function image_lock() {
		global $conf;
		$dummy = $conf['data_dir'] . "lock";
		if (!file_exists($dummy)) {
			touch($dummy);
		}
		$f = fopen($dummy, "r");
		flock($f, LOCK_EX);
		return $f;
	}

	/*
	 * ߡΥեΥå
	 */
	function image_unlock($f) {
		global $conf;
		$dummy = $conf['data_dir'] . ".lock";
		flock($f, LOCK_UN);
		fclose($f);
	}

	/*
	 * 褹롣
	 * $im: ᡼
	 * $operands: 
	 * $pen_color: ڥο
	 */
	function draw_line($im, $operands, $pen_color) {
		$px = $operands[0];
		$py = $operands[1];
		$size = count($operands);
		$i = ($size > 2) ?  2 : 0;
		while ($i < $size - 1) {
			imageline($im, $px, $py, $operands[$i], $operands[$i+1], $pen_color);
			$px = $operands[$i];
			$py = $operands[$i+1];
			$i += 2;
		}
	}

	/*
	 * ץȤ᤹롣
	 * $im: ᡼
	 * $script: ץ
	 */
	function interpret($im, $script) {
		$program = split(' ', $script);
		$operands = array();
		// ߤϥڥοϰ쿧
		$pen_color = imagecolorallocate($im, 0xcc, 0xcc, 0xcc);
		foreach ($program as $op) {
			// ޤΤȤڥ졼ϥ饤lפ
			if ($op == "l") {
				draw_line($im, $operands, $pen_color);
				$operands = array();
			// ¾Ϥߤʿ
			} else {
				array_push($operands, $op);
			}
		}
	}

	/*
	 * 2ɻ
	 * ʬȤФgetꥯȤȯԤޤ
	 */
	function get_self() {
		header('HTTP/1.1 303 See Other');
		header("Location: " . get_script_uri());
	}

	/*
	 * ץȤURI
	 */
	function get_script_uri() {
		return get_server() . $_SERVER['PHP_SELF'];
	}

	/*
	 * Ф
	 */
	function get_server() {
		$to = ($_SERVER['SERVER_PORT'] == 443 ? 'https://' : 'http://');
		$to .= $_SERVER['SERVER_NAME'];
		$to .= ($_SERVER['SERVER_PORT'] == 80 ? '' : ':' . $_SERVER['SERVER_PORT']);
		return $to;
	}

	/*
	 * Ф̾μ
	 */
	function get_blackboard_image_name() {
		global $conf;
		return $conf['data_dir'] . $conf['blackboard_image'];
	}


	/*
	 * ץ饰ɤ
	 * $plugin: ץ饰
	 */
	function plugin_load($plugin) {
		if (file_exists($plugin)) {
			require_once($plugin);
		}
	}

	/*
	 * ץ饰
	 * $name: ץ饰̾
	 */
	function plugin_initialize($name) {
		global $conf;
		if (in_array($name, $conf['plugins'])) {
			plugin_load("plugins/" . $name . "/" . $name . ".inc");
		} else {
			error("̵ʥץ饰󤬻ꤵޤ");
		}
	}

	/*
	 * ץ饰ư
	 * $name: ץ饰̾
	 */
	function plugin_activate($name) {
		$action = $name . "_action";
		if (function_exists($action)) {
			call_user_func($action);
		}
	}

	/*
	 * ¸ץ饰򤹤٤ƥɤ
	 * : ¸ץ饰(Ĺ)
	 */
	function plugin_depends_on() {
		$plugins = func_get_args();
		foreach ($plugins as $name) {
			plugin_initialize($name);
		}
	}

	/*
	 * ꤵƤץ饰ɤ
	 * $point: ץ饰ݥ
	 */
	function plugins_load($point) {
		global $conf;
		foreach ($conf['plugins'] as $name) {
			plugin_load("plugins/$name/$name$point.inc");
		}
	}

	/*
	 * ꤵƤץ饰
	 */
	function plugins_initialize() {
		plugins_load("");
	}

	/*
	 * ꤵƤHTMLץ饰ɤ
	 */
	function plugins_render_html() {
		plugins_load(".html");
	}

	/*
	 * ꤵƤJavaScriptץ饰ɤ
	 */
	function plugins_render_js() {
		plugins_load(".js");
	}

	/*
	 * ꤵƤCSSץ饰ɤ
	 */
	function plugins_render_css() {
		plugins_load(".css");
	}

	/*
	 * Τեɤ
	 */
	function global_conf_load() {
		global $conf;
		$conf = parse_ini_file('blackboard.ini.default');
		custom_conf_load('blackboard');
		$conf['plugins'] = split(',', $conf['plugins']);
	}

	/*
	 * ץ饰եɤ
	 * $name: ץ饰̾
	 */
	function plugin_conf_load($name) {
		global $conf;
		$conf = array_merge($conf, parse_ini_file('plugins/' . $name . '/' . $name . '.ini.default'));
		custom_conf_load($name);
	}

	/*
	 * եɤ
	 * $name: ץ饰̾
	 */
	function custom_conf_load($name) {
		global $conf;
		if (file_exists('conf/' . $name . '.ini')) {
			$conf = array_merge($conf, parse_ini_file('conf/' . $name . '.ini'));
		}
	}

	/*
	 * 顼åɽƽλ
	 * $message: å
	 */
	function error($message) {
		header('content-type: text/plain');
		echo "ERROR: " . $message;
		exit;
	}

?>
