/*
The Black Swan Project
Distributed under the MIT License
© Copyright Maxim Bortnikov 2023
For more information please visit
https://github.com/Northstrix/Black_Swan
Required libraries:
https://github.com/adafruit/Adafruit-GFX-Library
https://github.com/adafruit/Adafruit_BusIO
https://github.com/adafruit/Adafruit_ILI9341
https://github.com/adafruit/Adafruit-ST7735-Library
https://github.com/techpaul/PS2KeyAdvanced
https://github.com/techpaul/PS2KeyMap
*/
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_ST7735.h>
#define TFT_CS1         5
#define TFT_RST1        19
#define TFT_DC1         22
Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS1, TFT_DC1, TFT_RST1);

void disp_centered_text(String t_disp, int y){
   int16_t x1, y1;
   uint16_t w, h;
   tft.getTextBounds(t_disp, 160, 0, &x1, &y1, &w, &h);
   tft.setCursor(80 - (w / 2), y);
   tft.print(t_disp);
}

const uint16_t Dublin PROGMEM [160][129] = {
{19446,19447,19447,21527,21527,21527,21559,21559,21559,21527,21560,21560,21592,21592,21592,21592,21592,21592,21592,21592,23640,21592,21624,21592,21592,21592,21592,23640,23640,23640,21592,21592,21592,21592,21592,21624,21592,21592,21592,21592,21592,23640,21592,21592,21592,21592,21592,21624,21592,21592,21560,19512,19512,19480,19512,19512,17332,6471,12778,8551,6438,8519,10600,4292,6470,12810,6404,4259,4227,4259,4259,4259,4226,4226,2178,2146,2114,4162,4162,6305,6273,4161,4128,12449,25191,35752,33476,27074,8322,8322,4161,12516,10533,8453,8452,8453,10534,10534,10533,10533,8453,8485,14661,16709,14694,18691,16742,16807,18789,18757,16676,12549,8452,10533,10598,14596,14531,12451,12450,12450,12450,12450,12418,12450,12418,10338,8289,10337,255},
{19446,19446,19446,21527,21527,21527,21559,21559,21527,21527,21528,21560,21560,21592,21592,21592,21592,21592,21592,21592,23640,23640,21592,23640,21592,23640,23640,21592,21592,23640,23672,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,19512,19512,19511,19512,19479,17333,6504,10665,6406,8487,6438,4324,2211,4291,2211,2243,2211,4259,4227,4226,4226,4226,4226,2178,2146,2146,2113,2146,4258,4193,2145,2081,12449,14529,10401,10401,12513,12481,8289,4161,10435,8485,8452,8452,8453,10533,10534,10534,10533,8453,8485,12581,14662,14662,16611,16742,16775,16710,16709,14596,10533,8420,8485,10566,12515,14530,14531,12450,12450,12450,12450,10370,10370,10338,10338,10337,8290,255},
{19446,19446,19446,21527,21527,21527,21527,21527,21527,21527,21559,21559,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,23640,21592,23640,23640,23640,23640,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,23640,21592,21592,21560,19512,19512,19511,19479,19479,17431,17365,8617,10632,6406,4292,4291,4291,2211,6437,6405,2211,4259,2179,4259,4227,2178,2178,2178,4258,2178,2145,2145,2178,6596,6563,4483,2081,8289,16611,20869,16707,20801,18720,16608,10402,10468,8485,8452,8420,8452,10533,10533,10533,10533,8453,10533,12581,12614,14661,16611,16710,14727,16710,16709,14596,10533,8452,8453,10566,12483,12450,14531,12450,12418,12450,12418,10337,10338,10338,10369,10369,10369,255},
{19446,19446,19446,19446,21527,21527,21527,21527,21527,21527,21559,21559,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,23640,23640,23640,23640,23672,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,19512,19512,19512,19479,19479,17431,17365,8617,6438,8487,8519,10600,6437,2211,8551,8518,4291,2178,2178,2211,2178,2146,2146,2146,2145,2145,2145,2113,2113,2081,2113,2113,2081,4129,14726,29547,18851,16641,16608,12448,8289,8387,8452,8452,6372,8420,8453,10533,10533,10533,8453,8485,10533,10566,10501,14563,14694,14694,14662,14629,12548,10566,10533,8453,10534,12482,12450,14531,12450,12418,12418,10370,12418,10338,10337,8289,8289,8321,255},
{19446,19446,19446,19446,19479,21527,21527,21559,21527,21559,21559,21559,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,21560,19512,19512,19479,17431,17431,17397,10697,6406,8519,8487,6405,2211,4291,2211,2211,2211,2179,2179,2178,2178,98,65,2114,2145,2145,2113,2113,2242,2435,2274,2145,2081,4161,6208,16480,20770,10369,8321,6209,8289,8387,8420,8452,6372,6372,8452,8485,8485,10533,8452,10565,10533,10566,8420,12484,12614,14662,14662,14629,12516,12647,14726,10566,10534,10402,12450,12450,10370,10370,10370,10337,10337,10337,8289,8289,8289,8289,255},
{19446,19446,19446,19446,19447,21527,21527,21527,21527,21559,21559,21560,21560,21560,21560,21560,21592,21560,21559,21559,21559,21560,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,21560,19512,19512,19511,19479,17431,17431,17398,10665,6406,8486,4292,8518,4324,4291,6405,2211,2178,2178,2178,2211,2211,98,66,2113,2146,2113,2113,2113,4354,4643,4386,4226,2081,6241,18821,39298,33282,18721,14529,18690,10402,8387,8420,10533,6372,6372,8452,8453,8453,10533,8420,10533,8453,10501,8453,8388,12614,14694,14629,14629,10501,10567,10567,12647,10501,10402,10402,10402,8290,10370,10370,10337,10337,8289,8257,10337,10337,10337,255},
{19414,19446,19446,19446,19446,19479,21527,21527,21527,21559,21559,21560,21560,21559,21560,21560,21559,21560,21560,21559,21559,21559,21560,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,19512,19512,19512,19511,17431,17431,17431,17431,17201,8487,8519,8551,8519,4259,4291,4291,2211,2179,2178,2178,2178,98,66,66,65,2113,2113,2113,2113,2081,2081,2081,2113,4161,10401,18919,37315,24929,14561,12417,12449,6241,6339,6372,8453,6340,6372,8452,8452,8453,8485,8452,10566,8453,8452,8453,6372,10566,12614,12581,12549,10501,10566,10567,10599,8420,10402,10370,10402,8290,8322,10370,8289,8257,8257,8257,10337,10337,10337,255},
{19414,19446,19446,19446,19447,19446,21527,21527,21527,21527,21559,21559,21559,21559,21559,21559,21559,21527,21559,21559,21559,21559,21559,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,21560,21560,21560,21560,19512,19511,19511,19511,19479,17431,17431,17432,17234,8487,6406,4292,4292,2211,2211,2179,2178,2178,4226,4226,2178,2146,66,66,2146,65,2113,2113,2146,6506,4327,2178,2146,4161,10402,12417,18561,6209,32,33,4161,6242,6307,6372,8453,8453,6372,8452,6404,8452,8485,8452,10566,8420,8420,8453,6340,10534,10533,10533,12549,10501,10567,10567,10567,8388,10402,10370,10370,8322,8290,8290,8290,8290,8257,10337,10337,10337,10338,255},
{19414,19414,19446,19446,19446,19446,19479,19479,21527,21527,21527,21527,21559,21559,21559,21559,21527,21559,21559,21559,21559,21559,21559,21560,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,21560,21560,21560,19512,19512,19512,19512,19479,19479,17431,17399,17432,15023,6406,6406,8518,8519,2211,10631,8518,2211,2179,4226,6307,12451,10434,2146,2146,4226,2146,2146,2113,2114,4360,4325,2146,2146,4161,12482,16513,24769,10337,0,0,4161,8322,6307,6340,6372,6372,6340,8420,8452,8420,8453,6372,10533,8420,18691,12548,6340,12647,10501,10501,10500,8453,10566,10534,10534,8356,10370,10402,10370,8322,8290,8290,8290,12483,16546,10305,8257,8289,8290,255},
{19414,19414,19414,19446,19446,19446,19446,19479,21527,21527,21527,21527,21527,21527,21559,21527,21527,21559,21527,21559,21559,21559,21559,21559,21560,21560,21592,21592,23640,23640,21592,21592,21592,21592,21592,21592,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,19512,19479,19479,19479,19479,17431,17431,17431,12844,6406,8519,8519,4325,2179,6405,4324,2211,2210,4226,4226,4226,2178,2146,2146,2113,2145,2113,2145,2113,2113,2081,2113,2113,2081,4161,18593,28929,10337,6177,2080,2081,6241,6307,6372,6372,8485,6340,8420,8420,8420,8453,6372,10533,6372,22819,12548,6340,10566,8453,8453,8420,8453,10534,8454,8454,6307,8322,8322,8322,8290,8290,8290,8290,8387,24869,14433,8289,8257,6242,255},
{19414,19414,19414,19446,19446,19446,19446,19446,19479,21527,21527,21527,21527,21527,21559,21527,21527,21527,21527,21559,21559,21559,21559,21560,21560,21560,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,21560,21592,21560,21560,19512,19511,19479,19479,17431,17431,17399,17399,8617,6406,2212,2211,2211,2211,4292,2211,2211,2178,2178,4259,4226,4226,2146,2146,4323,4259,2146,2113,2113,6409,4327,4227,2146,2081,2113,18593,31008,14465,28801,6176,8289,8322,6307,8453,6372,8421,6340,6372,8420,8452,8453,6372,8485,6372,22852,10468,4291,8485,8453,8452,6372,6373,8454,8454,8422,6307,6275,8323,8322,8322,8290,6242,8258,6308,12582,20740,8257,8290,6242,255},
{19414,19414,19414,19414,19446,19446,19446,19446,19479,19479,21527,21527,21527,21527,21527,21527,21527,21527,21527,21527,21527,21559,21559,21559,21559,21559,21560,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,21560,21560,21560,21560,19512,19512,19479,19479,17431,17399,17399,15285,8519,6406,6405,8519,4324,4292,12909,12844,4292,2211,2211,10598,22787,10402,2146,2146,12872,8517,4226,2146,2113,4261,4293,4227,2114,2081,2113,27207,35590,22946,20704,18592,14562,8322,6307,6372,6372,8420,8453,6372,6372,6404,8452,6372,8485,6372,20772,8420,4259,8452,8420,8420,6372,6373,8454,8422,6373,4227,4194,6275,6242,6274,6242,6242,6242,6308,8454,10534,20741,8290,6242,255},
{19414,19414,19414,19414,19414,19446,19446,19446,19446,19446,19447,21527,21527,21527,21527,21527,21527,21527,21527,21527,21559,21559,21559,21559,21527,21527,21559,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,21560,21592,21560,21592,21592,21592,21560,21592,21560,21560,21560,19512,19511,19479,19479,17431,17399,17399,15219,6406,6406,6438,6373,2211,4291,6438,6405,4259,2211,2211,4259,4226,4226,4194,4226,2178,2146,2146,2146,2114,4161,2113,2113,2113,2081,2081,25288,37766,31265,26912,22752,20869,12483,6339,6340,6372,6372,8485,6340,6372,6372,6372,6372,8453,8420,27012,6340,4259,8452,8420,8420,6340,6405,8486,8454,6341,2179,2178,4259,4226,4194,4194,4194,6242,6340,8422,8422,12582,8322,6242,255},
{17366,19414,19414,19414,19446,19446,19446,19446,19446,19446,19479,19479,21527,21527,21527,21527,21527,21527,21527,21527,21559,21559,21559,21559,21527,21527,21559,21560,21560,21592,21560,21592,21560,21560,21560,21592,21560,21560,21560,21560,21592,21592,21592,21592,21592,21560,21560,21560,19512,19512,19511,19511,19479,17431,17431,17431,13040,4293,4293,2211,2211,2178,4291,4291,4291,4259,4259,8419,14660,16612,4226,2178,2178,2178,2178,2146,2113,2179,4556,6603,6504,4259,2081,2081,8288,31331,33347,16512,14465,14594,14563,6307,6340,6372,6372,6372,6372,6372,6372,6372,6372,8420,8420,24932,6340,6339,14661,6340,6372,6340,6372,8486,8454,6341,2178,2178,4259,2178,4226,4194,4194,6274,8453,8454,8422,8421,6242,6242,255},
{19413,19414,19414,19414,19446,19446,19446,19446,19446,19446,19478,19479,19479,19479,21527,21527,21527,21527,21527,21527,21527,21559,21559,21559,21527,21528,21559,21560,21560,21559,21560,21560,21560,21592,21592,21592,21560,21560,21560,21560,21592,21592,21592,21592,21560,21560,21560,21560,19512,19512,19511,19479,19511,17431,17431,17431,12909,4260,4293,6406,6405,2211,6503,12909,8552,2211,4259,27108,51973,49667,10402,2146,2178,2211,2178,2146,2145,4227,4587,6601,6437,4194,2081,4129,12548,33675,35526,26913,22754,18658,12450,8355,6372,6372,6372,10533,8453,6372,8420,6372,6372,6372,6372,18789,6340,6340,22949,8388,6372,4292,4292,6405,8486,6340,2178,2178,4259,2178,2146,4194,4194,4194,6405,10599,8422,6341,6242,6242,255},
{17333,19413,19414,19414,19414,19414,19446,19446,19446,19446,19446,19446,19446,19446,19479,21527,21527,21527,21527,21527,21527,21559,21559,21527,21527,21527,21559,21560,21560,21560,21560,21560,21560,21592,21592,21592,21560,21560,21592,21592,21592,21592,21560,21592,21560,21560,21592,21560,19512,19512,19512,19511,19511,17431,17431,17431,8650,4292,6373,6405,4292,2178,6372,6438,4324,4258,4226,6306,10467,8387,4226,4194,6340,8420,10467,4193,4162,4161,4129,4096,4096,4129,4129,8257,24705,37026,26753,24737,29027,29158,22884,10403,8420,8420,8452,10533,10533,6372,8420,6372,6372,6372,6339,8453,4292,6372,29125,10468,6372,4291,4291,4291,8453,4292,2178,2146,2178,2178,2146,2146,4194,4226,8453,12647,8421,6308,6242,4194,255},
{17333,19413,19413,19414,19414,19414,19446,19446,19446,19446,19446,19446,19446,19446,19479,19479,21527,21527,21527,21527,21559,21559,21559,21527,21527,21559,21559,21559,21559,21560,21560,21560,21560,21560,21592,21592,21592,21592,21592,21592,21592,21592,21592,21560,21560,21592,21560,19512,19512,19480,19512,19512,19512,19512,17463,17430,8552,4292,2179,2179,2179,4226,4291,4259,4259,4226,4226,4259,4259,4259,4194,14727,25194,12613,8387,2145,2113,4292,12905,8549,8549,8322,6177,10305,37026,51686,35010,30915,26980,29125,24899,16547,12517,10501,8421,8453,8452,6372,8453,6372,6404,6372,4291,6372,4292,6372,29093,16676,6372,4292,4259,4259,6372,6372,2178,2178,2146,2146,2146,2146,4194,4194,10534,10534,8454,6340,8290,6242,255},
{17333,17333,19381,19414,19414,19414,19414,19414,19446,19446,19446,19446,19446,19446,19446,19446,19479,21527,21527,21527,21559,21559,21559,21527,21527,21527,21527,21527,21560,21560,21560,21560,21560,21560,21592,21560,21592,21560,21560,21592,21592,21560,21560,21592,21592,21592,21560,19512,19512,19480,19512,19511,19512,19512,17464,17365,6438,4292,4292,4324,4259,4227,12778,10697,4292,4226,4227,4259,2211,4227,8420,20968,21033,14759,10533,12613,12581,14727,23339,18918,18822,18725,16644,18692,37608,41965,31108,33220,35333,33220,26979,18627,14565,12549,12549,12549,12582,8420,10501,6372,8453,6340,4292,4292,4292,8420,27012,22916,6372,4292,4259,4259,4259,6340,2178,2178,2146,2146,2146,2146,4194,4226,8453,6341,8519,8421,8290,6210,255},
{17333,17333,17333,17333,17366,19414,19414,19414,19446,19446,19446,19446,19446,19446,19446,19446,19479,21527,21527,21527,21527,21559,21559,21527,21527,21527,21527,21559,21560,21560,21560,21560,21560,21560,21592,21592,21560,21560,21560,21592,21592,21592,21592,21560,21560,21560,21560,21560,19512,19512,19511,19512,19512,19512,19512,17300,6373,4293,4292,4259,2146,4226,8518,8518,6339,4226,4259,4259,4259,4226,6275,6242,6242,6274,6274,6242,6209,6209,8224,8225,12417,12386,10304,16513,28962,26946,31105,31106,31074,28994,22786,20707,16580,14565,12517,12517,18759,14597,12549,8420,10501,6340,6340,4292,4291,10500,24931,31172,6340,4291,4291,4259,4227,4259,2178,2146,4194,4194,2146,2146,4194,2178,8486,8421,10567,6307,6242,6210,255},
{17333,17333,17333,17333,17366,19414,19414,19414,19414,19414,19446,19446,19446,19446,19446,19446,19479,19479,21527,19479,21527,21527,21559,21559,21527,19479,19479,21559,21560,21560,21560,21560,21560,21560,21560,21592,21560,21560,21560,21592,21592,21592,21560,21560,21560,21560,19544,19512,19512,19512,19512,19512,19512,19512,19545,15088,4260,4227,2146,2146,2178,4259,4291,6372,8452,8453,8485,8485,6372,10565,10533,10501,10533,10500,8355,6274,14596,16611,18691,16611,12417,16513,26946,46189,43948,41703,45895,41605,37380,43652,35333,29124,20676,16581,14565,14565,16645,16645,14565,12484,14565,6339,6340,4292,4291,12548,31140,39395,12515,6307,6307,4259,4227,2178,2178,2146,2146,2146,2146,4194,2146,2178,8485,8421,8486,6275,6242,6242,255},
{17333,17333,17333,17333,17365,19413,19414,19414,19414,19414,19446,19446,19446,19446,19446,19446,19446,19479,21527,21527,21527,21559,21559,21559,21527,21527,19511,21560,21560,21560,21560,21560,21560,21560,21560,21592,21560,21560,21560,21560,21560,21560,21560,21560,19512,19512,19512,19512,19512,19544,19544,19544,19545,21592,21559,12876,8485,8485,8485,6405,10598,12711,10566,12711,27500,33870,40336,31820,12646,14759,14759,14791,14759,12646,8387,4162,10370,12418,18659,18658,18593,18560,29092,59164,48402,37412,39620,35364,20641,33218,37445,31140,20644,16580,16549,16581,14533,14533,14564,12452,16581,10436,8388,6339,6372,16676,24963,37250,22819,6307,6307,6307,4226,2178,4194,2146,2146,2146,2146,4194,4194,4259,8453,6308,8388,6242,6242,6242,255},
{17301,17333,17333,17333,19413,19413,19413,19413,19414,19414,19414,19414,19414,19414,19446,19446,19446,19446,19479,21527,21527,21527,21527,21527,21527,21559,21560,21560,21560,21560,21560,21560,21560,21559,21560,21560,21560,21560,21560,21560,21560,19512,19512,19512,19511,19512,19512,19512,19544,21592,21592,19445,17201,14956,12745,14792,16937,14792,8518,6372,10533,12711,6340,12678,19017,29644,33933,27595,12678,14791,14759,14759,16872,14726,10468,8322,16612,18692,22820,20739,18625,18528,24769,37543,35333,37315,45700,41604,37381,39493,29059,26753,24643,20644,20645,18597,16549,16581,16613,14500,16580,12451,12484,8387,8420,22852,28962,37058,45282,14531,12483,10403,6274,4194,4194,4193,4194,4194,2114,4194,4194,4227,6340,8388,10437,6242,6210,6242,255},
{17301,17301,17333,17333,19381,19413,19413,17366,19414,19414,19414,19414,19414,19414,19414,19446,19446,19446,19446,19479,21527,21527,21527,21527,21559,21559,21560,21560,21560,21560,21560,21560,21560,21560,21560,21592,21560,21560,21560,21560,19512,19479,19446,12974,15054,17167,15054,12843,14923,14955,14890,12744,14792,14824,14857,16970,19018,14824,8518,14824,23212,19051,6405,19019,23245,23212,21099,18985,16872,23211,21098,21033,21033,16807,12548,16644,27111,25030,29158,27013,20674,20544,30752,43233,41153,37219,39396,35332,31172,31171,24833,39041,39043,35012,35077,24804,20676,22790,20710,14500,16580,14499,14499,12515,14627,35074,39138,33026,59521,28931,20707,20675,10434,8322,6274,6241,4194,4194,4194,4194,2146,4259,10436,14500,8323,8290,6210,6242,255},
{17300,17333,17333,17333,17333,17333,19413,19413,19414,19414,19414,19414,19414,19414,19414,19446,19446,19446,19446,19446,19479,21527,21527,21559,21559,21559,21559,21559,21560,21560,21560,21560,21560,21560,21560,21560,21560,21560,21560,19512,19512,19512,15022,8452,12679,12711,12679,10631,14824,16905,16905,16937,16938,19050,19051,21131,21131,14792,8518,21131,25325,19051,8453,23212,25325,25293,21098,18985,18985,23243,21098,23146,21033,14759,12548,14596,25030,27110,27078,24932,20641,24641,41123,60074,57767,47523,49829,39493,26915,28929,30977,55619,57797,53603,51621,41283,33028,24837,22821,16547,18628,16579,16579,18723,24932,49378,49345,31010,59424,43201,26915,26851,18626,10434,8354,8289,6242,6242,4194,4162,4162,12419,10339,16483,8291,8290,6242,6242,255},
{17300,17332,17333,19381,17333,19381,19381,19413,19413,19414,19413,19414,19414,19414,19414,19414,19446,19446,19446,19446,19446,19479,21527,21527,21559,21559,21560,21560,21560,21560,21560,21560,21560,21560,21560,21560,21560,21560,21560,19512,19512,19511,10730,10565,12711,14792,12679,12711,14792,16905,14825,16905,16937,16938,19083,19083,19051,12711,8485,19018,23212,16905,8485,21131,23212,21131,21163,16905,16872,19050,19017,19017,18985,12678,10468,12450,22884,26980,29093,26947,22689,32962,51980,63357,56628,55942,49797,37381,31076,35235,41541,57796,61990,59844,55684,49507,41252,26852,20676,16548,18628,18627,18691,20770,35139,55489,49345,28995,49281,53345,28931,28899,20706,12514,10434,8321,8290,6242,4194,4162,6210,12419,10339,10339,14435,8290,6210,6242,255},
{17300,17332,17333,17333,17333,17333,19381,19381,19381,19413,19413,19414,19414,19414,19414,19414,19414,19446,19446,19446,19446,19447,21527,21527,21559,21559,21559,21528,21560,21560,21560,21560,21528,21560,21560,21560,21560,21560,21560,19512,21560,19479,12876,10664,12778,12843,10697,8584,12745,10631,10631,10598,6405,6404,12711,19050,21163,12744,8517,10566,14825,10631,8485,12646,12646,16872,19017,12679,14727,10501,12613,16937,14824,10533,8355,10369,22690,33026,43493,26882,22721,32994,49833,63227,58577,49765,43491,37412,29059,31139,45830,57763,55619,51588,49540,43363,35140,24804,18596,16549,18627,18627,18691,20802,37186,55521,45282,24899,37122,59521,30947,24867,20739,12514,10434,8321,6241,4193,4193,4194,10403,10371,8323,6242,14435,8290,6210,4162,255},
{17301,17300,17332,17333,17333,17333,17333,17333,19381,19413,19413,19413,19414,19414,19414,19414,19414,19446,19446,19446,19446,19446,21527,21527,21559,21559,21559,21528,21528,21528,21527,21528,21528,21560,21559,21560,21560,21560,21560,19512,19512,19512,19479,19446,17398,17431,19479,19479,17234,4227,6372,6405,6372,4259,4259,6372,12744,14824,10598,12744,16937,10631,14759,16807,18952,21066,18985,16840,18953,16840,16840,18985,16872,14661,12548,22918,24998,27046,29126,20739,20609,26785,39202,49603,41251,45507,43587,39589,37543,41572,39459,45281,39073,35107,39204,28932,24804,18628,16580,16581,16548,16579,16611,18690,35107,49442,39202,22884,22883,57569,39107,20771,14594,10466,6305,6274,4193,4194,2146,2114,6274,14531,2146,6243,6242,6242,6210,4162,255},
{17301,17300,17332,17333,17333,17333,17333,17333,17333,19381,19381,19381,19413,19413,19413,19414,19414,19414,19414,19446,19446,19446,21527,21527,21527,21559,21527,21527,21527,21527,21527,21527,21559,21559,21559,21528,21559,21560,19511,19511,19512,19512,19479,19479,19479,17431,19479,19512,17332,8518,19018,12711,14793,2179,2178,4259,10630,12744,14792,21131,21163,12711,18985,25325,25357,25357,25325,19017,25324,27437,25324,25292,21066,14694,16677,29224,33353,31272,31305,22885,16481,22657,33122,47975,39622,56164,56034,47909,41704,47876,37477,33025,26787,22724,22724,18596,18629,14533,14532,14533,14500,12452,14499,14531,35107,39266,35139,16707,14659,45313,45282,14563,8418,6338,4226,4226,4194,4194,2146,2145,2113,10402,4226,4227,4194,6242,6242,4162,255},
{17269,17301,17300,17301,17301,17333,17333,17333,17333,19381,19381,19381,19413,19413,19413,19414,19414,19414,19414,19446,19446,19446,19446,21527,21527,21527,21527,21527,21527,21527,21527,21559,21559,21559,21559,21528,21560,21559,19512,19512,19512,19512,19479,19479,19511,19511,19511,19511,17365,8486,10631,10599,4259,2146,2146,2211,4291,10630,14857,25357,23277,14792,16905,25325,27307,33516,33548,18953,23146,25259,23179,23114,18952,12613,14596,33092,51816,37091,28931,20707,18593,24801,48369,57015,50513,41801,28993,31171,37508,54468,44105,31107,22755,18597,18597,16549,16581,14533,12452,14533,12452,12452,12452,12451,31011,24802,28963,10467,10467,33090,49505,12482,4258,4226,2178,2178,2178,2146,2146,2145,4194,6242,12483,6275,4194,4162,4162,4194,255},
{17268,17300,17300,17300,17300,17301,17301,17333,17333,19381,19381,19381,19381,19381,17333,19414,19414,19414,19414,19414,19414,19446,19446,19479,19479,19479,19446,21527,21527,21527,21527,21527,21527,21527,21527,21527,21528,21559,21559,21559,19511,19479,19479,19479,19479,19479,19479,19511,19479,8584,8453,8453,6405,2146,2146,2211,2178,8518,12679,12712,16938,14792,14759,16774,39593,58218,51978,16839,21033,18953,18986,18856,14792,12646,12516,41252,62574,43202,37122,22722,18625,24898,52661,46288,37837,41801,37283,37316,29028,31235,41733,31172,18660,14500,16581,14533,14533,14565,12484,14565,12452,10404,10404,10404,26916,16546,22787,6307,6307,28994,39330,12483,2178,2178,2146,2146,2178,2146,2146,2146,4226,2113,10403,8322,2146,2114,2146,2114,255},
{17300,17300,17300,17300,17332,17332,17333,17333,17333,17333,17333,17333,17333,17333,19413,19414,19414,19414,19414,19414,19414,19446,19446,19446,19446,19446,19446,19446,19446,21527,21527,21527,21527,21527,21527,21559,21559,21559,21559,21559,19511,19512,19479,19479,19479,19479,19479,19479,19479,10665,8453,8485,6405,2178,2146,2211,2178,8485,14792,14792,16906,14825,14760,16807,25095,43786,41674,16839,18953,18985,21066,21033,18985,12614,14629,28965,49608,37157,31109,22820,18658,29092,39786,39915,31594,44074,50151,41702,37511,41702,35364,24964,18692,14500,14533,14565,14565,12517,12484,14533,10404,10404,8356,10403,20739,14466,20739,6275,6275,24900,31043,20739,2178,2178,2146,2146,2178,2146,2146,2146,4194,4162,6242,8323,2113,2146,2114,2114,255},
{17300,17300,17300,17300,17300,17333,17333,19349,19349,17333,17333,17333,17333,17333,19381,19381,19413,19414,19414,19414,19414,19414,19446,19446,19446,19446,19446,19446,19446,19446,19479,21527,21527,21527,21559,21559,21559,21559,21559,19511,19511,19479,19479,19479,19479,19479,19479,19479,19511,12811,8486,8486,6405,2178,2146,2178,2178,6405,16905,19018,16906,14825,14760,23276,23244,25390,27470,21098,23179,29518,29486,27405,27340,16807,18790,27144,33418,29224,29224,24966,16577,20705,26945,43781,35657,56520,64645,50021,41704,47941,41539,29092,18692,14500,16613,14565,14533,12517,12485,12517,10404,10404,8356,10403,20707,12418,20707,6275,6307,20772,24835,29027,4226,2178,2146,2146,2146,2146,2146,4194,4194,2114,4194,6274,2113,2146,2146,2146,255},
{17268,17300,17300,17300,17300,17300,17301,17300,17332,17333,17301,17333,17333,17333,17333,19381,19381,19413,19413,19414,19414,19414,19414,19446,19446,19446,19446,19446,19446,19446,19446,21527,21527,21527,21527,21527,21559,21559,21559,19479,19511,19479,19479,19479,19479,19479,19479,19511,19512,12876,8454,8486,8486,2179,2146,2178,2178,6404,14824,16905,16905,14857,12679,25325,27405,29485,31565,23146,21066,29452,27372,25259,25194,16807,16742,20837,37351,33157,31109,22820,18625,20705,39818,56948,50251,47878,45668,43717,47909,47908,51909,37316,22788,14532,16613,14533,14533,12517,12485,14565,10404,8356,10404,12451,20675,12418,18627,4227,12483,22788,16579,31076,10435,2146,2146,2146,2146,2146,2146,2146,2114,2113,8355,12517,2145,2113,2146,2145,255},
{17268,17268,17300,17300,17300,17300,17300,17300,17332,17301,17301,17333,17333,17333,17333,17333,19381,19413,19413,19413,19413,19414,19414,19446,19414,19446,19446,19446,19446,19446,19446,19479,19479,21527,21527,21527,21559,21559,21559,21527,19479,19479,19479,19479,19479,19479,19478,19479,21591,14990,6405,6372,6404,2179,2146,2178,2178,6372,14792,21131,14825,16938,12679,25193,45767,54187,54220,20968,16872,18985,19051,14858,14760,12646,10500,30915,60300,47427,37122,24802,20706,24898,48402,50612,52236,47749,35042,37381,45828,47844,35333,29060,22788,16548,16549,16549,14533,14533,12485,14565,10404,8356,8356,12452,20675,12386,20675,4227,16579,20675,12419,26916,22756,2146,2146,2146,2146,2146,2113,2146,4194,2113,8355,10436,2146,2146,2146,2146,255},
{17268,17268,17300,17300,17300,17300,17332,17332,17300,17300,17300,17333,17333,19381,19381,17333,19381,19413,19413,19413,19413,19414,19414,19414,19414,19414,19414,19446,19446,19446,19446,19478,19479,21527,21527,21559,21559,21559,21527,21527,21527,21527,19479,19479,19479,12909,12777,14890,14891,10664,6340,4291,4291,2178,2146,2178,2178,6372,14792,12679,14825,14825,12679,20968,41607,43883,43850,23049,18953,16905,21099,20969,16905,16872,18920,27014,43495,37317,33286,31206,27045,31205,39752,46187,39687,41669,47975,41702,41638,43749,35332,22819,20708,16516,16516,16517,14501,14533,12452,14565,10404,8356,8356,12452,18627,12418,18627,4227,18627,16514,12387,16547,30884,6242,2146,2146,2146,2114,2114,2146,2113,2113,12484,6307,2146,2146,2146,2146,255},
{17268,17268,17268,17268,17268,17300,17300,17300,17300,17300,17332,17332,17333,17301,19349,17333,17333,19381,19381,19381,19381,19414,19414,19414,19414,19414,19414,19446,19446,19446,19446,19446,19446,19479,21527,21559,21559,21559,21559,21527,21559,21559,19479,19479,19478,12778,12679,14792,14857,12712,4292,4259,2179,2178,2178,4291,4291,6372,12679,16873,21163,21164,10598,23277,23245,21132,25325,23179,21099,25325,25325,23244,21099,14759,14726,18822,23081,25097,27112,22853,18593,22721,29026,46089,41799,56456,62663,50054,43751,45860,41538,26946,22756,18564,18565,16549,16549,16581,14500,16581,10404,10372,10372,14500,16547,10371,18595,8323,22690,16483,14435,8290,34916,12355,2113,4194,4194,2146,2113,2113,2113,2113,16580,6274,2146,2113,2113,2146,255},
{17268,17268,17268,17268,17268,17300,17300,17300,17300,17300,17300,17332,17332,17332,17333,17333,17333,19381,19381,19381,19381,19413,19413,19413,19413,19413,19445,19446,19446,19446,19446,19446,19446,19479,21527,21527,21527,21527,21559,21559,21559,21559,19479,19479,19478,12811,10566,14857,16905,10664,6405,4259,4259,2179,8518,19051,19018,12744,10631,19050,25357,21196,10630,23244,27439,27471,27471,23244,21131,27438,27406,25325,23212,16905,14727,18855,23081,23016,23016,22853,20673,24769,39721,48366,41769,41444,39460,41669,35397,50052,52326,37575,26851,22596,20644,20645,18596,18597,16548,16580,12420,10371,10371,18595,18563,10370,22658,16515,26722,18531,18531,8258,32867,28804,4193,6242,4193,4193,4161,4161,4161,4161,20676,4226,2146,2114,2113,2113,255},
{17267,17268,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,19348,17301,17333,19381,17333,19381,19381,19381,19381,19413,19381,19413,19413,19446,19446,19446,19446,19446,19446,19446,19479,21527,21527,21527,21527,21559,21559,21527,21527,19479,19479,19479,10730,10566,14857,16937,14825,10598,4292,2179,2178,12679,21164,19018,14857,14824,21131,23244,21131,12679,25357,25259,25259,27340,19018,18953,21098,21099,23113,21033,14759,14694,22918,39657,37253,39268,28963,24770,30945,41738,37285,35172,43331,37250,35203,35203,41634,50279,33479,30947,30788,26724,26756,24676,24740,20644,20676,22659,14499,12451,24738,20610,14466,28834,30882,22658,26754,24706,10338,24706,41155,14434,8289,8289,8289,6241,6241,6241,6241,26788,4194,2113,2145,2113,2113,255},
{17267,17267,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17301,19349,17333,17333,19381,19381,19381,19381,19413,19381,19381,19382,19414,19414,19446,19445,19446,19446,19446,19446,21527,21527,21527,19479,21559,21527,21527,21527,19479,19479,19478,14957,10631,12744,12712,8453,4292,4259,4259,2178,10598,23245,23244,16937,14824,12679,12744,14824,10566,23113,50481,54543,58573,27240,14759,14759,18985,18758,12679,12646,10468,30979,60720,59941,57602,35107,28898,39040,52043,54577,48270,48073,50152,41765,35364,43747,47875,29058,43267,43172,34980,34979,35011,35011,28835,24803,30915,22691,14562,28866,22658,18561,34945,41089,22625,32865,34913,16513,20609,47362,28834,14433,12417,12417,12385,10337,10337,8289,26819,4193,4193,4193,4193,2145,255},
{17267,17267,17267,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17332,17332,17332,19381,19381,17333,17333,19381,19381,19381,19413,19413,19445,19445,19445,19445,19446,19446,19446,21527,19479,19478,21527,21527,21527,21527,19479,19479,19478,19446,19413,19380,17267,12876,6405,4259,2179,2146,8517,19018,19051,16905,14792,10566,10598,12711,10566,25161,42096,44143,44176,21033,14759,14759,14792,16775,14759,12646,12548,26948,47557,45703,43428,35204,33026,47169,59618,59974,51782,56004,58116,39363,28995,35299,37412,33219,45347,57669,47364,43267,49508,47428,35042,26850,26818,30914,14562,32929,22689,22689,41057,45153,20609,34913,41057,20609,18561,43202,45250,18529,14465,14433,18561,18561,10369,10369,28899,4225,4225,4193,4193,2145,255},
{17267,17267,17267,17268,17268,17300,17268,17300,17300,17300,17300,17300,17300,17300,17300,17332,17332,17332,17332,19380,17332,17333,17332,19381,19381,19381,19413,19413,19445,19445,19413,19445,19446,19446,19446,19479,19479,21527,21527,21527,21527,21527,21527,19479,19478,19478,19478,19478,19478,19478,17300,8585,6372,2179,8485,23212,21131,14825,14792,16905,19018,18986,12646,31435,27209,29321,31402,29321,27208,31401,31401,31402,31369,29255,27110,37478,45799,47781,49828,49763,43330,57376,62443,60070,49442,52200,41606,33124,35267,41507,35559,27075,49605,59717,53605,51524,55684,53604,41219,26818,24738,28866,14594,34977,22690,22689,45121,41057,18561,36929,43105,22657,16513,30849,57408,24705,14465,12385,16481,16513,10369,12417,26818,4225,4225,4193,4225,4193,255},
{17267,17267,17267,17267,17268,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17332,17332,17332,17332,17332,17332,17332,17332,17333,17333,17333,19413,19413,19413,19413,19413,19413,19445,19445,19446,19446,19479,21527,21527,21527,21527,21527,21527,21527,21527,19478,19478,19478,19478,19478,19446,17332,17300,12876,6405,19051,19117,17004,14857,16938,23311,23377,14857,29320,25062,25029,27077,27076,24963,22883,22851,22851,22850,18690,22851,27011,26945,24833,26849,30977,37154,49216,59553,55618,49894,43877,43554,29027,20674,29058,29123,27075,47621,49412,43235,45348,45348,45348,35043,22755,18659,14562,12514,37025,22690,20642,47169,30849,16514,34913,34913,14465,14465,24705,59521,32929,12417,10369,10369,10369,6273,12417,20675,4225,4193,4193,4193,4193,255},
{17267,17267,17267,17267,17267,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17332,17300,17300,17332,17332,19380,17332,17332,17332,19413,19413,19413,19413,19413,19413,19413,19445,19446,19446,19479,21527,21527,21527,21527,21527,21527,21527,21527,19479,19478,19478,19478,19478,19478,19478,19478,19478,17169,21493,23639,23639,23606,23638,25752,25784,25719,25621,19084,12548,16708,16740,18755,20836,18756,18756,18788,18789,22949,25030,24997,29155,22850,35138,37348,45604,51522,47521,43522,39363,45732,37540,33252,33122,33251,24996,35107,34883,28771,30916,32964,30916,26819,14563,12515,12514,10435,35010,18594,16546,41090,18594,12450,24706,30914,10369,8321,18593,49378,41154,10369,8321,8289,8289,4193,14498,14498,2145,2145,2145,2113,2146,255},
{17267,17267,17267,17267,17267,17267,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,19348,17332,17332,17332,17332,19413,19413,19413,19381,19413,19413,19413,19445,19446,21526,21526,21526,21527,21527,21527,21527,21527,21527,19479,19479,19478,19478,19478,19478,19478,19478,19446,19446,19478,21527,21558,21558,21559,23639,23639,23671,23671,23704,25752,25620,29453,45870,27112,21000,18952,18919,18887,18918,20934,20934,22982,25061,20836,26980,31205,35267,35202,47715,39395,43493,35138,26979,24866,27010,29124,22819,28964,24643,20580,20645,20645,18597,16580,8387,8387,8387,8387,28964,12451,12418,32995,8354,8322,16515,20675,4193,6241,14499,26787,49283,14434,4226,4193,4161,2113,12451,10403,2146,2114,2145,2113,2146,255},
{17267,17267,17267,17267,17267,17267,17267,17268,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,19380,17332,17332,17332,19380,19380,19413,19413,19381,19381,19381,19413,19413,19446,21494,21526,19478,21527,21526,21526,21527,21527,21527,21527,19479,19478,19478,19478,19478,19478,19478,19445,19446,19446,19446,19478,19478,21526,21558,21558,23639,23671,23671,23671,21427,16939,29389,18920,14758,14726,14726,16806,18920,16839,18887,20935,22949,22852,24899,18691,24802,28994,27077,25031,29128,20675,12419,8257,8257,4129,2113,16579,20644,14501,12485,10469,10469,10469,6339,6339,6339,6339,20838,8355,10403,28998,6274,6274,10403,14532,2146,4194,14532,8290,41157,18563,2146,2146,2145,2145,12484,4227,2145,2145,2145,2145,65,255},
{17235,17267,17267,17267,17267,17267,17267,17268,17268,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17332,17300,17300,17332,17300,17300,19380,19380,19381,19381,19381,19381,19381,19413,19413,19413,19446,19446,19446,21526,21526,21526,21526,21527,21526,21527,19478,19478,19478,19478,19478,19446,19445,19445,19445,19445,19445,19445,19445,19478,19478,21558,21558,21558,21558,21558,14956,12777,12777,10631,12712,12712,10599,8420,10532,10532,10499,10499,16740,20803,29124,14530,18657,24866,20770,31465,25127,18723,8290,4129,8290,10371,8323,16613,16645,8421,8420,8420,8421,8421,4291,4291,6339,4291,16743,6307,10468,20838,4226,4227,6339,12484,2146,4259,14565,2178,27014,24870,2178,2146,2178,2146,12549,2146,65,65,65,97,2114,255},
{15187,17267,17267,17267,17267,17267,17267,17267,17267,17268,17267,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,19380,19380,19380,19381,19380,19381,19381,19381,19381,19413,19445,19445,19446,21526,21526,21526,21527,21526,21526,21526,19478,21526,21526,19478,19478,19446,19445,19445,19445,19445,19445,19445,19445,19445,19445,19478,21526,21526,21558,21558,21558,23606,23606,23540,21493,23541,21460,14957,8486,12580,12613,14661,25127,20835,31172,29092,37381,37478,27014,27046,35463,39591,35398,22949,29031,35112,22758,22886,14661,8453,8452,8420,8452,8453,4291,4291,4292,4292,16743,6339,12613,14661,4226,4259,6372,10469,2146,6340,8420,2146,20934,27143,4227,2146,2146,65,12549,2146,65,65,65,2146,4226,255},
{15187,17235,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17332,17332,19380,19380,19380,17332,19381,19413,19413,19445,19445,19446,19446,19478,21526,19478,21526,21526,19478,19478,21526,19478,21526,19478,19478,19445,19445,19445,19445,19445,19445,19445,19445,19445,19477,19478,21526,21526,21558,23606,21460,17135,19183,17102,19118,17037,16938,16840,20967,23015,27241,33384,24997,31237,33319,35399,35369,39303,39108,22787,24867,20739,18627,14500,18600,12421,22853,14694,10534,8453,10533,8485,8453,4292,4291,4292,6372,16775,6340,14694,10500,4226,4259,6340,12581,2146,8485,4259,2146,18853,29288,10500,2178,2146,98,10533,2114,2146,65,2145,2146,6339,255},
{17267,17235,17267,17235,17267,17267,17267,17267,17267,17267,17267,17267,17267,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,19348,17332,19348,19380,17332,19380,19381,19413,19413,19445,19445,19446,19446,21526,21526,21494,21526,19478,21526,21526,21526,19478,19478,19478,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19477,21526,21526,23606,23606,21526,23574,23573,21459,23342,23277,16904,21065,27371,16742,18855,18822,23047,20933,22981,22981,25063,29030,32898,10337,22754,30882,18658,18628,22728,14534,31271,18854,10566,8453,12647,10534,8453,4292,4292,4292,6404,16742,8452,14726,10500,4259,4259,6340,12614,2179,10566,2178,2146,14693,27239,20934,2178,2146,97,8453,2146,2145,65,2145,65,8452,255},
{15187,15187,15187,17267,17235,17235,17267,17267,17267,17267,17267,17267,17267,17267,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,19348,17332,17332,17332,19380,19380,17332,19413,19413,19445,19445,19446,19446,21526,21526,21494,21526,19478,21526,21526,21526,19478,19478,19477,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,21526,21526,21526,21526,21526,23574,23574,29846,38134,23540,19314,21362,25522,21329,21296,14891,14725,18885,20932,16706,20836,18756,14595,12449,39267,45283,14368,22918,33320,25063,35430,20935,10566,8453,12679,10566,8485,6340,4292,4292,8484,16774,12613,12613,10500,6307,4259,4292,12613,4324,8485,2146,98,12581,16805,27240,4259,2145,65,2146,65,65,2145,65,65,10565,255},
{15187,15187,15187,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17268,17300,17300,17268,17300,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,19380,19380,19380,19413,19413,19445,19445,19477,19478,21526,19478,19478,21526,21526,21526,21526,21526,19478,19478,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,21493,21493,21526,21526,21526,21526,23574,23605,36119,50779,25653,21461,21460,21460,23508,21361,8519,10532,18885,33545,22980,33253,35204,22819,14498,31011,22690,20610,14628,14727,10565,27108,18886,10598,8453,10566,10566,8485,6339,4292,6340,10565,14694,18886,8452,8452,8388,4259,4291,12581,8485,4291,2146,98,10565,8452,25192,6372,65,65,65,65,65,65,65,65,10631,255},
{15187,15187,15187,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17268,17268,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,17300,19380,19380,19380,19413,19445,19445,19445,19478,19478,19478,21526,21526,21526,21526,21526,19478,19478,19477,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,21526,21526,21525,21526,21526,21525,25653,27733,23541,21460,21460,21460,21460,21329,10664,12613,27076,20900,31529,29253,27140,16675,4193,14562,18723,20738,12548,12711,8518,18822,16807,10566,8485,8453,8485,8453,4291,4292,4291,10565,12581,18919,4291,8452,4259,4259,4259,8485,10598,2178,2146,65,8453,4259,16871,10598,2146,65,65,65,65,65,65,2146,12679,255},
{15187,15187,15187,15187,17235,17235,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17268,17267,17267,17268,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17300,19380,19380,19413,19445,19445,19445,19445,19445,19477,21526,21526,21526,21526,21526,21526,19446,19445,19445,19445,19445,19445,19445,19413,19445,19445,19445,19445,19445,19445,21494,21526,21494,21526,21526,21526,21493,21493,21460,21460,21460,21460,21460,21427,21394,19248,10598,18853,12547,18852,18852,23012,16707,12514,22915,35300,35299,22820,22888,20806,25031,16774,8485,8453,8453,8453,8420,4291,4291,4259,8485,10533,16839,4227,6404,4259,2179,4259,10598,10598,2146,2145,65,8453,4259,8485,16905,4291,65,65,65,65,65,65,2146,12679,255},
{15187,15187,15187,15187,15187,15187,15187,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17268,17267,17268,17268,17300,17300,17300,17300,17300,17300,17300,17300,17332,17332,19413,19413,19445,19445,19445,19445,19477,19445,21526,21526,21526,21526,21526,19446,19446,19445,19445,19445,19413,19445,19445,19445,19445,19445,19445,21493,21493,21526,21493,21493,21526,21525,21525,21525,21493,19412,19412,19412,21460,21428,21395,19249,21329,10566,8453,8420,12580,14725,20966,23013,14627,18787,29156,22947,24869,33032,28935,24934,16710,8453,8452,8453,6373,6404,4291,4259,4259,8485,8485,12679,2178,6372,4259,2178,2178,12711,6404,2146,2145,65,6404,6340,4259,16938,10598,66,65,65,65,65,65,2178,10598,255},
{15187,15187,15187,15187,15187,17235,15187,15187,17267,17267,17235,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17267,17268,17268,17300,17300,17300,17300,17300,17300,17300,19380,19380,19413,19413,19445,19445,19445,19445,19445,19445,19445,19477,19445,19478,19478,19445,19445,19445,19445,19445,19413,19413,19413,19445,19445,19445,19445,21493,21493,21493,21493,21493,21525,21525,21525,21525,21492,21460,19379,19412,21460,21428,21427,19248,19248,10599,12647,8388,8420,16871,27336,18885,8354,12482,16642,16578,12419,18567,14470,12517,14629,8453,8421,6372,6341,6372,4259,4259,4259,8485,8485,8485,2178,6339,4259,2178,2178,12679,4259,2146,2145,65,6372,6340,2146,14792,14825,2146,66,66,65,65,65,4259,8518,255},
{15187,15155,15187,15187,15187,15187,15187,15187,17235,15187,17235,17235,17235,17267,17267,17267,17235,17267,17235,17235,17267,17267,17267,17267,17268,17268,17300,17300,17300,17300,17300,17300,17300,19380,19380,19381,19413,19413,19413,19445,19445,19445,19445,19445,19445,19445,19478,19445,19445,19445,19445,19445,19413,19413,19413,19413,19413,19413,19445,19445,21493,21493,21493,21493,21525,21525,21525,21525,21525,21460,21460,19347,19380,19412,21428,21428,19281,21362,12745,8485,8420,14691,25124,39717,18755,14562,25028,31171,31107,20676,22696,18566,10501,14662,8453,6340,6372,6340,6340,4259,4259,4259,8485,10599,6373,2178,4291,4259,2178,2178,12679,2146,2146,65,65,6340,6340,65,8485,16937,6372,65,65,65,65,65,6372,6405,255},
{15155,15187,15155,15155,15187,15187,15187,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17267,17267,17267,17267,17267,17268,17268,17300,17300,17300,17300,17300,19348,19380,17332,19413,19413,19413,19413,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19413,19413,19413,19413,19413,19413,19445,19445,21493,21493,21525,21525,21525,21525,21525,21525,21525,21460,19412,19380,19380,19380,21428,21427,21395,21427,17037,8518,8453,25123,27170,37638,22819,20835,35426,24962,26978,26981,24903,20839,14694,14662,8453,6340,6340,6340,4292,4259,4259,4259,6405,12711,6340,2178,4259,4259,2178,4259,12712,2146,2145,65,65,4291,6372,2113,4259,16905,12679,65,65,65,65,65,6405,6340,255},
{15155,15155,15155,15155,15187,15187,15187,15187,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17267,17267,17267,17267,17268,17268,17268,17300,17300,17300,17300,17300,19380,19380,19413,19413,19413,19413,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19445,19413,19413,19413,19413,19445,19445,19445,19445,21493,21493,21493,21493,21493,21493,21525,21525,21525,21460,19412,19380,19347,21428,21428,21428,19347,21427,19281,14891,16838,25124,23011,35462,14497,16739,33314,20898,22785,27077,31368,27240,14694,14629,8453,6340,6340,6372,6340,4259,4259,4259,8486,12679,6340,2178,4259,4291,2178,6404,10566,2146,2145,65,65,4259,4292,2145,2146,12712,16905,4227,65,65,65,65,8486,4259,255},
{15155,15155,15155,15155,15155,15155,15187,15187,15187,15187,15187,15187,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17235,17267,17267,17268,17267,17268,17268,17300,17300,17300,17332,19380,19413,19413,19413,19413,19413,19445,19445,19445,19445,19445,19445,19445,19445,19445,19413,19413,19413,19413,19413,19445,19445,19445,19445,21493,21493,21493,21493,21493,21525,21525,21525,21493,21460,19412,19380,19347,19380,19380,19379,19347,19347,19347,21395,14857,6371,8420,29158,12385,10433,26914,12481,14465,14531,18758,14662,6339,12581,6373,6340,6340,6340,4292,2179,4259,4227,10599,8518,4292,2146,4259,4291,2146,8486,6405,2178,2145,65,65,2178,4292,65,97,8485,16937,8518,65,65,66,2114,10598,2178,255},
{15154,15155,15155,15155,15155,15155,15187,15155,15187,15187,15155,15187,15187,15187,15187,15187,15187,15187,15187,15187,17235,17235,17235,17235,17235,17235,17267,17267,17267,17267,17267,17268,17268,17300,17300,17332,17332,19380,19380,19413,19413,19413,19413,19413,19413,19445,19445,19445,19445,19445,19413,19413,19413,19413,19413,19413,19445,19445,21461,21493,21493,21493,21493,21493,21493,21493,21493,21493,21493,21492,19412,19380,19347,19347,19380,19347,19347,19347,19347,19315,10665,6339,8484,20934,10402,6241,20868,16577,16609,12451,22822,16678,6307,12549,6341,4292,6340,4292,4259,2178,4258,2178,12679,6372,4292,2146,2210,4291,2178,8486,6340,2178,65,65,65,2146,4291,65,65,4259,14857,14792,2146,65,65,2113,10598,2178,255},
{15154,15154,15155,15155,15155,15155,15155,15155,15155,15155,15155,15187,15187,15187,15187,15187,15187,15187,15187,15187,15187,15187,15187,17235,17235,17235,17235,17267,17267,17267,17267,17267,17268,17300,17300,17300,17332,19380,19380,19413,19413,19413,19413,19413,19413,19413,19413,19413,21461,21493,19413,19413,19413,19413,19413,19413,19413,19413,19413,21493,21493,21493,21493,21493,21493,21493,21493,21493,21493,21460,19412,19380,19380,19347,19379,19347,19347,19347,19347,19314,10632,6339,12613,29222,10369,10402,25093,14529,14561,16579,22822,16678,6372,12582,6340,4292,4292,6340,4259,2178,2178,2179,10566,4259,4292,2146,2178,4259,4259,6372,4259,2178,2145,65,65,2146,4291,65,65,2146,12711,14857,4291,65,65,2178,10598,98,255},
{15154,15154,15154,15154,15155,15155,15155,15155,15155,15155,15155,15155,15155,15155,15155,15155,15155,15187,15187,15187,15187,17202,15187,15187,15187,17235,17235,17235,17267,17267,17267,17267,17267,17268,17300,17300,17300,19380,19380,19380,19381,19381,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19381,19413,19413,19413,19413,19413,21493,21493,21493,21493,21493,21461,21461,21493,21493,21493,19412,19412,19380,19380,19347,19379,19347,19347,19347,19347,19315,12778,6372,14725,25061,10402,14594,31075,24769,26915,31079,26886,26918,12517,14630,6340,4292,4292,6340,4292,2179,2178,4227,6372,2179,4292,2146,2178,4259,6405,4259,4259,2178,65,65,65,2146,4291,65,65,65,8485,14857,10598,65,65,4259,8518,65,255},
{15122,15154,15154,15154,15154,15154,15154,15154,15154,15155,15155,15155,15154,15154,15154,15154,15187,15187,15155,15155,17202,17202,15155,15187,15187,15187,17235,17235,17235,17235,17267,17267,17267,17267,17300,17300,17300,19380,19380,19380,19380,19380,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,21493,21493,21493,21493,21493,21493,21493,21525,21493,21460,19412,19380,19380,19346,19347,19347,19347,19347,19347,19315,19281,10566,21031,22949,8354,12481,24963,18691,18986,29064,35047,33032,16581,14597,6340,4292,4292,4292,4259,2179,2178,4259,4292,2178,4292,2178,2178,4259,8485,2146,4259,2179,65,65,65,2114,4292,65,65,66,10631,14857,14824,2178,2114,2146,4291,65,255},
{15122,15154,15154,15154,15154,15154,15154,15154,15122,15122,15122,15122,15155,15154,15154,15154,15155,15154,17202,17202,17202,15154,17202,15154,15155,15187,15187,17235,17235,17235,17235,17235,17267,17267,17300,17300,19348,19380,19380,19380,19380,19380,19380,19381,19413,19413,19413,19413,19413,19413,19413,19413,19413,19413,19380,19380,19413,19413,19413,19413,21493,21461,21493,21493,21492,21492,21493,21493,21493,21460,19412,19380,19380,19347,19314,19347,19347,19347,19347,19248,17004,8453,21030,22949,4161,12514,14626,10467,12713,18758,12321,18500,10307,14532,8387,8452,4259,4259,4259,2178,2178,2179,4259,4259,4292,2146,2146,4292,6405,2114,2179,2178,65,65,65,65,6340,65,2146,4227,14824,12743,14857,6404,65,65,65,65,255},
{15122,15154,15154,15122,15154,15122,15122,15154,15122,15122,15122,15154,15122,15122,15154,15154,15154,15154,17202,17202,15154,15154,17202,15154,15155,15187,15187,15187,17235,17235,17235,17235,17267,17267,17268,17300,17300,17300,17300,17300,17300,19380,19380,19380,19381,19381,19380,19413,19413,19413,19413,19413,19413,19413,19380,19380,19413,19413,19413,19413,21461,19412,21460,21460,21460,21492,21493,21493,21493,21492,19412,19380,19380,19347,19314,19379,19314,19281,17135,8485,6339,4226,14758,20773,4129,16578,18690,12516,10534,10402,4192,10305,4128,6209,12417,10435,4194,2146,2178,2178,2178,4259,4259,2179,4292,2146,2146,6404,4292,2114,2178,2179,65,65,65,65,6340,65,2113,8518,10631,4292,16905,12711,2146,65,65,65,255},
{15122,15122,15154,15122,15122,15154,15154,15122,15122,15122,15122,15122,15122,15122,15122,15154,15154,15154,15154,17202,15154,15154,15154,15154,15154,15154,15187,15187,15187,15187,17235,17235,17235,17267,17267,17300,17300,17300,17300,17300,17300,17300,19380,19380,19380,19381,19381,19413,19413,19413,19381,19380,19380,19380,19380,19380,19413,19413,19413,19412,19413,19412,19412,19412,21460,21492,21493,21493,21493,21492,19412,19380,19380,19379,17201,25555,14890,8485,8452,8386,6305,6274,18951,18855,10434,20867,29154,14694,12579,16672,33408,25024,6208,8256,6208,2080,2146,2146,2178,2178,2178,4259,4259,2146,4292,2146,2146,8518,2178,2145,2146,2178,65,65,65,65,4291,65,2146,12744,4292,2146,14792,16905,4259,2145,2145,2145,255},
{15122,15122,15154,15122,15122,15122,15122,15122,15122,15122,15122,15122,15122,15154,15122,15154,15154,15154,15154,15154,15154,15154,15154,15154,15154,15154,15154,15187,15187,15187,15187,17235,17235,17235,17267,17267,17267,17300,17300,17299,17300,17300,19380,19380,19380,19381,19381,19413,19413,19381,19380,19380,19348,19380,19380,19380,19381,19380,19412,19412,19413,19412,19412,19412,21460,21492,21493,21493,21493,21460,19412,19380,19380,19281,8584,38035,42260,8387,8418,8417,8385,8353,23112,16872,16902,10499,10402,10595,25347,25121,20832,22913,28897,14432,10337,6241,4226,4129,4194,2178,2178,4259,4259,2178,6340,2146,2146,8485,2146,2145,2146,2146,65,65,65,65,4292,66,6404,12744,2146,65,10598,16938,8485,65,2145,2146,255},
{15122,15154,15122,15122,15122,15122,15121,15121,15122,15122,15122,15122,15122,15122,15122,15122,15122,15154,15154,15122,15154,15154,15154,15154,15154,15154,15154,15154,15187,15187,15187,15187,17235,17235,17235,17267,17267,17267,17300,17300,17299,17300,17300,19348,19380,19380,19380,19380,19380,19381,19380,19380,19348,19380,19380,19380,19380,19380,19380,19412,19380,19380,19412,21460,21460,21492,21493,21493,21493,21460,21428,19380,19380,19281,14858,27470,44373,6338,8385,10464,8384,10433,23210,16938,19016,6339,10435,12740,25379,14561,2048,16481,39299,12386,10370,2080,6241,12289,10274,4226,2178,6307,4259,2146,8356,2146,4226,8420,2146,2145,2146,2178,65,65,65,65,4292,2146,12679,10566,65,65,4291,16937,12711,2146,2178,2146,255},
{15121,15121,15121,15121,15121,15122,15121,15121,15121,15122,15122,15122,15122,15122,15122,15122,15122,15154,15154,15154,15154,15154,15154,15154,15154,15154,15154,15154,15154,15187,15187,15187,15187,17235,17235,17235,17267,17267,17267,17267,17300,17300,19348,19348,19348,19348,19380,19380,19380,19380,19348,19348,19348,19380,19380,19347,19348,19380,19380,19412,19380,19412,19412,19412,21460,21492,21493,21493,21493,21460,19380,19347,17103,31795,23277,16872,31696,2178,6305,8384,8353,8353,16937,14792,10565,2146,4226,6306,14754,10369,0,16513,35203,14596,14596,65,2146,14370,12322,4194,2178,8356,6307,4194,8355,98,8388,8420,66,65,65,2178,65,65,65,65,4291,4259,14760,6405,65,65,2146,14792,16905,6339,2146,2146,255},
{15121,15121,15121,15121,15121,15122,15121,15121,15122,15122,15122,15121,15121,15121,15121,15121,15122,15122,15154,15154,15122,15122,15122,15154,15154,15154,15154,15154,15154,17202,17202,15186,15187,17235,15187,17235,17267,17267,17267,17267,17267,17300,17300,17300,19348,19348,19348,19348,19348,17300,19348,17300,19348,19348,17299,17267,17267,19347,19380,19380,19380,19380,19412,19412,21460,21460,21492,21493,21493,21460,19380,19314,12745,42293,38067,14791,10565,33,2113,6241,10369,6273,8485,10566,6372,4259,2081,4096,6176,8257,4129,2081,4128,6242,8354,2179,4227,6242,4227,2178,2178,6340,4259,4226,8355,2146,10533,4259,66,65,2113,2178,65,65,65,65,6340,8485,10566,4292,65,2145,65,8518,16937,10533,2146,2145,255},
{15121,15121,15122,15121,15121,15122,15121,15121,15121,15122,15122,15121,15121,15121,15121,15122,15121,15122,15121,15121,15121,15122,15122,15122,15154,15154,15154,15154,15154,17202,15154,15154,15154,15187,15186,17235,17235,17267,17267,17267,17267,17300,17300,17300,17300,19348,19348,19348,17300,17300,17300,17300,17300,17300,17235,17234,17267,17299,19347,19380,19380,19380,19380,19412,21460,21492,21492,21492,21492,21460,19380,19347,17102,17036,8453,40147,38034,4161,8353,12512,12480,12481,23276,16905,10598,12612,16514,10435,14727,16774,18821,18886,14660,8420,6339,4259,4259,4259,4227,2178,2146,6372,4259,2178,4259,2179,8453,2178,65,65,65,4259,65,65,65,65,6405,10598,6372,4259,65,2145,65,4291,16905,14759,4226,2146,255},
{15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15122,15154,15154,15154,15154,15154,15154,15154,15154,15154,15186,15186,15187,17235,17235,17235,17267,17267,17300,17267,17267,17300,17300,17300,17300,17299,17300,19348,19348,17300,17267,17234,17234,17234,17267,17299,19380,19380,19380,19380,19412,21460,21460,21492,21460,21460,21460,17135,10663,6372,8452,6307,27405,48534,8353,10432,14528,14528,14660,25357,14759,10565,8353,20738,18888,10729,10500,20934,25126,16773,10533,8387,4291,4227,4259,4259,2178,2178,6405,4259,2146,4259,6340,6340,2146,65,65,65,4259,65,65,65,65,6405,8485,4292,2179,65,65,2145,2146,12744,18920,8419,2146,255},
{15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15122,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15122,15122,15154,15154,15154,15154,15154,15154,15154,15154,15154,17235,17235,17235,17235,17235,17267,17267,17267,17267,17267,17267,17267,17299,17299,17299,17299,17267,17267,17267,17234,17234,17234,17234,17299,19379,19380,19380,19380,19412,21428,21460,19380,19379,21460,21428,12810,10565,8452,10565,8418,18886,31563,10433,14560,16608,14560,14693,23277,12613,2081,6273,12513,8387,6405,6340,8485,8485,4291,4291,8387,4291,4259,4259,4259,2178,2146,6372,4259,2146,4259,8453,2179,2146,65,65,66,2178,65,65,65,66,10566,4259,6372,2146,65,65,65,65,8517,16937,12646,2146,255},
{15089,15089,15121,15121,15121,15121,15121,15121,15089,15089,15089,15121,15089,15089,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15154,15122,15122,15122,15154,15154,15154,15154,15154,17202,15154,15187,17235,17235,17235,17267,17267,17267,17267,17267,17267,17267,17299,17299,17299,17267,17267,17267,17267,17235,17234,17234,17234,17266,19347,19347,19380,19380,19380,19380,19379,19379,21428,21460,21460,17102,8451,10561,10563,10529,10432,12512,14624,20801,18720,14592,14725,23245,14727,2113,12481,22850,16743,8420,8453,8517,8550,4291,4259,8387,4259,4259,4259,4227,2178,2178,6340,4227,2146,6405,8485,2146,2179,65,65,65,2146,65,65,65,2178,10631,2179,6404,2146,65,65,2145,2145,4259,16904,16839,4226,255},
{15089,15089,15089,15089,15089,15121,15121,15089,15089,15089,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15121,15122,15122,15154,15154,15154,15154,15154,15154,15154,17202,15186,17234,17235,17235,17235,17267,17267,17267,17234,17266,17266,17267,17300,17299,17267,17267,17267,17234,17234,17202,17202,17234,17266,19347,19347,19380,19380,19380,19347,19347,19379,21460,21428,19346,10631,10595,14721,10529,10496,10464,14625,20801,20833,14560,12512,14725,21164,12646,8386,16706,31107,16743,6372,12582,14630,16710,20935,14694,10436,4259,4259,4259,4259,2179,2178,4292,2179,2146,10598,6372,2146,2179,65,65,65,2146,65,65,65,4292,8485,2178,6404,66,65,2145,65,2145,2146,12711,18919,8452,255},
{15089,15089,15089,15089,15089,15089,15089,15089,15089,15121,15089,15089,15089,15089,15089,15121,15121,15121,15121,15089,15089,15089,15121,15121,15121,15121,15121,15122,15121,15122,15122,15122,15154,15154,15154,15154,15186,17234,17235,17235,17235,17235,17267,17267,17267,17267,17267,17300,19348,17299,17267,17234,17234,17234,17202,15154,15154,17234,17235,19347,19347,19380,19380,19380,19347,19347,19379,19379,19347,14956,10562,16865,16833,12609,12577,10464,20801,20769,16640,14560,12480,14790,21099,8387,8419,24931,37219,20774,6371,16678,35145,37225,33127,16709,12516,4259,4227,4259,4227,2179,2178,6340,4227,2146,12679,2178,2146,2179,65,65,65,2146,65,65,2146,6340,4259,4259,6372,65,65,2145,65,2146,2113,8517,18952,14727,255},
{15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15121,15121,15089,15089,15089,15089,15121,15121,15121,15121,15121,15121,15121,15122,15122,15122,15154,15154,15154,15154,17202,17234,17235,17235,17235,17235,17267,17267,17267,17267,17267,17300,17300,17299,17267,17234,17234,17234,17202,15154,15154,17234,17267,19347,19347,19380,19380,19380,19347,19347,19379,21428,19249,4291,12642,16833,14753,14721,12608,14689,24962,24962,22881,16673,18753,18952,14792,4225,6242,24770,28833,16645,10500,16613,26856,28904,26950,24933,12516,4259,2179,4259,4227,2179,2178,4292,4227,2178,8518,2146,2146,2178,65,65,65,2146,65,65,4259,4259,2178,4259,6373,33,65,2113,65,2145,2146,6372,16872,16872,255},
{15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15121,15121,15122,15122,15122,15122,15154,15154,15154,17202,17202,17234,15187,17234,17235,17267,17267,17267,17267,17267,17267,17267,17234,17234,17234,17234,17202,15154,17202,17234,17267,19347,19347,19347,19346,19347,19314,19314,21395,21427,21329,6405,8453,10531,14722,16802,20995,18818,22947,22948,24995,22883,20803,16709,12614,4225,2080,6208,12385,10338,8322,8258,18534,18567,22725,24835,10436,4227,4227,4259,4227,2179,2178,4292,4227,4291,8518,65,2145,2178,65,65,65,2146,65,65,6372,2146,2146,6340,6340,65,65,65,65,2145,2146,6372,16871,16872,255},
{13041,13041,15089,15089,13041,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15121,15089,15089,15089,15089,15121,15121,15121,15121,15121,15121,15121,15121,15122,15122,15154,15154,15154,17202,15186,15186,15186,17235,17234,17234,17235,17267,17267,17267,17267,17235,17234,17202,17202,17202,17234,17234,17234,17267,19315,19315,19347,17233,12876,14957,14924,14924,14989,17037,17036,12712,16905,16872,18984,23079,27143,23015,25062,25030,27078,29126,29126,22919,20904,8387,8385,22884,31045,30883,26819,12452,18566,18566,18597,16611,8387,4259,4227,4259,4227,2179,2178,4259,2178,6372,8453,2113,2146,2178,65,65,65,2178,65,2179,4259,65,2178,6373,4292,65,65,65,65,2145,2146,4291,16871,16872,255},
{15089,13041,13041,13041,13041,13041,13041,15089,15089,13041,13041,13009,13009,13009,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15121,15121,15121,15121,15154,15154,15154,15186,15186,15154,17202,17202,17234,17234,17234,17267,17267,17267,17234,17234,17202,17202,15154,17202,17234,17235,17267,17267,19315,19315,19315,19347,19380,21428,21427,19346,21460,21427,25521,14792,16773,12645,16805,33510,33510,33510,43877,41862,39815,37736,42026,21131,18954,16837,25092,33382,31334,20672,28899,14532,18534,16486,20645,20739,10468,4259,4259,4259,2178,2178,2178,4259,4259,10598,6372,65,2146,2178,65,65,65,2146,65,6340,2146,65,2146,8453,4259,65,65,65,65,2145,2145,4259,14758,16872,255},
{13041,13041,13041,13041,13041,13041,13041,13041,13041,13041,13041,13009,13009,13041,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15121,15121,15122,15154,15154,15154,15154,15154,17202,17202,17234,17234,17234,17266,17266,17267,17234,17202,17202,15153,15153,15153,17234,17235,17234,17234,17266,17267,19315,19347,17201,12810,10697,10632,10632,10597,18885,16773,16773,12579,14660,25092,27171,27171,29188,31365,33542,33607,33674,19051,18953,20739,33380,33282,31299,16674,12746,24805,22628,16483,14467,10468,12581,4259,4259,4259,2178,2178,2178,4291,4292,8518,6372,65,2145,2178,65,65,65,2146,2146,6340,65,65,2146,6404,2146,2114,65,65,2146,6405,2146,4258,14725,14726,255},
{13041,13041,13041,13041,13041,13041,13041,13041,13041,13041,13041,13008,13040,13041,13041,13041,15089,15089,15089,15089,13041,13041,15089,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15121,15122,15154,15154,15154,15154,17202,17202,17202,17234,17234,17234,17234,17266,17234,17234,17202,15154,15153,15121,15153,17234,17234,17234,17234,17234,17234,17267,19347,15055,6373,2146,2146,2178,6340,8420,6307,8387,8419,8419,6307,8354,12515,16675,10434,6274,10434,10467,17005,16873,18722,31363,33539,31427,10696,10895,20774,16449,20609,20802,12580,14695,4259,4227,4227,2179,2179,2179,4292,8485,6372,6372,2114,2145,2178,65,65,33,2146,4259,4259,65,65,2146,6372,65,65,65,65,2146,8518,2146,2178,14725,10500,255},
{13041,13041,13009,13041,13041,13041,13041,13009,13009,13009,13040,13008,13008,13008,13008,13009,15089,15089,15089,13041,13040,13041,13041,15089,15089,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15122,15154,15154,15154,15154,17202,17202,17202,17234,17234,17234,17234,17234,17202,15154,15153,15121,15121,15153,17234,17234,17202,17234,17234,17234,17266,19282,6406,4291,6404,6372,8485,10630,10533,8453,12646,12711,8485,8452,12646,12679,12646,10435,22915,25028,24998,19085,16840,20900,24995,29155,22979,8584,10796,12678,18886,20966,23046,12613,12614,4259,4227,2179,2178,2178,2178,4291,10598,4259,6372,2146,2146,2178,65,65,33,4259,6372,2114,65,33,66,6340,65,65,65,65,2178,8518,65,2146,14725,6274,255},
{13041,13041,13040,13041,13041,13041,13041,13041,13009,13009,13008,13008,13008,13008,13008,13008,13041,13041,15089,13041,13040,13040,13040,15088,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15121,15121,15122,15154,15154,15154,15154,17202,17202,17234,17234,17234,17234,17234,15154,15153,15121,15121,15121,15121,15154,15154,17202,17202,17202,17234,17234,14924,10565,10565,10565,12679,14759,12612,12646,14792,14759,10566,8387,14791,16840,16840,10500,24931,35331,35332,43524,14825,12548,16644,18659,20706,20770,8453,8518,8451,27303,31496,31464,16772,14661,6275,4259,2178,2178,2178,2178,6372,8453,4259,6372,65,65,2146,65,65,65,6372,4292,33,65,65,2114,6372,65,65,65,65,4227,6405,65,2146,14693,4226,255},
{13041,13009,13009,13041,13041,13041,13009,13008,13009,13009,13009,13008,13008,13008,13008,13008,13008,13040,13040,13040,13040,13040,13040,13040,13041,13041,15089,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15122,15122,15154,15154,15154,17202,17234,17234,17234,17234,17202,15154,15121,15121,15089,15121,15121,15153,15153,17202,17202,17234,15088,10697,10533,12614,10565,12711,14759,20804,18789,21000,21000,12614,8387,22982,27143,29191,22950,16610,47586,43523,47554,49828,14759,10500,6274,14498,18722,16674,6340,2179,10564,18918,20999,18918,10500,10500,6274,2179,2178,2178,2178,2146,10500,4259,4259,6372,65,65,2178,66,33,65,6372,2178,65,65,65,66,8388,65,65,65,65,4291,6372,2145,2146,16741,4226,255},
{13009,13009,13041,13040,13040,13041,13009,13008,13009,13009,13009,13008,13008,13008,13008,13008,13008,13008,13040,13040,13040,13008,13040,13040,13040,13041,13041,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15122,15122,15122,15154,15154,17202,17202,17234,17202,17202,17202,15153,15121,15121,15089,15089,15121,15121,15154,17202,17202,12941,8518,12581,12646,10566,14792,14760,24932,51977,41639,41866,41704,20706,35236,47653,51652,51587,24802,39330,51682,47522,53729,48007,16906,12515,33,4193,16577,16577,2145,4193,8354,14693,14694,12646,6339,8388,6274,2179,2178,2178,2178,2178,14628,4227,2178,6339,65,65,2178,65,65,66,8452,98,65,65,65,65,10435,33,65,65,65,6404,4259,2145,2146,16708,6274,255},
{13009,13009,13009,13008,13008,13009,13009,13008,13008,13009,13009,13009,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13040,13040,13040,13040,13041,13041,15089,15089,15089,15089,15121,15089,15122,15122,15121,15121,15122,15122,15122,15154,15154,17202,17202,17202,17202,15153,15121,15121,15089,15089,15089,15121,15121,15121,17169,10730,8485,10533,14759,12679,16905,14824,12678,18822,35335,39624,41736,37285,33125,33254,33222,31142,26981,16675,33284,37412,37283,41507,31399,16906,12548,2080,8321,32994,35042,4259,4259,10435,16741,16774,14694,10468,6372,8387,2179,2178,2178,2178,2178,10468,4226,2178,6307,2146,65,2146,65,33,2146,6372,65,65,65,65,65,10435,65,65,65,65,8485,2179,65,65,16707,6306,255},
{13009,13009,13009,13008,13008,13009,13009,13008,13008,13009,13009,12976,13009,13008,13008,13008,13008,13008,13008,13008,13008,13008,13040,13040,13040,13040,13041,13041,13041,15089,15089,15089,15089,15121,15121,15122,15122,15121,15121,15121,15122,15154,17202,17202,17202,17202,15154,15122,15121,15089,15089,15089,15089,15121,15121,15121,15088,10631,8518,12678,12711,12711,12711,12711,16872,14792,14759,14759,14759,14759,12679,14727,16807,16775,16807,16774,18821,20869,16675,14562,12614,16971,12548,6274,8321,30945,37153,10532,8485,12548,18789,18821,14693,18820,8420,8387,2179,2178,2178,2146,4259,8420,4226,2178,4259,2146,65,2146,65,65,2178,4227,65,65,65,33,33,10435,65,65,65,65,8485,2146,65,65,14627,8354,255},
{13009,13009,13009,13008,13008,13008,13009,13008,13008,13008,13008,12976,12976,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13040,13040,13040,13041,13041,15089,15089,15089,15121,15121,15121,15122,15122,15121,15121,15121,15154,15154,15154,17202,17202,15154,15154,15121,15121,15089,15089,15088,15089,15089,17169,15121,15088,17004,10631,12679,6405,6372,6372,8485,6372,8452,10598,10598,10534,6339,8452,12614,12614,12613,10467,14596,22917,18756,14563,18690,20935,19019,12548,14691,23044,31202,37377,20835,14758,18854,25030,16708,12548,20803,10533,12515,2179,2178,2178,2178,4259,6307,4226,2178,4259,2146,65,2146,66,65,2146,2146,65,65,65,65,33,8387,65,33,65,2114,8485,2114,65,65,12547,8354,255},
{13009,13009,13008,13009,13008,13008,13008,13008,13008,13008,13008,12976,12976,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13009,13041,13041,15089,15089,15089,15121,15089,15089,15121,15121,15121,15121,15121,15122,15154,15154,15154,15154,15154,15121,15121,15121,15089,15089,15088,15089,15089,15121,17170,15088,17005,12712,12711,10599,14858,14891,17004,8453,19050,17003,16971,16971,8420,23146,19019,19019,16971,16807,16709,39624,23048,27175,37510,29450,8486,6307,4226,6273,4161,10596,4161,2081,12483,18756,10401,8354,37315,18756,14595,2178,2178,2178,2146,4259,4259,4226,2178,4259,2146,65,2146,66,2146,65,2146,66,65,33,65,33,6339,65,65,65,2146,8453,65,65,65,10499,8386,255},
{13009,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,12976,13008,13008,12976,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13009,13009,13041,13041,15089,15089,15089,15121,15089,15121,15121,15122,15122,15121,15122,15122,15154,15154,15154,15122,15121,15121,15089,15089,15088,15088,15088,15089,15121,17170,17169,17037,12745,14792,10631,14923,12876,17005,8485,21131,17004,14924,19052,8420,25226,16938,16971,16971,16839,18756,39624,16807,25225,35462,23112,66,33,33,33,33,8386,2081,6209,18626,8258,6210,6242,26914,12483,12450,2179,2178,2178,2178,2146,2178,2179,2146,4259,2146,65,2146,65,2146,65,2146,65,33,65,65,33,6307,2113,65,65,2178,6372,65,65,65,8418,10466,255},
{13008,13008,13008,13008,13008,13008,13008,13008,12976,12976,12976,12976,13008,13008,13008,13008,12976,13008,13008,13008,13008,13008,13008,13009,13008,13008,13009,13009,13041,13041,13041,15089,15089,15089,15089,15089,15121,15121,15121,15121,15121,15122,15122,15122,15121,15121,15121,15089,15089,15089,15088,15088,15089,15089,15121,15122,15121,17004,12745,14824,8517,8486,8518,10598,8452,10598,16872,16872,14760,10468,16807,18920,18952,21000,16709,18788,35431,29190,29157,43556,27207,2146,2081,0,2081,2081,4193,0,2080,10371,26887,26920,26920,24838,12483,12451,2178,2146,2178,2146,2146,2178,2178,2146,4259,2146,65,2114,2146,2146,33,2114,65,65,65,33,33,4259,2146,65,65,4259,4291,65,65,65,8386,10467,255},
{13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,13008,13008,13008,13008,13008,13009,13009,13009,13041,13041,13041,15089,15089,15089,15089,15121,15089,15121,15121,15121,15122,15122,15122,15122,15121,15121,15089,15089,15088,15056,15088,15089,15089,15121,15122,17169,10631,8518,14791,10566,6372,4324,8485,8452,8420,6372,8420,8388,10468,12548,10468,12515,14563,14563,14530,16578,16577,20672,39298,26916,2146,2080,2081,2081,0,4194,32,0,6274,33064,35177,35177,28934,10403,10403,2178,2178,4226,2146,2146,2178,2178,2146,4259,2178,65,2146,4259,65,33,2114,65,33,65,33,33,4259,2146,65,33,4292,4259,65,65,65,6306,10499,255},
{13008,13008,13008,13008,13008,13008,13008,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,13008,13008,13008,13008,13009,13009,13009,13009,13041,13041,15089,15089,15089,15089,15089,15089,15089,15121,15121,15122,15121,15121,15122,15121,15121,15089,15088,15056,15056,15088,15089,15089,15121,17202,12844,10598,10631,14792,10566,6372,6404,8485,8453,8452,10533,10533,10501,12548,12581,12581,14629,14628,14595,16675,22883,20738,20705,39298,24901,2146,2080,2080,4128,32,8257,8257,4128,16579,24806,24806,24806,18628,2146,2113,66,66,8354,2113,65,2146,2178,2146,2178,2146,65,4227,2211,65,33,66,65,65,33,33,65,4259,2146,65,33,6372,2146,65,65,65,4258,10499,255},
{13008,13008,13008,13008,13008,13008,13008,13008,12976,13008,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,13008,13008,13008,13008,13008,13008,13009,13009,13041,15088,13041,13041,15089,15121,15089,15089,15121,15121,15121,15121,15121,15122,15121,15089,15088,15056,15056,15056,15056,15088,15089,15089,12942,4292,10566,12712,16905,12711,14858,14891,16971,8485,16905,27568,25455,19083,10501,23147,29583,31696,23212,20935,22884,45898,41933,33351,41605,18887,4226,2080,2080,4128,2080,8289,8224,4128,8257,8256,10305,12353,4128,33,2114,2146,97,4226,65,65,2113,2178,65,2146,2146,65,6340,2146,33,33,65,65,65,33,65,4259,2178,2146,33,33,6405,2146,65,65,65,4226,12579,255},
{13008,13008,13008,13008,13008,13008,13008,13008,12976,13008,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,13008,13008,13040,13040,13040,15089,15089,13041,13041,15089,15089,15089,15121,15121,15121,15121,15121,15121,15089,15089,15056,15056,15056,15056,15056,15088,15089,15089,10763,6373,8518,12711,16905,12744,14923,14924,17037,10533,21132,17101,17101,19084,10501,27340,21196,21261,16971,18920,20837,47944,35691,29222,33349,14726,4194,2080,2080,2080,0,16643,12418,4128,6176,6208,8289,8256,2080,65,2146,2178,2178,2146,65,65,65,2146,65,2146,2146,2146,4259,2114,65,65,65,65,65,33,2114,4259,2178,2146,33,65,6405,66,65,65,65,4194,14627,255},
{13008,13008,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,13008,13008,13008,13008,13008,13009,15089,13040,15089,15089,15089,15089,15121,15121,15121,15121,15121,15121,15089,15088,15056,13008,13008,15056,15056,15056,15089,15121,10730,2179,8518,12679,14824,10631,12711,12712,12712,8453,12711,19051,19051,19018,8420,18953,23211,25260,25259,18855,31206,49766,43557,41476,43556,33222,28963,28898,28866,26785,22657,30946,30914,24737,8288,4128,4096,4128,6208,4161,33,65,33,6242,2113,65,65,2146,2145,2178,2146,4259,2146,65,65,33,66,66,65,33,2146,2179,2178,2146,65,65,8453,65,65,65,65,2146,14659,255},
{13009,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,15056,15056,15056,13008,13008,13040,13008,13009,15089,15089,15121,15121,15121,15121,15121,15121,15089,15088,15056,15056,15056,15056,15056,15056,15056,12975,8584,6405,6373,10598,10599,14824,10630,4324,4324,6404,8453,6372,6372,8388,8420,8420,10500,14596,14595,16643,16643,20837,39301,35172,20772,18691,20804,14531,14433,18593,14433,14400,14400,16449,18561,20675,10274,14402,14467,14498,12450,6340,4227,2146,6306,2146,65,2145,2178,65,2146,2178,4227,65,65,33,33,66,66,33,33,2178,2178,2146,2178,33,65,4259,65,65,65,65,4226,16707,255},
{13009,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12975,12975,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,13008,13008,13008,15056,13008,13008,13008,13008,13040,15089,15089,15089,15121,15121,15121,15121,15089,15089,15088,15056,15056,15056,15056,15056,15056,15056,8585,4259,6404,6372,10598,12679,14825,10631,6372,4324,6404,8453,6372,8420,8420,10468,10436,12516,16644,18723,18723,20771,20771,24866,24865,26881,45410,18921,4227,0,65,0,0,0,0,0,8387,14661,12581,14693,14660,4259,6404,4259,2178,2178,2178,2146,2146,2179,65,2178,4259,2178,65,65,33,65,65,65,65,33,4259,2146,2146,4194,33,33,65,65,65,65,65,2178,16707,255},
{12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12975,12975,12975,12976,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,13008,13008,13008,13008,15056,13008,13040,15088,15089,15089,15121,15121,15121,15121,15089,15057,15056,13008,15056,15056,15056,15056,15056,15056,6471,2146,4292,4259,10598,14824,14857,10631,12778,12810,14858,8453,14792,21131,19051,21099,14628,23080,27307,27307,31402,31206,29058,47782,35333,37348,39331,10566,2146,0,0,0,0,0,0,2113,2113,18917,25158,25191,23110,6306,8485,4259,2178,2178,2178,2178,2146,2178,2145,4259,4292,2146,65,65,33,33,65,66,33,33,4259,2146,2146,4226,33,65,65,65,65,65,65,2145,14627,255},
{12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12975,12975,12975,12976,12976,12975,12975,12976,12976,12976,12976,13008,13008,13008,13008,13008,13008,13008,13008,13008,13008,13040,13040,13040,15089,15089,15089,15121,15089,15089,15056,15056,13008,15056,15056,15056,15056,15056,13008,6471,2146,4259,2146,10598,14857,16905,12744,12844,12844,14989,8518,21131,16938,14858,19051,12548,31435,21001,27111,33157,39365,33090,51845,24931,14595,14595,4194,2114,32,0,0,33,2081,0,8321,6241,18917,27239,29351,25190,6306,8486,6372,2146,2178,2178,2146,2146,2178,65,6340,4259,2146,65,65,33,65,65,65,33,33,4259,66,2146,4226,33,65,65,65,65,65,65,2146,14627,255},
{12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12975,12975,12976,12975,12975,12975,12975,12975,12975,12975,12975,12975,12976,12976,12976,12976,12976,13008,13008,13008,13008,13008,13008,13009,13009,13009,13040,15089,15089,15089,15089,15089,15089,15089,15056,15056,15056,15056,15056,15056,13008,13008,15056,6471,2146,2146,2178,8518,14792,12711,10599,12712,12777,14825,8453,12711,21131,21131,21099,12516,27209,33483,47718,58121,54025,45670,51941,37316,16610,4193,2081,2113,33,0,33,2081,8289,2048,32,8387,14757,14758,14758,14758,6371,8485,6404,2146,2178,2178,2146,2146,2178,2146,6372,2178,2146,65,2146,33,65,65,65,65,33,4292,65,2146,4227,33,65,65,65,65,65,2145,2146,14627,255},
{12976,12976,12976,12976,12976,12976,12976,12976,12976,12975,12976,12975,12975,12943,12975,12975,12943,12943,12975,12975,12975,12975,12975,12976,12976,12976,12976,13008,13008,12976,13009,13009,13009,13009,13008,13009,13009,13009,15089,15089,15089,15089,15089,15089,15057,15056,15056,15056,15056,13008,13008,13008,12976,6406,2113,2178,2179,10598,14792,12711,10598,4291,4323,4324,6404,6372,8420,8420,10468,10435,18692,25031,49736,65144,60366,45346,33122,28929,12449,2112,2080,4129,2081,0,0,0,4129,4161,2081,2113,8453,8517,8518,8485,2113,6372,6340,2146,2178,2178,2146,2146,2178,6340,4259,2146,2146,66,2146,33,33,65,2114,65,65,6340,33,2114,4227,33,65,65,65,65,65,2146,2146,14659,255},
{12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12975,12975,12975,12943,12975,12943,12943,12943,12943,12943,12943,12943,12975,12975,12976,12976,12976,12976,13008,13008,13008,13008,13009,13008,13008,13008,13009,13009,15089,15089,15089,15089,15089,15089,15056,15056,15056,15056,15056,15056,15024,15056,12976,6471,2146,2179,2179,8485,12712,12712,10598,4291,4291,6372,6404,6372,6372,8388,10436,10435,16610,16709,33321,53701,51426,32960,26848,24800,8321,2113,4128,6307,4291,0,0,6177,18562,18691,10402,6273,8485,10566,10566,10565,2113,4259,6340,2178,2178,2178,2178,2146,4259,8453,2178,2146,2146,2146,2178,33,33,65,2146,65,65,4292,33,2114,4259,33,65,65,65,65,65,2145,8386,16772,255},
{12976,12976,12976,12976,12976,12976,12976,12975,12975,12943,12943,12975,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12976,12976,12976,12976,12976,12976,13008,13008,13008,13008,13008,13008,13008,13009,13008,15088,15089,15089,15089,15088,15056,15056,15056,15056,15056,15056,15024,15024,12976,6438,4259,2179,2178,8485,12711,12712,10631,10664,10664,12744,6405,10598,16970,19018,16905,10436,20903,23113,27242,35334,33156,31074,47685,35300,8289,6274,8355,19051,4194,33,6177,6177,12353,28963,14465,6241,8453,10598,10598,10565,6242,6340,6404,4226,2178,4259,4227,2146,10597,6339,2178,2146,2146,2146,2178,33,65,65,65,65,2146,4259,33,2113,6307,65,65,65,65,2145,65,6306,16771,16740,255},
{12976,12976,12976,12976,12976,12976,12976,12975,12975,12975,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12976,12976,12976,12976,12976,12976,12976,12976,13008,12976,13008,13008,13008,13009,13009,15088,15089,15089,15056,15056,15056,15056,15056,15056,13008,12976,12976,12976,15024,6503,2146,4259,4227,8518,12744,14792,12712,12810,12844,14957,8518,19050,16938,16938,19051,10501,27242,16873,18985,18887,27111,26947,49797,24963,16675,14628,6275,6405,6210,4162,6177,2081,6177,8224,4161,6307,8485,8453,8453,8452,6274,8452,8485,4259,2178,4291,4259,4226,12645,2146,2178,2146,2146,2146,2146,65,33,65,2146,33,2178,4259,33,66,6339,65,65,65,65,66,6338,16739,18819,16771,255},
{12976,12976,12976,12976,12976,12976,12975,12975,12943,12975,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12976,12975,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,13008,15057,15056,15088,15088,15056,15056,15056,15056,15056,15056,13008,12976,12976,12976,12976,12943,10731,8650,2179,10599,14824,12711,10598,12744,12777,14858,6437,12712,21164,21164,21131,8420,23048,25227,27307,29322,25031,22851,49830,35333,39428,25095,10599,2179,10307,4196,12387,6242,2113,6209,16578,8289,6273,4193,16643,6241,20737,12613,8452,8387,4259,6340,4259,8420,10468,2146,2179,2178,2146,2146,2146,65,65,65,2178,65,2146,2178,65,65,10466,65,65,65,65,8386,18818,20866,25026,16739,255},
{12976,12976,12976,12976,12976,12976,12975,12975,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12976,12975,12975,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,15056,15056,15056,15056,15056,15056,15056,15056,15056,15024,12976,13008,12976,12976,12976,12976,15056,12943,4292,6405,8518,10598,8485,4259,4291,6372,6404,6372,8452,8420,8420,6307,10436,14595,16643,16643,16611,18658,29027,24834,24801,16808,16907,2146,12355,4195,6275,2146,2146,4194,27044,20802,12416,12384,10369,4128,35137,22884,14595,27044,10435,16708,6339,20900,10467,2178,4259,4227,2178,2146,2146,65,33,66,2178,65,65,65,65,65,12514,65,65,98,10466,25026,22945,22946,31234,18818,255},
{12976,12976,12976,12976,12976,12975,12975,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12943,12975,12976,12976,12976,12976,12976,12976,12976,12976,12976,13008,13008,15056,15056,15056,15056,15056,15056,15056,15056,15056,15056,13008,12976,12976,12976,12976,12910,12812,14957,10697,12712,14792,16905,16905,12712,12712,12744,12744,12711,12679,12679,12679,12679,14695,14694,16741,16741,16709,14628,16643,18658,20706,16776,14793,2146,6242,2179,4195,14468,4194,6241,41998,45996,26816,43524,33058,12417,45797,47748,27076,39720,24899,31204,22915,29091,14628,4259,6307,6339,2178,2146,2146,65,65,66,2178,65,65,65,65,65,14562,2113,66,14626,25026,29154,31201,18721,18786,18786,255},
{12976,12976,12976,12976,12976,12975,12975,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12976,12976,12976,12976,12976,12976,12976,13008,13008,13008,15056,15056,13008,15056,15056,15056,15056,15056,15056,15024,12976,12976,12976,12976,12943,12909,14990,15055,12777,14792,14824,14857,19051,19149,19084,14857,19018,19051,19019,23212,19018,23179,25325,25292,25292,27274,27241,33417,31369,31336,29289,25161,4259,6243,2178,4227,12419,2146,4193,33513,41835,28897,56689,47621,20705,52137,51908,33317,39559,27011,29123,27076,20803,20803,6372,8419,8419,2179,2146,2146,65,65,66,4226,65,65,65,65,65,16642,2113,14658,29153,33282,35297,20801,2146,18786,16706,255},
{12976,12976,12975,12976,12976,12975,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12975,12975,12975,12976,12976,12976,12976,12976,13008,13008,15056,15056,15056,15056,15056,15056,15056,15056,15024,12976,12976,12976,12976,12976,15024,15056,15089,15121,12745,10598,8485,8518,14891,19247,12844,8486,16937,12777,10665,14891,8420,16905,12712,12679,10598,16774,16643,39526,20804,29125,18888,10694,4291,4227,2178,2178,2146,4227,2146,8321,22689,33059,30978,22656,12448,41217,31074,18690,12483,8387,14628,12580,8420,10499,2211,8387,6339,2178,2145,2146,65,65,66,2178,65,65,65,65,65,18722,14594,27106,22945,29122,14561,2146,2146,20866,14594,255},
{12976,12976,12976,12976,12975,12943,12943,12943,12943,12943,12943,12943,12911,12943,12911,12911,12911,12911,12911,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12943,12975,12976,12976,12976,12976,12976,12976,13008,13008,15056,13008,15056,15056,15056,15056,15056,12976,12976,12976,12976,15024,12976,12976,15024,15056,15089,12746,10631,8485,8485,10631,12777,12777,6405,12711,19051,16971,19051,6340,18920,21066,18953,18921,16775,14595,39494,27045,35300,20967,10792,17034,4227,10564,12709,10628,6340,2146,4161,16449,20674,10304,6176,10368,31041,16675,8387,4226,4259,8452,4291,4259,6339,2178,4259,4227,2146,65,2146,65,65,65,2178,65,65,33,65,65,24962,20867,20899,18786,6306,2146,2146,2146,20866,10465,255},
{12975,12976,12976,12976,12943,12943,12943,12943,12943,12943,12943,12943,12911,12943,12911,12911,12911,12911,12911,12911,12911,12943,12911,12943,12943,12943,12943,12943,12943,12943,12943,12975,12976,12976,12976,12976,12976,12976,12976,13008,15056,15056,13008,15024,15056,15024,15024,12976,12976,12976,12975,15024,12976,12975,12976,15024,15056,12778,10599,10566,8485,4259,4259,4291,6372,4291,6404,8452,8420,6307,8388,12549,12549,12548,10435,10435,20804,18691,22753,18757,8614,19435,2210,10597,14822,19143,8484,2146,4161,14400,18593,8257,14530,12481,31170,14628,8420,4226,4291,10533,4259,4259,6339,2178,4259,4259,2178,65,2146,65,65,65,2178,65,65,65,65,10466,27075,16773,14626,4194,65,97,65,4226,22946,8353,255},
{12975,12976,12975,12975,12975,12943,12943,12943,12943,12943,12943,12911,12911,12911,12911,12911,12911,12911,10863,12911,12911,12911,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12975,12975,12976,12976,12976,12976,12976,12976,15024,12976,12976,15024,15024,15024,12976,12976,12976,12976,12975,15023,15023,12975,15023,12976,15056,10697,10598,8453,8453,2179,4227,4259,6340,4259,4259,4259,4259,4259,6307,8323,6275,6274,8322,6242,8289,10369,12448,30945,22819,6499,4324,4226,4259,10565,10500,2178,8354,46061,39688,31270,22787,8321,24898,20868,16708,4226,6372,12613,4292,4259,10500,2179,4291,4226,2178,65,2146,65,65,65,2146,65,65,65,8419,18851,27108,8452,2113,65,65,65,65,4258,20899,6306,255},
{12975,12975,12976,12943,12943,12943,12943,12943,12943,12943,12911,12911,12911,12911,12911,12911,12911,12911,12911,12911,12911,12943,12911,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12975,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12976,12975,12975,12975,12943,15023,12975,15056,10665,10631,6405,8453,6405,8518,8518,6340,6372,12679,10599,10566,4259,8420,10566,10566,10533,10435,10403,18756,16675,18691,41314,39427,31301,37997,21063,19016,16838,6306,6372,10533,39816,47748,14497,10467,16741,16643,14627,14660,4162,4259,6372,4259,4259,10467,2179,4259,2178,2178,65,2146,65,65,65,2146,65,65,6339,16739,18819,22980,2178,65,65,65,65,65,6338,18851,4226,255},
{12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12911,12911,10863,12911,10863,12911,12911,12911,12911,12911,12911,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12975,12976,12976,12976,12976,12976,12976,12976,12975,12976,12976,12976,12976,12976,12976,12943,12943,12943,12943,12943,12975,15023,10697,10631,8453,8518,8551,10697,12778,6373,12711,12712,10664,12777,6307,14759,10631,12679,10598,12614,8387,27110,18756,24997,37412,33349,31365,54969,37801,50577,46188,37967,6404,2114,18690,26914,2081,6307,12580,8355,6339,8420,4161,2178,4227,4227,2178,4259,2146,2178,2178,2146,65,2145,65,65,65,6306,65,6339,14692,14627,8386,10532,2178,65,65,65,65,65,8418,16739,2146,255},
{12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12911,12911,10863,10863,10863,12911,12911,12911,10863,10863,12911,10863,12911,12911,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12976,12976,12976,15023,12976,12976,12975,12975,12975,12975,12975,12975,12975,12975,12943,12943,12943,12943,12943,12975,12975,10665,8518,8453,8485,8486,10632,10664,6372,8453,14825,14858,14858,4227,12678,14824,14825,12711,10565,8355,29190,27012,33220,41669,33348,31333,54936,37768,54936,54969,38033,8451,8450,8354,18657,0,0,0,14498,4259,6339,2113,2146,2178,2178,2178,2178,2146,2178,2146,2146,65,65,65,65,65,10466,6339,12580,10499,4226,65,14661,4226,65,65,65,65,65,10498,14659,2146,255},
{12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12911,10863,10863,12911,10863,10863,12911,12911,10863,10863,10863,10863,10895,10895,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12943,15023,15023,15023,12975,12975,12975,12975,12975,12975,12975,12975,12943,12943,12943,12943,12943,12943,12943,10665,10566,6372,6372,4259,4259,4259,4292,4291,6372,6372,6372,4259,6339,8420,8452,8420,6307,8387,16708,16675,18690,24930,24962,29220,54867,37572,46190,44174,27435,8387,6306,4193,12449,0,0,2113,26914,4227,6339,2113,2146,2146,2178,2178,2178,2146,2178,2146,2146,65,65,33,33,65,12579,14660,8419,2146,65,65,12645,6274,65,65,65,2145,65,12579,12579,2146,255},
{12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12911,10863,10863,10863,10863,10863,10863,12911,12911,12911,10862,10862,10863,10863,10863,12911,12911,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12943,12943,12975,12975,12943,12975,12975,12975,15023,12943,12943,12943,12942,12943,12942,12943,12943,12877,12876,6470,10665,12810,12810,12778,10632,10598,8518,8485,10566,10565,10565,10565,12581,12581,12581,12580,14595,16675,16675,18722,16641,22882,39555,37378,31170,31172,14629,6338,8418,2146,2113,0,0,2113,24865,4226,6339,2081,2146,2146,2178,2146,2178,65,2146,2178,2146,65,65,33,65,4259,16708,10500,2146,65,65,2146,14693,8321,65,66,65,2145,2114,18786,12546,2146,255},
{12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12911,12911,12911,10863,10862,10862,10863,10863,12911,12911,12911,10862,10862,10863,10863,10863,12911,12911,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12975,12943,12943,12943,12943,12943,12942,12942,12942,12942,12943,12943,12943,12910,12943,12975,15024,15023,12844,2179,8355,25227,21066,10467,8322,10369,12450,10369,12449,14529,16577,18657,20801,16834,13316,17124,16544,14497,12449,12450,8452,2179,6405,2146,12418,6305,6337,4193,22753,4194,4259,2113,97,2145,2146,2146,2178,65,2146,2178,2146,66,65,33,2178,6339,16675,4226,65,65,65,2178,14660,12449,65,65,65,65,2146,22914,10433,4259,255},
{12943,12943,12943,12943,12943,12943,12943,12943,12943,12911,12911,12911,12910,10862,10862,10862,10862,12911,12911,12910,10862,10862,10862,10863,10863,12911,10863,12911,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12942,12942,12910,12942,12942,12943,12943,12943,12943,12943,12943,12943,12943,6438,2178,8518,44341,48567,16840,4161,8289,10337,6209,6241,8289,10401,20672,31203,35789,27819,15044,14529,41897,37443,29091,16773,4293,8617,4259,20899,16675,10498,4226,20706,4194,4259,2113,65,65,2146,2146,2178,65,2146,2178,2146,65,33,2146,4259,4226,6306,6340,33,33,65,4259,12547,14497,65,65,65,97,4226,31169,8353,10500,255},
{12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12911,10863,10862,10862,10862,10862,12910,12910,12910,12910,10862,10862,10863,10863,10863,10863,12911,12911,12942,12942,12943,12943,12942,12942,12942,12942,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12942,12942,12942,12910,12942,12942,12942,12942,12942,12942,12942,12910,12910,12910,6406,66,8453,40115,48534,14759,33,4161,10337,4161,8354,10402,16642,31140,41933,50647,41933,18657,14561,41833,37347,22850,22982,4292,8584,6371,8419,20578,6209,2081,4194,2081,4259,2113,65,65,2146,65,2178,65,2146,4227,2146,65,65,2146,2146,65,2178,4291,33,33,33,4292,8387,14529,65,65,65,65,6306,33185,6306,12613,255},
{12943,12943,12943,12943,10895,12943,12943,12943,12943,12911,10863,10863,10862,10862,10862,10862,12910,10862,10862,10862,10862,10862,10862,10862,10863,12911,10863,12910,12942,12942,12943,12943,12942,12942,12942,12943,12943,12943,12942,12943,12943,12943,12943,12943,12943,12943,12943,12943,12943,12942,12942,12942,12910,12910,12910,12942,12910,12910,12910,12910,12910,12910,10797,14925,10664,6372,4194,14694,23048,6307,0,6209,10369,8289,10369,16642,24899,46127,50647,41705,45670,37057,24897,37542,31074,18691,12515,2113,10403,8290,4194,18563,6242,2080,4096,1,2146,2113,65,65,65,65,2146,65,4194,6275,65,2146,65,65,65,33,2178,4259,33,33,33,6372,4258,10433,33,65,65,65,6305,29089,8355,18821,255},
{12943,12943,12943,12943,12943,12943,12943,12943,12943,10863,10863,10862,10862,10862,10862,12910,12910,12910,10862,10862,12910,10862,10862,10862,10862,10863,10862,10862,12910,12942,12911,12942,12942,12942,12942,12942,12942,12942,12943,12942,12942,12942,12943,12943,12943,12943,12943,12942,12942,12942,12942,12942,12910,12910,12942,12910,12910,12910,12910,12910,12878,10763,6405,18985,48567,35791,10434,12482,8354,32,33,4161,8289,10370,12449,14529,18723,35300,39657,41803,39627,20650,16577,29221,14530,12483,4194,2081,4129,4129,4161,0,0,2081,2081,33,65,65,65,65,65,65,2146,65,65,2146,2146,2178,65,65,65,33,4227,4259,33,33,33,4291,2145,10433,33,65,65,65,10433,24961,10435,24997,255},
{12943,12943,12943,12943,12943,12943,12943,12943,12911,10863,10863,10862,12910,12910,10830,12910,12910,12910,12910,12910,12910,12910,12910,10862,12910,12910,12910,10862,12910,12910,12910,12910,12942,12942,12942,12942,12910,12910,12942,12910,12910,12942,12942,12943,12943,12943,12942,12942,12942,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12877,6471,2178,18984,54938,42194,8354,6274,2113,0,32,0,32,4161,8321,14498,14530,14497,16545,14465,12418,4163,2081,2081,0,33,33,0,2081,2081,2081,32,0,2081,2081,33,33,65,65,65,65,65,2145,65,65,2146,2178,2146,65,65,65,33,4227,2146,33,33,33,65,2113,8354,33,33,65,33,12513,18753,6307,16708,255},
{12943,12943,12943,12943,12943,12943,10895,10863,10862,10863,10862,10862,12910,12910,12910,10862,10862,12910,12910,12910,12910,12910,10862,10862,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12942,12942,12910,12910,12910,12910,12910,12910,12942,12943,12943,12943,12942,12942,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12877,8551,16873,35922,21098,6275,8420,2178,1,0,4161,6209,6241,12449,31043,33155,33155,35170,43298,49507,37219,28866,27045,8321,6242,2081,0,32,2080,2048,32,0,0,33,33,33,33,65,65,65,65,65,65,2146,4226,2145,65,65,65,65,33,2179,2114,33,33,33,33,65,6306,33,65,33,65,12546,12546,4226,8387,255},
{12943,12943,12943,10895,12943,10895,10863,10862,12910,10862,10862,12910,10862,10862,12910,10862,12910,12910,12910,12910,10830,10862,10862,12910,10862,12910,12910,12942,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12942,12942,12943,12943,12942,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12878,12844,10698,10664,6339,12646,40115,29550,4227,32,4194,8355,6306,8354,8289,10402,12482,16545,31074,51940,35623,18561,41348,18625,14530,8289,12515,12450,8354,22981,18756,2080,32,2081,33,33,2113,65,65,65,65,2146,2146,2178,2146,65,65,66,65,65,33,4259,66,33,33,33,33,33,6274,33,33,33,33,12514,8386,4292,6372,255},
{12943,12943,12943,12943,12943,10863,10862,10862,10862,12910,12910,12910,10862,12910,12910,12910,12910,12910,12910,12910,10830,10862,10862,10862,10862,12910,12910,12910,12942,12942,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12942,12942,12942,12942,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12878,12877,10764,4292,2114,14792,48599,46421,10468,0,2146,8485,10565,8387,8419,12580,12547,12580,27269,29380,20900,27077,22721,12385,10369,10369,10533,12580,8354,27143,39690,18626,4129,2081,33,65,4194,2113,65,2146,65,4259,4259,2146,65,65,65,2113,65,65,33,4291,66,33,33,33,33,33,4226,33,33,65,65,12547,6306,4259,8485,255},
{10895,12943,12911,12911,12911,12943,10862,10862,10862,12910,12911,12910,12910,12910,12910,12910,12910,12910,10830,10830,10830,10862,12910,10862,10862,12910,12910,12942,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12942,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12878,12878,10797,10731,10665,8584,6340,10565,46388,46291,12580,4227,4226,10468,16643,14562,12514,16643,18722,18755,20867,22947,22915,29156,18722,26850,24898,18724,16808,10565,10500,12450,16610,14498,4161,2146,10402,6274,8355,2113,65,2146,6307,6372,2146,65,65,65,65,65,65,65,65,6340,2114,33,33,33,33,33,4226,65,33,33,2113,14626,4226,4291,6404,255},
{12943,12911,12911,12911,12911,12911,12910,10862,12910,12910,12910,12910,12911,12910,12910,12910,10830,10830,10830,10830,12910,12910,12910,10862,10862,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,10797,10764,10665,10665,10599,6372,10566,16839,8452,6340,4226,16676,22852,24899,24899,24931,26979,29027,33123,45378,47458,49570,45442,43362,39298,43426,43460,35170,35170,35138,33090,31010,30978,26882,28994,20770,12515,2113,2146,8387,16676,4227,2145,2145,2145,65,65,2146,65,65,65,6339,2114,33,33,33,33,33,4226,65,33,33,2145,16674,4194,6372,8453,255},
{12911,10863,12911,12911,12911,10863,10862,10862,10862,12910,12910,12910,12911,12910,12910,12910,10830,10830,10830,10830,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12878,12878,12878,12877,12877,12877,12877,12845,10666,8486,8486,4291,6371,23109,14758,6339,4194,8420,26948,37316,6177,4161,2113,12418,16578,24867,35268,37348,26914,20641,24834,24899,27078,16610,16643,16610,18691,24899,24867,24867,22786,16610,10435,2113,4259,12548,8355,2146,2145,2145,2146,65,2145,2146,65,65,65,4194,2113,33,33,33,33,33,6274,65,33,33,6241,20737,4194,8485,8452,255},
{10863,12911,12911,12911,12911,10863,12910,12910,12910,12910,12910,12910,12911,12910,12910,12910,10830,10830,10830,10830,12910,12910,12910,12910,12910,12910,12910,12910,12910,12911,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12878,12877,12878,10829,12877,12877,12877,10764,10698,8551,8551,4292,4259,6372,6340,4226,6307,6307,16546,24738,12418,10402,8354,12482,8289,12514,18723,20771,14530,8289,8289,16676,29159,6274,6340,2146,4194,14562,4193,0,2113,2146,4227,2113,4259,4226,2146,2146,2145,2145,2146,65,65,2146,65,65,65,2081,2113,33,33,33,33,33,4226,65,33,1,8321,22721,4194,10533,8420,255},
{10863,12911,12911,12911,12911,12911,12910,12910,12910,10830,10830,12910,12910,12910,12910,10830,10830,10830,10830,10830,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,10830,12878,12878,12878,12877,12877,12877,10829,10829,12877,10764,8585,8584,6373,6372,6339,6340,8486,6339,6340,4226,4194,6307,6274,4194,4193,8322,12482,16676,16643,14530,4160,6305,10434,18724,6274,6307,21000,18984,14595,2080,4161,6242,6307,4227,2146,2179,2146,2146,2146,2145,2146,2146,2145,65,2146,2113,65,65,2113,2114,33,33,33,33,32,4194,2081,33,33,14465,22657,4194,10501,6307,255},
{10863,12911,12911,12911,12879,12879,12878,12910,10830,10830,10830,10830,12878,12878,10830,10830,10830,10830,10830,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,10830,10830,10830,10830,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,10830,10830,12877,12877,10829,12878,10829,10829,10829,10829,10829,12877,12845,10731,12779,8486,8452,8485,8485,8486,6307,6339,6339,8387,6306,12579,12580,6273,8321,31140,39428,29059,10401,10369,16675,16676,16709,2113,4194,20901,37707,14530,10401,16544,8322,10467,6307,2113,2146,2146,2146,2146,2145,2146,2146,2146,65,2146,2146,65,2145,2113,4162,33,33,33,32,0,4194,2113,33,33,18561,20577,2178,12581,4194,255},
{12911,12910,12910,12878,12910,12878,10830,10830,10830,12910,10830,10830,10830,10830,10830,10830,10830,10830,10830,12910,12911,12910,12910,12910,12910,12910,12910,12910,12910,12910,10830,10830,10830,10830,10830,10829,10830,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12877,12878,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,12845,10731,10731,6470,8485,10598,6372,6373,6307,6339,4194,4194,2113,21129,14758,4161,10369,12450,14497,24866,24898,18626,30947,10370,6339,12582,20740,24834,27011,12482,20738,18624,6242,4194,4226,33,2146,2145,2146,2146,2145,2146,2146,65,65,2146,2114,65,2145,2113,2114,65,33,33,33,0,2146,33,32,33,18625,12418,4259,12614,2146,255},
{12910,12910,12910,12878,10830,10830,10830,10830,10830,10830,10830,12910,10830,10830,10830,10830,10830,10830,10830,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,10830,10830,10829,10829,10829,10829,10829,10830,12910,10830,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12910,12878,12877,12877,10829,10829,10829,10829,10829,10829,10829,10829,10829,12877,10764,10698,8617,8584,10598,10630,8551,12779,8453,8420,10500,8387,8387,25224,20901,10401,16643,18690,31139,35234,29026,20674,31079,18823,16775,14597,16710,31269,39622,27011,14529,20672,8322,4226,4226,33,2146,2145,2145,2146,65,2145,2146,2145,2145,2146,2146,65,65,2113,2114,33,65,65,33,0,2146,2113,33,33,16610,6274,4292,10533,65,255},
{12910,10830,10830,10830,10830,10830,10830,10830,10830,10829,10830,10830,10830,10830,10830,10830,10830,10830,12910,12910,12910,12910,12910,12910,12910,10830,10830,10830,10830,10829,10829,10829,10829,10829,10829,10829,10830,10830,10830,12910,12910,12910,12910,12910,10830,12910,12910,10830,10830,12878,12877,10829,10829,10829,12877,10829,10829,10829,10829,10829,10797,10797,10797,10796,10764,12844,8650,8517,12711,14858,14957,8485,8452,8420,14693,16741,14595,14562,18691,31108,45473,53664,53728,33090,16545,27045,20804,20871,18759,16644,16644,16709,22949,24931,22753,8321,6274,4259,33,2146,2145,65,2145,65,2145,2146,65,65,2146,2146,65,65,2146,2146,33,2178,2146,33,33,2146,2113,0,2081,14595,4226,6372,8485,65,255},
{12879,12910,10830,10830,10830,10830,10830,10830,10830,10830,10830,10830,10830,10830,10829,10830,10830,10830,12910,12910,12910,12910,10830,10830,10830,10830,10830,10829,10829,10829,10829,10829,10829,10829,10829,10829,10830,10830,10830,12910,12910,10830,10830,10830,10830,12910,10830,10830,10830,12878,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10797,10797,10796,10764,10764,12844,10666,8485,14792,14890,17006,10566,10533,10533,10500,8387,18723,24963,18658,20706,26882,26882,37250,31042,20673,35233,29025,18691,14596,8289,2081,4161,6273,10402,22753,6241,6307,6340,2146,2146,2146,65,2146,65,2145,2146,65,65,2146,2146,65,65,2146,4194,0,4259,2146,33,32,2145,2113,0,2113,12547,2146,8453,6372,65,255},
{12879,12878,10830,10830,10830,10830,10830,10830,10830,10829,10829,10830,10830,10830,10829,10830,10830,12910,12910,12910,10830,12910,10830,10830,10830,10830,10830,10829,10829,10829,10829,10829,10829,10829,10829,10830,10830,10830,10830,12910,12910,10830,10830,10830,10830,12878,12910,10830,10830,10829,10829,10829,10829,10829,10829,10829,10797,10829,10797,10796,10796,10796,10796,10764,10796,10796,10666,8485,10630,10598,12747,10534,12711,18952,16806,20901,29189,24931,29027,33123,43266,43266,43298,33090,20672,33152,26945,18691,8289,16546,4226,8354,6274,8322,22785,6273,6307,6372,2146,2146,2146,2146,2146,2145,2146,2145,65,65,2146,2146,65,65,2146,2146,33,4292,65,33,0,2113,2145,0,2145,12547,2146,8485,4291,65,255},
{10830,10830,10830,10830,10830,10830,10830,10830,10830,10829,10829,10829,10830,10830,10830,10830,12910,12910,12910,10830,10830,10830,10830,10830,10830,10830,10829,10829,10829,10829,10829,10829,10829,10830,10830,10829,10829,10830,10830,10830,12910,10830,10830,10830,10830,10829,12878,12878,10829,10829,10829,10797,10829,10829,10829,10797,10797,10829,10797,10796,10796,10796,10796,10732,10796,10764,10666,8485,10598,8420,6342,10533,14791,16904,16774,25063,33318,33220,37315,41314,53441,55392,57504,37153,20640,31041,30881,24899,22786,14595,14660,20868,14562,6306,24865,8322,6307,6340,2146,2146,2146,2145,2146,2146,2146,2145,65,65,2145,2145,65,65,2146,2146,33,4292,33,33,32,2113,4193,0,4225,12547,2178,8486,2211,65,255},
{10830,10830,10830,10830,10830,10830,10830,10830,10829,10829,10829,10830,10830,10829,10829,10830,10830,12910,10830,10830,10830,10829,10830,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10830,10829,10830,10830,10830,10830,10830,10830,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10797,10797,10797,10797,10797,10797,10797,10797,10796,10796,10796,10732,10796,10796,10665,6405,8485,4259,4229,8453,14791,16839,18724,29030,35173,45445,47461,33059,26914,28930,35169,35105,20640,33121,35171,22852,18593,6241,6306,8387,10402,6306,22785,8322,6307,6340,2178,2146,2146,2145,2146,2146,2146,2146,65,65,2145,2145,65,65,98,4226,33,4292,33,33,0,2113,4193,0,6273,10466,2178,6405,2146,65,255},
{10830,10830,10830,10830,10830,10830,10830,10829,10829,10829,10829,10829,10829,10829,10797,10830,10830,10830,10830,10830,10830,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10797,10829,10829,10830,10829,10830,10830,10830,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10797,10797,10797,10797,10797,10797,10797,10796,10796,10764,10731,10796,10764,8519,4227,6372,6339,8453,10566,12679,25031,22658,28867,30850,41091,53477,45283,53570,53569,49505,39233,28897,31073,39266,20738,16546,12450,14628,10468,10435,10435,24897,10402,6339,6372,4227,2178,2178,2146,2146,2146,2146,2146,65,65,2146,2146,65,65,2146,4226,65,4291,33,33,0,2113,4225,0,8354,8386,2178,6404,98,65,255},
{10830,10830,10830,10830,10830,10830,10829,10829,10830,10830,10798,10829,10797,10797,10797,10797,10829,10830,10830,10830,10829,10829,10829,10829,10829,10829,10829,10797,10797,10829,10829,10829,10829,10829,10829,10829,10830,10830,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10797,10829,10797,10797,10797,10797,10796,10797,10797,10797,10796,10796,10764,10731,10764,10763,8584,6438,8453,10565,12679,14792,14792,24998,20512,28835,30883,28705,35043,37124,53475,59618,59650,51490,45346,45410,43427,35268,29027,33155,37283,37348,37316,39396,41443,33155,16675,10468,10435,4226,4226,4194,2178,2146,2146,2146,2145,2146,2146,2146,65,65,2145,4194,2146,4259,33,33,32,2113,6274,0,10466,6306,6404,8453,65,65,255},
{10830,10830,10830,10830,10829,10829,10829,10829,10830,10830,10829,10797,10797,10797,10829,10797,10797,10797,10829,10829,10829,10797,10797,10797,10797,10829,10797,10797,10797,10797,10797,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10797,10797,10796,10797,10797,10796,10797,10796,10796,10796,10796,10764,10731,10763,8650,8551,8550,10598,12711,8453,6405,10565,14725,35592,35334,28867,16514,6274,8354,35074,59875,61859,45313,22656,22689,26948,20705,20705,12417,12482,26979,16610,16610,26913,20738,8419,10500,8354,4258,4226,2146,2178,2146,2146,2178,2146,2146,2146,2146,2146,65,2114,4226,2178,2178,33,32,32,2113,6306,33,14594,6273,8517,8518,65,65,255},
{10830,10830,10830,10830,10830,10829,10829,10829,10829,10829,10829,10797,10829,10829,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10829,10797,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10830,10829,10829,10829,10829,10829,10797,10797,10796,10796,10797,10796,10796,10796,10796,10796,10796,10796,10764,10731,10764,10731,6438,8518,12711,8485,4259,6372,8485,16806,42093,39883,18692,14564,18692,33221,35300,52264,56359,41475,29027,29059,28995,33154,41411,35362,33409,43745,45986,44134,44267,29317,16804,23075,10466,8419,4227,2146,2178,2178,2146,2178,2146,2146,2178,4194,4292,2114,65,6274,4259,2146,33,33,33,2113,8354,65,14594,4226,6404,8485,65,65,255},
{10830,10830,10830,10829,10829,10829,10797,10797,10829,10829,10797,10797,10797,10797,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10829,10797,10797,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10797,10797,10797,10796,10796,10796,10796,10796,10796,10796,10796,10764,10796,8585,6472,6504,8617,8486,6372,10630,10598,6372,8452,8485,14693,39684,39621,20544,28931,30849,51489,58116,58280,58215,49473,28897,39233,35105,24769,24833,39617,43648,47872,52193,54501,56975,35525,14723,23073,14626,12579,4226,2178,2178,2179,2178,2178,2146,2146,4226,4226,6372,2145,65,4226,6340,2146,33,32,33,65,10434,2113,14626,2146,6404,6372,65,65,255},
{10830,10830,10830,10829,10829,10797,10797,10797,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10829,10797,10797,10797,10797,10796,10796,10796,10796,10796,10796,10796,10796,10764,10764,10764,8618,8585,6537,8584,6405,6339,8452,12711,10566,10565,10598,14693,29155,31236,14465,18593,43201,57472,61826,62052,62116,47328,16512,20608,22721,10433,14691,35490,39457,43649,58273,56576,59048,35492,14625,25121,14626,12546,4259,4226,2178,4227,2178,2178,2146,2178,4226,4226,6372,65,97,6306,6339,65,33,33,33,33,10401,4193,16674,2178,8453,4259,65,65,255},
{10830,10830,10830,10830,10829,10797,10797,10797,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10829,10797,10829,10829,10829,10829,10829,10797,10829,10829,10829,10829,10829,10829,10829,10797,10797,10796,10796,10796,10796,10796,10796,10796,10764,10764,10764,10764,10764,8682,10763,10764,10730,4292,2146,6372,8420,10598,12744,14792,18887,25094,33350,35397,39426,47520,57472,61536,55456,61568,51393,26881,20608,43361,41217,41602,31330,18721,31105,33217,37601,39843,27107,12578,18850,12546,12547,4226,4226,2178,6307,2178,2179,2178,2146,4226,6274,6340,2145,2146,10435,4194,65,33,33,33,33,10433,6273,16641,2178,8420,2179,65,65,255},
{10830,10830,10829,10829,10829,10797,10797,10797,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10829,10829,10829,10829,10829,10797,10829,10829,10829,10829,10829,10797,10829,10797,10797,10796,10796,10796,10796,10796,10764,10764,10796,10796,10764,10764,10763,10698,10763,10763,10763,6406,4292,4226,6339,6372,8485,12679,14726,22949,33285,41605,43619,47585,53505,57472,47426,35139,28962,29060,18528,32960,43361,39361,35394,12514,8354,12449,18625,16545,12482,10500,8387,10434,12515,4226,4226,2178,6307,4226,4227,2178,2178,4226,6307,6340,98,2146,10434,6274,65,33,33,33,33,12481,10401,16609,4227,8453,2146,65,65,255},
{10830,10830,10829,10829,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10829,10829,10797,10797,10797,10797,10797,10796,10796,10796,10796,10764,10764,10764,10764,10764,10764,10764,10763,10698,10763,10763,10764,10731,8585,2179,2146,2146,2178,4259,6241,16610,41509,54188,41541,31106,31041,31009,31074,26979,24899,29027,22754,20706,22786,16706,10434,8354,8289,14497,18657,16577,12481,12580,6307,10434,16611,6274,4226,2178,8355,6275,6275,4226,2178,6274,8387,6339,2146,2146,12450,10370,33,33,33,33,65,10433,14561,14529,4259,10500,2146,65,65,255},
{10830,10830,10830,10829,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,8717,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10829,10797,10829,10829,10796,10796,10797,10796,10796,10796,10796,10796,10796,10764,10764,10764,10763,10764,10763,8683,10763,10764,10731,10763,8520,2146,2146,2178,6372,6372,8321,20705,52369,61179,41608,18592,18624,24929,24897,22817,16544,22720,20640,18592,20738,10402,8387,6307,2081,10369,20705,20673,18625,20771,4227,12482,20739,8322,6274,4226,14531,8322,10402,8322,6242,8322,12515,6307,2146,2146,12482,16545,65,65,33,33,33,10433,20737,14529,6307,10501,2146,65,65,255},
{10829,10830,10830,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10796,10796,10796,10796,10796,10796,10796,10796,10796,10764,10764,10764,10764,10763,10763,10763,8683,10763,10763,8584,10731,6405,6372,6405,6405,6372,6339,8387,12482,35269,47817,31074,18624,18624,18656,20704,20704,22752,26816,34977,20640,20738,6241,6339,8452,4194,12450,20738,43426,35105,20738,6274,12482,22787,10402,8354,4226,14530,10370,12482,10370,8322,10370,16644,6274,4194,2146,12482,20673,2113,65,33,65,33,12513,26945,12449,8387,12548,66,65,2145,255},
{10829,10830,10829,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10765,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10796,10796,10796,10796,10796,10796,10764,10764,10764,10764,10764,10764,10763,10764,8683,10731,10731,10764,10763,10731,6373,10566,16938,16938,16938,16905,16937,21032,29223,31302,31270,31301,33317,33316,37378,43553,37281,28961,39233,33025,12417,6307,6339,8452,4194,12515,18657,39329,26912,16610,6274,12482,33026,45377,24866,12482,14530,12450,12450,12450,10370,10370,18691,4226,4194,4194,12482,20674,4193,65,65,65,65,16609,26977,10369,10468,10468,66,65,65,255},
{10830,10830,10830,10830,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,8717,10797,8717,10765,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10796,10796,10796,10764,10796,10796,10764,10764,10764,10764,10764,10764,10764,10764,10731,10731,10731,10796,12812,10698,4292,10631,16971,14824,14792,14825,19018,29190,45571,47652,33252,35430,37477,43816,54314,58179,43457,41473,45600,47520,28963,29191,22916,14628,2081,6241,16577,37314,26913,18657,6274,14562,22818,31042,33187,24899,24899,35234,26945,16578,10370,10370,14530,4194,4194,4194,12482,18626,8322,65,65,65,65,18657,26945,8354,12548,8419,65,66,65,255},
{10830,10798,10798,10829,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10765,10797,8717,8717,8717,8717,10797,10797,8717,8717,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10796,10796,10796,10764,10796,10796,10764,10764,10764,10764,10764,10764,10764,10764,10699,10731,10731,12844,10763,8585,4292,12711,19051,19083,19051,19051,19051,25194,29288,33384,35463,37511,41606,54021,60913,60324,47553,49600,49664,47584,37217,28994,29027,16610,2081,6241,18690,39362,28993,24898,12449,14562,18690,8322,12482,12514,20771,35266,37314,35233,31073,26945,20705,6274,4226,4194,12482,14498,6274,66,66,65,66,18657,26977,8322,12548,6339,2146,65,65,255},
{10830,10798,10798,10797,10797,10797,10797,10797,10797,10797,10797,10797,8717,8717,10797,8717,8717,8717,8716,8717,8717,8717,8717,8717,8717,10797,8717,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10796,10796,10796,10796,10764,10764,10764,10764,10764,10764,10764,10764,10764,10763,10763,10699,10731,10731,12812,10763,8585,4292,12711,19051,19084,19084,21131,21131,21163,23244,25324,27340,31435,35530,41672,47913,47847,33219,41476,47651,45603,24802,8256,8256,2081,2113,12449,31073,43393,33153,31106,20738,16610,18690,10402,10402,6242,12482,14562,24898,33218,33186,35265,33185,26978,14562,6274,14530,12482,8354,66,66,65,66,18657,24897,8322,14596,4259,2146,65,65,255},
{10830,10798,10798,10797,10797,10797,10797,10797,10797,10797,10797,8717,8717,8717,8717,8717,8717,8717,8716,8717,8717,8717,8717,8717,10797,10797,10797,8717,10797,10797,10797,10797,10797,10797,10797,10797,10797,10796,10797,10797,10797,10797,10797,10797,10797,10797,10796,10796,10796,10764,10764,10764,10764,10764,10764,10764,10764,10764,10764,10731,10731,10698,10731,10763,12844,10763,10731,6405,12679,14825,12777,14857,16906,16905,31303,49961,49897,29355,27274,31336,37610,41704,39592,25030,29257,29159,33319,24964,16545,20673,8322,2113,12417,31041,47521,39361,37378,26978,20770,22850,12482,14530,10370,14531,14563,14530,14530,18690,29058,35266,33218,31170,27010,24897,16610,10434,66,98,66,66,18689,22849,10402,16676,4226,2146,2146,2145,255},
{10830,10798,10798,10797,10797,10797,10797,10797,10797,10797,8717,8717,8717,8716,8717,8717,8716,8717,8717,8717,8717,8716,8716,8717,8717,10797,10797,8717,10797,8717,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10797,10796,10796,10796,10796,10796,10764,10764,10764,10764,10764,10764,10764,10764,10763,10731,10731,8651,10731,10763,12844,10763,10763,6438,10598,16971,19051,19051,19018,16938,27176,41673,43688,25193,23113,31270,37510,43653,39526,22982,25096,22789,33027,14497,4160,4128,4194,8387,8322,24866,47585,45504,45570,31138,24897,29058,16611,18658,12450,16643,16643,16611,14531,12450,14530,26978,31106,35299,33218,35298,37313,33185,16642,6306,98,98,22849,22849,12482,18724,4194,2146,2146,2145,255},
{10829,10798,10798,10797,10797,10797,10797,10797,10797,10797,8717,8716,8717,8717,8716,8716,8716,8717,8717,8717,8716,8716,8716,8716,8716,8716,8716,8717,10797,10797,10797,10797,10797,10765,10796,10796,10797,10765,10797,10797,10797,10797,10797,10797,10797,10796,10796,10796,10764,10764,10764,10764,10764,10764,10764,10764,10732,10732,10731,10731,10731,10699,10731,10763,12812,10763,10731,6373,10566,16938,16970,17003,19083,19018,23146,29420,29453,27405,25226,27307,33516,35563,35498,22983,25096,25032,22917,8257,4096,4096,10337,20803,24898,37249,47713,51616,51681,43522,29025,35267,24899,20771,14530,20771,20739,20771,18690,16611,16610,26947,14498,24899,37348,45635,47649,45568,41440,35265,22881,12513,31137,22817,14563,18756,2146,2146,2146,2146,255},
{10829,10797,10797,10797,10797,10797,10797,10797,10797,8717,8717,8716,8717,8717,8716,8716,8716,8716,8717,8716,8716,8716,8716,8717,8716,8716,8716,8717,8717,8717,10797,10796,10764,10765,10765,10764,10764,10764,10764,10796,10797,10797,10797,10796,10796,10796,10796,10796,10764,10764,10764,10764,10764,10764,10764,10731,10731,10731,10731,10731,10731,10731,10731,10763,10763,10763,10665,6405,10566,14858,14825,14857,16905,19018,39495,55974,57991,39560,25193,25094,31335,29157,29191,20902,23048,10403,16642,22818,12385,6176,10369,8289,14497,28994,49892,57761,51713,51746,37281,41443,33155,29027,18690,29027,24899,26946,26946,22818,20771,33155,16611,12450,22852,37283,49665,51745,47616,49728,43520,39393,41440,22785,20771,20803,2146,12580,4258,2146,255}
};

const bool Inscription PROGMEM [154][20] = {
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1},
{1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,1},
{0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1},
{1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1},
{1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,1,1},
{1,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1},
{1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1},
{1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,1},
{1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1},
{1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,1},
{1,1,1,1,1,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1},
{1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,1},
{0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1},
{0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1},
{1,1,1,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1},
{1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1},
{0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1},
{0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,1,1,1,1},
{0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
{1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1}
};

void draw_lock_screen(){
  for (int i = 0; i < 160; i++){
    for (int j = 0; j < 128; j++){
      tft.drawPixel(i, j, Dublin[i][j]);
    }
  }
}

void setup() {
  tft.initR(INITR_BLACKTAB);
  tft.setRotation(1);
  tft.fillScreen(0x0000);
  draw_lock_screen();
  disp_centered_text("Power The Transmitter Up", 115);
  for (int i = 0; i < 154; i++) {
    for (int j = 0; j < 19; j++) {
      if (Inscription[i][j] == 0)
        tft.drawPixel(i + 3, j + 8, Dublin[(esp_random() % 160)][esp_random() % 128]);
    }
  }
}

int c, v;
void loop() {
    c = esp_random() % 154;
    v = esp_random() % 19;
    if (Inscription[c][v] == 0){
      tft.drawPixel(c + 3, v + 8, Dublin[(esp_random() % 160)][esp_random() % 128]);
    }
}
