# Copyright (c) 2020 Moritz Dederichs


from ast import literal_eval


def parse_split_solution_to_pfsp(file_path: str) -> list:
    with open(file_path) as file:
        content = literal_eval(file.read())
    items_to_pack = list()
    for order, boxes in content.items():
        for box in boxes.keys():
            items_to_pack.append(box[0])
    return sorted(items_to_pack, reverse=True)
