# Copyright (c) 2020 Janos Piddubnij

import csv


def parse_boxes(input_file: str, delimiter: str = ';', encoding: str = 'utf-16') -> dict:
    boxes = dict()
    with open(input_file, 'r', encoding=encoding) as file:
        reader = csv.reader(file, delimiter=delimiter)
        next(reader)
        for row in reader:
            box = row[0].strip()
            length = int(row[1])
            width = int(row[2])
            height = int(row[3])
            boxes[box] = (length, width, height)
    return boxes

