# Copyright (c) 2020 Luca Koczula
# Copyright (c) 2020 Tobias Wagner

class Item:
    """
    Each object of this class represents an item placed by the Genetic Algorithm Best Match Heuristic.
    An item is defined by its' name, its' exact placement inside the box and the box name.
    """

    def __init__(self, name, box, x_coor, y_coor, z_coor, x_dim, y_dim, z_dim, width, length, height):
        self.name = name
        self.box = box
        self.min_x = x_coor
        self.min_y = y_coor
        self.min_z = z_coor
        self.max_x = x_coor + x_dim
        self.max_y = y_coor + y_dim
        self.max_z = z_coor + z_dim
        self.min_coordinate = [x_coor, y_coor, z_coor]
        self.max_coordinate = [x_coor + x_dim, y_coor + y_dim, z_coor + z_dim]
        self.length = length
        self.width = width
        self.height = height
