# Copyright (c) 2020 Luca Koczula
# Copyright (c) 2020 Tobias Wagner

class EMS:
    """
    Each object of this class represents an Empty Maximal Space.
    An Empty Maximal Space is characterized by the box, its' coordinate placement and its' volume.
    """

    def __init__(self, box, max_x, max_y, max_z, min_x, min_y, min_z):
        self.box = box
        self.max_x = max_x
        self.max_y = max_y
        self.max_z = max_z
        self.min_x = min_x
        self.min_y = min_y
        self.min_z = min_z
        self.length = max_x - min_x
        self.width = max_y - min_y
        self.height = max_z - min_z
        self.volume = self.length * self.height * self.width
        self.min_vertex = [min_x, min_y, min_z]
        self.min_vertex.sort()
