# Copyright (c) 2020 Luca Koczula
# Copyright (c) 2020 Tobias Wagner

class Chromosome:
    """
    An object of this class represents a specific chromosome of the genetic algorithm.
    Each chromosome contains a Box Packing Sequence (BPS), a Container Loading Sequence (CLS).
    Furthermore, this class stores the chromosomes' Generation Id, its' fitness and the packing sequence calculated
    by the heuristic.
    """

    def __init__(self, BPS, CLS, generation, fitness=None, cost=None, packing_sequence=None):
        self.BPS = BPS
        self.CLS = CLS
        self.generation = generation
        self.fitness = fitness
        self.cost = cost
        self.packing_sequence = packing_sequence

    def set_fitness(self, fitness):
        """ Function to set the fitness of the chromosome.

        Parameters
        ----------
        fitness
            Fitness of the chromosome.

        Returns
        -------

        """
        self.fitness = fitness

    def set_costs(self, cost):
        """ Function to set the cost of the chromosome.

        Parameters
        ----------
        cost
            Cost of the chromosome.

        Returns
        -------

        """
        self.cost = cost

    def set_packing_sequence(self, packing_sequence):
        """ Function to set the packing sequence of the chromosome.

        Parameters
        ----------
        packing_sequence
            Packing Sequence of the chromosome.

        Returns
        -------

        """
        self.packing_sequence = packing_sequence
