# -*- coding: utf-8 -*-
"""Item data type."""


#  Copyright (c) 2020.  Yordan Manolov <yordan DOT manolov AT rwth DASH aachen DOT de >
#


class Item:
    """Item custom data type with (supposedly) pretty formatting."""

    def __init__(self, identifier: str, count: int, length: int, width: int, height: int, weight: int):
        self.identifier = identifier
        self.count = count
        self.length = length
        self.width = width
        self.height = height
        self.weight = weight
        self.volume = length * width * height
        self.area = length * width

    def get_id(self) -> str:
        """

        Returns
        -------
        The ID of the item
        """
        return self.identifier

    def get_count(self) -> int:
        """
        Returns
        -------
        int
            The number of items with the same ID (within one order).
        """
        return self.count
